<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Payment</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Payment</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Payment Information</h3>
              </div>

              <div class="card-body">
                <form method="POST" action="<?php echo base_url() ?>Receipt/save_paid_pay" enctype='multipart/form-data' >
                    <div class="row">
                    <div class="form-group col-md-5 col-sm-5 col-12">
                      <label style="color: #5B99C2;">Select Suppliers *</label>
                      <div class="input-group input-group-sm">
                        <select name="supplierID" id="supplierID" class="form-control select2" required >
                        </select>
                      </div>
                    </div>
                </div>
                    <div class="card-body">
                        <table class="table table-bordered" >
                          <thead>
                            <tr>
                              <th style="width: 5%;"><input type="checkbox" id="select-all" ></th>
                              <th>Invoice No.</th>
                              <th>Total Amount</th>
                              <th style="color:green;">Paid Amount</th>
                              <th style="color:red;">Due Amount</th>
                            </tr>
                          </thead>
                          <tbody id="dueinv">
                              
                          </tbody>
                          <tbody>
                              <tr>
                                  <td colspan="4" style="text-align:right;"><b>Payable Method: </b></td>
                                  <td>
                                      <select class="form-control" name="accountType" id="accountType" required >
                                        <option value="">Select One</option>
                                        <option value="Cash">Cash</option>
                                        <option value="Bank">Bank</option>
                                        <option value="Mobile">Mobile</option>
                                      </select>
                                  </td>
                              </tr>
                              <tr>
                                  <td colspan="4" style="text-align:right;"><b>Payable Account: </b></td>
                                  <td>
                                      <select class="form-control" name="accountNo" id="accountNo" required >
                                        <option value="">Select One</option>
                                      </select>
                                  </td>
                              </tr>
                              <tr>
                                  <td colspan="4" style="text-align:right;"><b>Paid Amount: </b></td>
                                  <td>
                                      <input type="text" name="amount" id="paid" onkeyup='calculate_remain();' class="form-control"  value="0">
                                  </td>
                              </tr>
                              <tr>
                                  <td colspan="4" style="text-align:right;"><b>Payment Remarks: </b></td>
                                  <td>
                                      <input type="text" name="remarks" class="form-control" placeholder="Payment Remarks">
                                  </td>
                              </tr>
                              <tr>
                                  <td colspan="4" style="text-align:right;"><b>Date: </b></td>
                                  <td>
                                      <input type="text" name="date" class="form-control datepicker" value="<?php echo date('m/d/Y') ?>">
                                  </td>
                              </tr>
                              <tr>
                                  <td colspan="4" style="text-align:right;"><b>Remaining: </b></td>
                                  <td>
                                      <input type="text" name="remains" id="remains" value="0" class="form-control" readonly>
                                  </td>
                              </tr>
                          </tbody>
                        </table>
                    </div>
                    <div class="form-group col-md-12 col-sm-12 col-xs-12" style="margin-top:20px; text-align: center;">
                        <button type="submit" class="btn btn-info" onclick="this.form.submit(); this.disabled = true;" ><i class="far fa-save"></i>&nbsp;&nbsp;Submit</button>
                        <a href="<?php echo site_url('Payment') ?>" class="btn btn-danger" ><i class="fa fa-arrow-left" ></i>&nbsp;&nbsp;Back</a>
                    </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>


<?php $this->load->view('footer/footer'); ?>
    <script type="text/javascript" >
        $(document).ready(function(){
          $('#supplierID').change(function(){
            var url = "<?php echo base_url(); ?>Receipt/get_pay_due_inv";
            var id = $('#supplierID').val();
            //alert(id);alert(id2);
            $.ajax({
              method: "POST",
              url     : url,
              dataType: 'json',
              data    : {'id':id},
              success:function(data){ 
              //alert(data);
              if (data.length === 0) {
                        // If no invoices are found, show an alert and return
                        alert('No due invoices found for this supplier.');
                        // $("#customerID").val('');
                        return;  // Stop further execution
                    }
              var HTML = '';
              var sum= 0;
              for (var key in data) 
                {
                sum += parseFloat(data[key]['due']);
                var value = (sum).toLocaleString(undefined,{ minimumFractionDigits: 2 });
                HTML +='<tr>'+
                            '<td>'+'<input type="checkbox" class="row-checkbox" name="checkbox[]" value="'+data[key]['purchaseID']+'"><input type="hidden" name="pamount[]" value="'+data[key]['paidAmount']+'"></td>'+
                            '<td>'+ data[key]['challanNo']+'</td>'+
                            '<td>'+ (parseFloat(data[key]['totalPrice'])).toLocaleString(undefined,{ minimumFractionDigits: 2 })+'</td>'+
                            '<td>'+ (parseFloat(data[key]['paidAmount'])).toLocaleString(undefined,{ minimumFractionDigits: 2 })+'</td>'+
                            '<td class="due-amount"><input type="hidden" id="due" name="damount[]" value="'+data[key]['due']+'">'+ (parseFloat(data[key]['due'])).toLocaleString(undefined,{ minimumFractionDigits: 2 })+'</td>'+
                        '</tr>';
                  }
                  HTML+='<tr>'+
                            '<td colspan="4" style="text-align:right;"><b>Payable Due: </b></td>'+
                            '<td style="font-weight:bold;"><input type="text" name="total" id="totalAmount" value="0" class="form-control" readonly></td>'
                            // '<td style="font-weight:bold;" id="totalAmount">'+value+'</td>'
                        ;
                //   console.log(sum);
              $("#dueinv").html(HTML);
              
              // Bind event to dynamically added checkboxes
                    $('input[type="checkbox"]').change(function() {
                        calculateTotal();
                        calculate_remain();
                    });
                },
              error:function(data){
              alert('error');
              }
            });
            
          });
          $('#paid').on('input', calculate_remain); // <-- Add this line here
        });
      </script>
    <script type="text/javascript" >

            function calculateTotal() {
                let total = 0;
                // Iterate over all checked checkboxes
                $('input[type="checkbox"].row-checkbox:checked').each(function() {
                    // Find the due amount in the same row and add it to total
                    const dueAmount = parseFloat($(this).closest('tr').find('.due-amount').text().replace(/,/g, ''));
                    console.log(dueAmount);
                    total += dueAmount;
                });
                // Update the total displayed
                $('#totalAmount').val(total.toFixed(2));
            }
    </script>
    <script type="text/javascript">
        $('#select-all').click(function(event){   
          if(this.checked){
            $(':checkbox').each(function(){
              this.checked = true;                        
              });
            }
          else
            {
            $(':checkbox').each(function(){
              this.checked = false;                       
              });
            }
          });
      </script>

    <script type="text/javascript" >
      $(function(){
        load_suppliers();
        function load_suppliers(){
          var url = "<?php echo base_url()?>Purchase/get_purchase_supplier";
          //alert(url);
          $.ajax({
            type:'POST',
            url: url,       
            dataType: 'json',
            success:function(data){
            //alert(data);
              var HTML = "<option value=''>Search by Supplier or Mobile</option>";
              for (var key in data) 
                {
                if (data.hasOwnProperty(key))
                  {
                  HTML +="<option value='"+data[key]["supplierID"]+"'>" + data[key]["supplierName"]+' ( '+data[key]["mobile"]+' ) '+"</option>";
                  }
                }
              $("#supplierID").html(HTML);
              }
            });
          }

        // $("#pbsubmit").click(function(){
        //   var customerName = $("#customerName").val();
        //   var mobile = $("#mobile").val();
        //   var email = $("#email").val();
        //   var address = $("#address").val();
        //   var balance = $("#balance").val();
        //   var dataString = 'customerName='+ customerName + '&mobile='+ mobile + '&email='+ email + '&address='+ address + '&balance='+ balance;
        //   // AJAX Code To Submit Form.
        //   $.ajax({
        //     type: "POST",
        //     url: "<?php echo site_url('Customer/add_customer') ?>",
        //     data: dataString,
        //     cache: false,
        //     success: function(result){
        //       //alert(result);
        //       load_suppliers();
        //       $(".card-body").css({ overflow:"auto" });
        //       $('#customer_add').remove();
        //       $('.modal-backdrop').remove();
        //       }
        //     });
        //   return false;
        // });
      });
      
    </script>
    
    <!--<script type="text/javascript">-->
    <!--    function calculate_remain(){-->
    <!--        var paid = $('#paid').val();-->
    <!--        var total = $('#totalAmount').val();-->
    <!--        var remaining = parseFloat(total).toFixed(2)-parseFloat(paid).toFixed(2);-->
    <!--        $('#remains').val(remaining);-->
    <!--        }-->
    <!--</script>-->
    <script type="text/javascript">
        function calculate_remain() {
            var paid = parseFloat($('#paid').val()) || 0; // Get paid value or default to 0 if empty
            var total = parseFloat($('#totalAmount').val()) || 0; // Get total amount or default to 0
            var remaining = total - paid;
        
            if (paid > total) {
                alert("Paid amount cannot be more than the total due amount.");
                $('#paid').val(total.toFixed(2)); // Reset paid amount to the total due if it exceeds the total
                remaining = 0; // Since paid is now equal to total, remaining is 0
            }
        
            $('#remains').val(parseFloat(remaining).toFixed(2)); // Update the remaining value
        }
    </script>
    
    <script type="text/javascript">
      $('#accountType').on('change',function(){
        var value = $(this).val();
        $('#accountNo').empty();
        getAccountNo(value, '#accountNo');
        });
        
        function getAccountNo(value,place){
          $(place).empty();
          if(value != ''){
            $.ajax({
              url: '<?php echo site_url()?>Voucher/getAccountNo',
              async: false,
              dataType: "json",
              data: 'id=' + value,
              type: "POST",
              success: function (data){
                $(place).append(data);
                $(place).trigger("chosen:updated");
                }
              });
            }
          else
            {
            customAlert('Please Select Account Type', "error", true);
            }
          }
    </script>

    <script type="text/javascript">
      $(function(){
        $(".select2").select2();
      });
    </script>