<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

<style>
    body {
        font-size: 1.1rem;
    }

    .bordered-table {
        border: 2px solid black !important;
    }

    .center-text {
        text-align: center;
    }

    .right-text {
        text-align: right;
    }

    .gray-background {
        background: #3e3c3c !important;
        color: white !important;
    }

    .text-uppercase {
        text-transform: uppercase;
    }

    .qrcode {
        margin-top: 20px;
        text-align: right;
    }
    /* Apply to entire table structure */
    table {
        width: 100%;
        border-collapse: collapse;
    }

    .bordered-table th, .bordered-table td {
        border: 2px solid black !important;
        padding: 8px !important;
    }
    

}
    
</style>

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Purchase Bill</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
                        <li class="breadcrumb-item active">Purchase</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="invoice p-3 mb-3">
                                <div id="print">
                                        <div class="row invoice-info" style="display:flex;align-items:center;">
                                          <div class="col-sm-2 col-2 invoice-col text-right">
                                            <?php if($company){ if($company->com_logo){?>
                                            <img src="<?php echo base_url().'upload/company/'.$company->com_logo; ?>" style="height:auto; width: 170px;">
                                            <?php } } ?>
                                          </div>
                                          <div class="col-sm-8 col-8 invoice-col text-center">
                                              <?php if($company){ ?><h3 style="text-transform:uppercase; font-size: 41pt !important;">
                                                  <b><?php echo $company->com_name; ?></b></h3><?php } ?>
                                            <address style="line-height:1.3;font-size:13pt !important;"?>
                                              <?php echo $company->com_address; ?><br>
                                              Email ID: <?php echo $company->com_email; ?> Web: metler.com.bd<br>
                                              Cell : <?php echo $company->com_mobile; ?> Phone: 02 9512495
                                            </address>
                                          </div>
                                          <div class="col-sm-2 col-2 invoice-col"></div>
                                        </div>
                                        <div class="row text-center bordered-table" style="margin-top: 20px;background: #3e3c3c">
                                            <div class="col-md-12">
                                                <h5 class="text-uppercase" style="color:white;"><b>Purchase Bill</b></h5>
                                            </div>
                                        </div>
                                        <div class="row invoice-info" style="display:flex; align-items:center;">
                                            <div class="col-sm-9 col-9 invoice-col text-left" style="font-size:1.1rem;">
                                                 <p><strong>Invoice Number:</strong> <?php echo $purchase['challanNo']; ?></p>
                                                <p><strong>Name:</strong> <?php echo $purchase['supplierName']; ?></p>
                                                <p><strong>Address:</strong> <?php echo $purchase['address']; ?></p>
                                                <p><strong>Phone No:</strong> <?php echo $purchase['sMobile']; ?></p>
                                            </div>
                                        <div class="border-line"></div>
                                            <div class="col-sm-3 col-3 invoice-col ml-auto text-left"
                                                style="text-align: left;">
                                               <p><strong>Order Date:</strong>
                                               <?php echo date('l, d F Y', strtotime($purchase['purchaseDate'])); ?></p>
                                                <p><strong>Time:</strong> <?php echo date('h:i A', strtotime($purchase['purchaseDate'])); ?></p>
                                                <p><strong>Sold By:</strong> MD: Alamin</p>
                                                <p><strong>Sold From:</strong> METLER CORPORATION</p>
                                            </div>
                                            </div>
    
                                            <div class="col-md-12 col-sm-12 col-12">
                                        <div class="row invoice-info">
                                                <h5><b>Bill Details</b></h5>
                                                <table class="table table-bordered bordered-table">
                                                    <thead>
                                                        <tr>
                                                            <th>SL</th>
                                                            <th>Item Name</th>
                                                            <th>Unit</th>
                                                            <th>Brand Name</th>
                                                            <th>SN/Code</th>
                                                            <th>Quantity</th>
                                                            <th class="right-text">Unit Price</th>
                                                            <th class="right-text">Discount</th>
                                                            <th class="right-text">Total Price</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                        $i = 0;
                                                        $stotal = 0;
                                                        foreach ($pproduct as $value) {
                                                            $i++;
                                                            $totalPrice = $value['quantity'] * $value['pprice'];
                                                            $stotal += $totalPrice;
                                                        ?>
                                                        <tr>
                                                            <td><?php echo $i; ?></td>
                                                            <td><?php echo $value['productName']; ?></td>
                                                            <td><?php echo $value['unitName']; ?></td>
                                                            <!--<td><?php echo $value['brandName']; ?></td>-->
                                                            <td>Metler</td>
                                                            <td></td>
                                                            <!--<td><?php echo $value['serialNo']; ?></td>-->
                                                            <td><?php echo round($value['quantity']); ?></td>
                                                            <td class="right-text"><?php echo number_format($value['pprice'], 2); ?></td>
                                                            <!--<td class="right-text"><?php echo number_format($value['discount'], 2); ?></td>-->
                                                            <td class="right-text">0</td>
                                                            <td class="right-text"><?php echo number_format($totalPrice, 2); ?></td>
                                                        </tr>
                                                        <?php } ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
    
                                        <div class="row">
                                            <div class="col-md-6">
                                                <!--<p><strong>In Words:</strong> <?php echo convertNumber($stotal); ?> ONLY</p>-->
                                            </div>
                                            <div class="col-md-6 right-text">
                                                <table class="table table-bordered bordered-table">
                                                    <tr>
                                                      
                                                        <td><strong>Discount %</strong></td>
                                                        <!--<td class="right-text"><?php echo number_format($purchase['discountPercentage'], 2); ?>%</td>-->
                                                        <td>0.00</td>
                                                    </tr>
                                                    <tr>
                                                        <td><strong>Total Discount</strong></td>
                                                        <!--<td class="right-text"><?php echo number_format($purchase['totalDiscount'], 2); ?></td>-->
                                                        <td>0.00</td>
                                                    </tr>
                                                    <tr>
                                                        <td><strong>Grand Total</strong></td>
                                                        <td class="right-text"><strong><?php echo number_format($stotal, 2); ?></strong></td>
                                                    </tr>
                                                    <tr>
                                                        <td><strong>Paid</strong></td>
                                                        <td class="right-text"><?php echo number_format($purchase['paidAmount'], 2); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td><strong>Due</strong></td>
                                                        <td class="right-text"><?php echo number_format($purchase['due'], 2); ?></td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
    
                                        <div class="row">
                                            <div class="col-md-6">
                                                <p style="border: 1px solid; width: 100%; height: 50px;">
                                                    <strong>In Words: <?php echo convertNumber($stotal); ?></strong></p>
                                                <p style="border: 1px solid; width: 100%; height: 50px;"><strong>Remarks:</strong></p>
                                            </div>
                                        </div>

                                </div>
                                <div class="row no-print">
                                    <div class="col-12 text-center">
                                        <a href="javascript:void(0)" class="btn btn-primary" onclick="printFn('print')"><i class="fas fa-print"></i> Print</a>
                                        <a href="<?php echo site_url('Purchase') ?>" class="btn btn-danger"><i class="fas fa-arrow-left"></i> Back</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php $this->load->view('footer/footer'); ?>

<script type="text/javascript">
  function printFn(divName) {
    // Show the header and hide the print button
    $('#header').show();
    $('#thwprint').hide();

    // CSS to be applied during print
    var style = `
      <style>
        body {
          font-size: 1.1rem;
        }
        .bordered-table {
          border: 2px solid black !important;
        }
        .center-text {
          text-align: center;
        }
        .right-text {
          text-align: right;
        }
        .gray-background {
          background: #3e3c3c !important;
          color: white !important;
        }
        .text-uppercase {
          text-transform: uppercase;
        }
        .qrcode {
          margin-top: 20px;
          text-align: right;
        }
        @media print {
    .gray-background {
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
        background: #3e3c3c !important;
        color: white !important;
    }
    @media print {
    /* Force print-specific CSS */
    .gray-background{
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
        background-color: #3e3c3c !important;
        color: white !important;
        border: 2px solid black !important;
    }

    /* Apply to entire table structure */
    table {
        width: 100%;
        border-collapse: collapse;
    }

    .bordered-table th, .bordered-table td {
        border: 2px solid black !important;
        padding: 8px !important;
    }

}
      </style>`;

    // Get the content of the specified div
    var printContents = document.getElementById(divName).innerHTML;
    
    // Save the original content of the body
    var originalContents = document.body.innerHTML;
    // console.log(style + printContents);
    // Set the body's content to the print contents + styles
    document.body.innerHTML = style + printContents;
    
    // Trigger the print dialog
    window.print();
    
    // Restore the original body content after printing
    document.body.innerHTML = originalContents;
    
    // Optionally, hide the header and show the print button again after printing
    $('#header').hide();
    $('#thwprint').show();
  }
</script>


<?php
      function convertNumber($number){
        $words = array(
          '0'=> '' ,'1'=> 'one' ,'2'=> 'two' ,'3' => 'three','4' => 'four','5' => 'five','6' => 'six','7' => 'seven','8' => 'eight','9' => 'nine','10' => 'ten','11' => 'eleven','12' => 'twelve','13' => 'thirteen','14' => 'fouteen','15' => 'fifteen','16' => 'sixteen','17' => 'seventeen','18' => 'eighteen','19' => 'nineteen','20' => 'twenty','30' => 'thirty','40' => 'fourty','50' => 'fifty','60' => 'sixty','70' => 'seventy','80' => 'eighty','90' => 'ninty');
    
        $number_length = strlen($number);

        $number_array = array(0,0,0,0,0,0,0,0,0);        
        $received_number_array = array();
    
        for($i=0;$i<$number_length;$i++)
          {    
          $received_number_array[$i] = substr($number,$i,1);    
          }
        
        for($i=9-$number_length,$j=0;$i<9;$i++,$j++)
          { 
          $number_array[$i] = $received_number_array[$j]; 
          }
        $number_to_words_string = "";

        for($i=0,$j=1;$i<9;$i++,$j++)
          {
          if($i==0 || $i==2 || $i==4 || $i==7)
            {
            if($number_array[$j]==0 || $number_array[$i] == "1")
              {
              $number_array[$j] = intval($number_array[$i])*10+$number_array[$j];
              $number_array[$i] = 0;
              }
            }
          }
        $value = "";
        for($i=0;$i<9;$i++)
          {
          if($i==0 || $i==2 || $i==4 || $i==7)
            {    
            $value = $number_array[$i]*10; 
            }
          else
            { 
            $value = $number_array[$i];    
            }            
          if($value!=0)
            {
            $number_to_words_string.= $words["$value"]." ";
            }
          if($i==1 && $value!=0)
            {
            $number_to_words_string.= "Crores ";
            }
          if($i==3 && $value!=0)
            {
            $number_to_words_string.= "Lakhs ";
            }
          if($i==5 && $value!=0)
            {
            $number_to_words_string.= "Thousand ";
            }
          if($i==6 && $value!=0)
            {
            $number_to_words_string.= "Hundred ";
            }            
          }
        if($number_length>9)
          {
          $number_to_words_string = "Sorry This does not support more than 99 Crores";
          }
        return ucwords(strtolower($number_to_words_string)." Taka Only.");
        }
    ?>
