<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Customer Ledger</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?= base_url(); ?>Dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Customer Ledger</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Customer Ledger</h3>
              </div>

              <div class="card-body">
                <div class="col-sm-12 col-md-12 col-12">
                  <form action="<?= base_url() ?>cusLedger" method="get">
                    <div class="col-md-12 col-sm-12 col-12">
                      <div class="form-group">
                        <b>
                          <input type="radio" name="reports" value="ocust" id="ocust" required >&nbsp;&nbsp;Customer All Ledger&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                          <input type="radio" name="reports" value="dailyReports" id="daily" required >&nbsp;&nbsp;Daily Ledger&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                          <input type="radio" name="reports" value="monthlyReports" id="monthly" required >&nbsp;&nbsp;Monthly Ledger&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                          <input type="radio" name="reports" value="yearlyReports" id="yearly" required >&nbsp;&nbsp;Yearly Ledger
                        </b>
                      </div>

                      <div class="d-none" id="dreports">
                        <div class="row">
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Start Date *</label>
                            <input type="date" class="form-control" name="sdate" value="<?= date('m/d/Y') ?>" id="sdate" required="" >
                          </div>
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>End Date *</label>
                            <input type="date" class="form-control" name="edate" value="<?= date('m/d/Y') ?>" id="edate" required="" >
                          </div>
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Customer *</label>
                            <select name="dcustomer" class="form-control select2" id="dcustomer" required="" style="width: 100%;" >
                              <option value="">Select One</option>
                              <?php foreach ($customer as $value) { ?>
                              <option value="<?= $value['customerID']; ?>" ><?= $value['customerName'].' ( '.$value['mobile'].' )'; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <div class="form-group col-md-2 col-sm-2 col-12">
                            <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus" ></i>&nbsp;Search</button>
                          </div>
                        </div>
                      </div>

                      <div class="d-none" id="mreports">
                        <div class="row">
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Month *</label>
                            <select class="form-control" name="month" id="month" required="" >
                              <option value="">Select Month</option>
                              <option value="01">January</option>
                              <option value="02">February</option>
                              <option value="03">March</option>
                              <option value="04">April</option>
                              <option value="05">May</option>
                              <option value="06">June</option>
                              <option value="07">July</option>
                              <option value="08">August</option>
                              <option value="09">September</option>
                              <option value="10">October</option>
                              <option value="11">November</option>
                              <option value="12">December</option>
                            </select>
                          </div>
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Year *</label>
                            <select class="form-control" name="year" id="year" required="" >
                              <?php $d = date("Y"); ?>
                              <option value="">Select One</option>
                              <?php for ($x = 2020; $x <= $d; $x++) { ?>
                              <option value="<?= $x; ?>"><?= $x; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Customer *</label>
                            <select name="mcustomer" class="form-control select2" id="mcustomer" required="" style="width: 100%;" >
                              <option value="">Select One</option>
                              <?php foreach ($customer as $value) { ?>
                              <option value="<?= $value['customerID']; ?>" ><?= $value['customerName'].' ( '.$value['mobile'].' )'; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <div class="form-group col-md-2 col-sm-2 col-12">
                            <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus" ></i>&nbsp;Search</button>
                          </div>
                        </div>
                      </div>

                      <div class="d-none" id="yreports">
                        <div class="row">
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Year *</label>
                            <select class="form-control" name="ryear" id="ryear" required="" >
                              <?php $d = date("Y"); ?>
                              <option value="">Select One</option>
                              <?php for ($x = 2020; $x <= $d; $x++) { ?>
                              <option value="<?= $x; ?>"><?= $x; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Customer *</label>
                            <select name="ycustomer" class="form-control select2" id="ycustomer" required="" style="width: 100%;" >
                              <option value="">Select One</option>
                              <?php foreach ($customer as $value) { ?>
                              <option value="<?= $value['customerID']; ?>" ><?= $value['customerName'].' ( '.$value['mobile'].' )'; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <div class="form-group col-md-2 col-sm-2 col-12">
                            <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus" ></i>&nbsp;Search</button>
                          </div>
                        </div>
                      </div>

                      <div class="d-none" id="reports">
                        <div class="row">
                          <div class="form-group col-md-3 col-sm-3 col-12">
                            <label>Select Customer *</label>
                            <select name="customer" class="form-control select2" id="customer" required="" style="width: 100%;" >
                              <option value="">Select One</option>
                              <?php foreach ($customer as $value) { ?>
                              <option value="<?= $value['customerID']; ?>" ><?= $value['customerName'].' ( '.$value['mobile'].' )'; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <div class="form-group col-md-2 col-sm-2 col-12">
                            <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus" ></i>&nbsp;Search</button>
                          </div>
                        </div>
                      </div>

                    </div>
                  </form>
                </div><hr>

                <div class="box-body">
                  <div id="print">
                    <div class="row" id="header" style="display: none" >
                      <div class="col-sm-2 col-md-2 col-2" style="margin-top: 30px;">
                        <img src="<?php echo base_url().'upload/company/'.$company->com_logo; ?>"  style="width: 100%;">
                      </div>
                      <div class="col-sm-10 col-md-10 col-10">
                        <div class="col-sm-12 col-md-12 col-12">
                          <h3><b><?= $company->com_name; ?></b></h3>
                        </div>
                        <div class="col-sm-12 col-md-12 col-12">
                          <b>Address&nbsp;&nbsp;:&nbsp;&nbsp;<?= $company->com_address; ?></b>
                        </div>
                        <div class="col-sm-12 col-md-12 col-12">
                          <b>Email&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;<?= $company->com_email; ?></b>
                        </div>
                        <div class="col-sm-12 col-md-12 col-12">
                          <b>Mobile&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;<?= $company->com_mobile; ?></b>
                        </div>
                      </div>
                    </div>
                  <?php if(isset($_GET['search'])) { ?>
                    <div class="col-sm-12 col-md-12 col-12">
                      <!--<div class="col-sm-12 col-md-12 col-12">-->
                      <!--  Customer ID&nbsp;&nbsp;:&nbsp;&nbsp;<?= $cust[0]['customerID']; ?>-->
                      <!--</div>-->
                      <div class="col-sm-12 col-md-12 col-12">
                        Customer Name&nbsp;&nbsp;:&nbsp;&nbsp;<?= $cust[0]['customerName']; ?>
                      </div>
                      <div class="col-sm-12 col-md-12 col-12">
                        Address&nbsp;&nbsp;:&nbsp;&nbsp;<?= $cust[0]['address']; ?>
                      </div>
                      <div class="col-sm-12 col-md-12 col-12">
                        Contact No&nbsp;&nbsp;:&nbsp;&nbsp;<?= $cust[0]['mobile']; ?>
                      </div>
                    </div>
                    <?php if ($report == 'dailyReports') { ?>
                    <div class="box-header" style="text-align: center;">
                      <h3 class="box-title"><b>Customer Ledger Reports in : <?= $sdate.' - '.$edate; ?></b></h3>
                    </div>
                    <?php } else if ($report == 'monthlyReports') { ?>
                    <div class="box-header" style="text-align: center;">
                      <h3 class="box-title"><b>Customer Ledger Reports in : <?= $name.' '.$year; ?></b></h3>
                    </div>
                    <?php } else if ($report == 'yearlyReports') { ?>
                    <div class="box-header" style="text-align: center;">
                      <h3 class="box-title"><b>Customer Ledger Reports in : <?= $year; ?></b></h3>
                    </div>
                    <?php } ?>
                  
                    <div id="table-content">
                      <table id="" class="table table-bordered table-striped">
                        <thead>
                          <tr>
                            <!--<th>#SN.</th>-->
                            <th>Date</th>
                            <th>INV / REC No.</th>
                            <!--<th>Particulars</th>-->
                            <!--<th>Invoice Value</th>-->
                            <!--<th>Discount</th>-->
                            <th>Receive num.</th>
                            <th>Sales Amount</th>
                            <!--<th>Rec. No.</th>-->
                            <!--<th>Opening Balance</th>-->
                            <th>Balance</th>
                          </tr>
                        </thead>
                        <tbody>
                        <?php 
                            $bal = 0; 
                            if($cust[0]['balance'] > 0){
                                $bal += $cust[0]['balance'];
                        ?>
                        <tr class="gradeX">
                            <!--<td><?= $i; ?></td>-->
                            <td><?= date('d-m-Y',strtotime($cust[0]['regdate'])); ?></td>
                            <td></td>
                            <td><?= number_format((0), 2); ?></td>
                            <td><?= number_format((0), 2);?></td> 
                            <td><?= number_format($cust[0]['balance'], 2);?></td> 
                          </tr>   
                          <?php } ?>
                          <?php if ($sale != null) { ?>

                          <?php
                                $i = 0;
                                $tsa = 0;
                                $tpa = 0;
                                $tda = 0;
                                $tdu = 0;
                                $totalA = 0;
                                $idate = 0;
                                $bal = 0; // Initialize balance
                                $last_invoice_no = ''; 
                                $printed_invoice_no = null;// Track the last processed invoice number
                            
                                foreach ($sale as $value) {
                                    $i++;
                                    
                                    // Check if the current invoice number is different from the last processed invoice
                                    if ($value->invoice_no != $last_invoice_no) {
                                        // Add totalAmount for the new invoice
                                        $bal += $value->totalAmount;
                                        $totalA = $value->totalAmount;
                                        $idate = $value->pdate;
                                        $last_invoice_no = $value->invoice_no; // Update the last processed invoice
                                    }else{
                                        $totalA = '';
                                        $idate = $value->pdate;
                                    }
                                    
                                    
                            
                                    ?>
                                    <tr class="gradeX">
                                        <!--<td><?= $i; ?></td>-->
                                        <td><?= date('Y-m-d', strtotime(($idate)?$idate:$value->saleDate)); ?></td>
                                       <!--<td><?= $value->invoice_no . ' - [' . $value->rec_code . ']'; ?></td>-->
                                     <td>
                                        <?php 
                                          // Display invoice number if it exists and has not been printed yet
                                          if ($value->invoice_no && $value->invoice_no !== $printed_invoice_no) {
                                         // Check if rec_code exists
                                          if ($value->rec_code) {
                                            echo $value->invoice_no . ' - [' . $value->rec_code . ']'; 
                                         } else {
                                            echo $value->invoice_no; // Display only invoice_no if rec_code doesn't exist
                                         }
                                         $printed_invoice_no = $value->invoice_no; // Update the printed invoice number
                                         } elseif ($value->invoice_no) {
                                         // Check if rec_code exists when invoice_no is the same
                                         if ($value->rec_code) {
                                         echo $value->rec_code ; // Display only rec_code if invoice_no is the same as last printed
                                         }
                                        } else {
                                         echo '[' . $value->rec_code . ']'; // Display only rec_code if no invoice_no
                                        }
                                       ?>
                                       </td>
                                        <td>
                                            <?php 
                                                echo number_format(($value->paidamount), 2).'<br>'; 
                                                $bal -= $value->paidamount; // Subtract paid amount from balance
                                            ?>
                                        </td> 
                                        <td><?= ($totalA)? number_format(($totalA), 2):''; ?></td>
                                        <td><?= number_format($bal, 2); $tdu += $value->dueamount; ?></td> 
                                    </tr>   
                            <?php } ?> 

                          <?php } else{ ?>
                          <?php $i = 0; ?>
                          <?php $tsa = 0; $tpa = 0; $tda = 0; $tdu = 0; ?>
                          <?php } ?>

                          <?php if ($voucher != null) { ?>

                          <?php
                          $j = $i;
                          $tva = 0;
                          $tcva = 0;
                          $tdva = 0;
                          foreach ($voucher as $value) {
                          $j++;
                          ?>
                          <tr class="gradeX">
                            <td><?= $j; ?></td>
                            <td><?= date('d-m-Y',strtotime($value->voucherdate)); ?></td>
                            <td><?= $value->invoice; ?></td>
                            <td><?= $value->vauchertype; ?></td>
                            <td><?= number_format(($value->totalamount), 2); $tva += $value->totalamount; ?></td> 
                            <td><?= '00'; ?></td>
                            <td><?= '00'; ?></td> 
                            <td><?= number_format(($value->totalamount), 2); $tcva += $value->totalamount; ?></td> 
                            <td><?= '00'; ?></td> 
                          </tr>   
                          <?php } ?>
                          <?php } else{ ?>
                          <?php $j = $i or $j = 0; ?>
                          <?php $tva = 0; $tcva = 0; $tdva = 0; ?>
                          <?php } ?> 

                          <?php if ($return != null) { ?>

                          <?php
                          $k = $j;
                          $tra = 0;
                          $trda = 0;
                          $trpa = 0;
                          foreach ($return as $value) {
                          $k++;
                          ?>
                          <tr class="gradeX">
                            <td><?= $k; ?></td>
                            <td><?= date('d-m-Y',strtotime($value->returnDate)); ?></td>
                            <td><?= $value->rid; ?></td>
                            <td><?= 'Product Returns'; ?></td>
                            <td><?= number_format(($value->totalPrice), 2); $tra += $value->totalPrice; ?></td> 
                            <td><?= number_format(($value->scAmount), 2); $trda += $value->scAmount; ?></td>
                            <td><?= '00'; ?></td> 
                            <td><?= number_format(($value->paidAmount), 2); $trpa += $value->paidAmount; ?></td> 
                            <td><?= '00'; ?></td>
                          </tr>   
                          <?php } ?>
                          <?php } else{ ?>
                          <?php $tra = 0; $trda = 0; $trpa = 0; ?>
                          <?php } ?> 
                        </tbody>
                        <!--<tfoot>-->
                        <!--  <tr>-->
                        <!--    <th colspan="2" style="text-align: right;">Total</th>-->
                        <!--    <th><?= number_format(($tsa), 2); ?></th>-->
                        <!--    <th><?= number_format(($tda), 2); ?></th>-->
                        <!--    <th><?= number_format(($tsa)-($tda), 2); ?></th>-->
                          <!--  <th><?= number_format(($tpa+$tcva), 2); ?></th>-->
                          <!--  <th><?= number_format(($tdu)-($tcva), 2); ?></th>-->
                          <!--</tr>-->
                        <!--</tfoot>-->
                        <!--<tfoot>-->
                        <!--  <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Total Sales</th>-->
                        <!--    <th><?= number_format(($tsa), 2); ?></th>-->
                        <!--  </tr>-->
                        <!--  <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Total Paid</th>-->
                        <!--    <th><?= number_format($tpa, 2); ?></th>-->
                        <!--  </tr>-->
                        <!--  <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Total Discount</th>-->
                        <!--    <th><?= number_format($tda, 2); ?></th>-->
                        <!--  </tr>-->
                        <!-- <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Total Payment</th>-->
                        <!--    <th><?= number_format($tcva, 2); ?></th>-->
                        <!--  </tr>-->
                        <!--   <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Total Return</th>-->
                        <!--    <th><?= number_format($trpa, 2); ?></th>-->
                        <!--  </tr>-->
                        <!--  <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Opening Balance</th>-->
                        <!--    <th><?= number_format(($cust[0]['balance']), 2); ?></th>-->
                        <!--  </tr>-->
                        <!--  <tr>-->
                        <!--    <th colspan="8" style="text-align: right;">Net Amount</th>-->
                        <!--    <th><?= number_format((($tsa+$cust[0]['balance'])-($tpa+$tda+$tcva+$trpa)), 2); ?></th>-->
                        <!--  </tr>-->
                        <!--</tfoot>-->
                      </table>
                    </div>

                    <div class="col-sm-12 col-md-12 col-12">
                      <div class="row" style="margin-top: 30px; text-align: center;">
                        <div class="col-md-4 col-sm-4 col-4">
                          <p>------------------------------</p>
                          <p>Prepared By</p>
                        </div>
                        <div class="col-md-4 col-sm-4 col-4">
                          <p>------------------------------</p>
                          <p>Verified By</p>
                        </div>
                        <div class="col-md-4 col-sm-4 col-4">
                          <p>------------------------------</p>
                          <p>Authorized By</p>
                        </div>
                      </div>
                    </div>
                    <?php } ?>
                  </div><br>
                  <div class="form-group col-md-12 col-sm-12 col-12" style="text-align: center; margin-top: 20px">
                    <a href="javascript:void(0)" onclick="printDiv('print')" class="btn btn-primary"><i class="fa fa-print"></i> Print</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

<?php $this->load->view('footer/footer'); ?>

    <script type="text/javascript">
      $(document).ready(function(){
        $('#daily').click(function(){
          $('#dreports').removeAttr('class','d-none');
          $('#mreports').attr('class','d-none');
          $('#yreports').attr('class','d-none');
          $('#reports').attr('class','d-none');

          $('#sdate').attr('required','required');
          $('#edate').attr('required','required');
          $('#dcustomer').attr('required','required');
          
          $('#month').removeAttr('required','required');
          $('#year').removeAttr('required','required');
          $('#mcustomer').removeAttr('required','required');
          
          $('#ryear').removeAttr('required','required');
          $('#ycustomer').removeAttr('required','required');

          $('#customer').removeAttr('required','required');
          });

        $('#monthly').click(function(){
          $('#mreports').removeAttr('class','d-none');
          $('#dreports').attr('class','d-none');
          $('#yreports').attr('class','d-none');
          $('#reports').attr('class','d-none');

          $('#sdate').removeAttr('required','required');
          $('#edate').removeAttr('required','required');
          $('#dcustomer').removeAttr('required','required');
          
          $('#month').attr('required','required');
          $('#year').attr('required','required');
          $('#mcustomer').attr('required','required');
          
          $('#ryear').removeAttr('required','required');
          $('#ycustomer').removeAttr('required','required');

          $('#customer').removeAttr('required','required');
          });

        $('#yearly').click(function(){
          $('#yreports').removeAttr('class','d-none');
          $('#dreports').attr('class','d-none');
          $('#mreports').attr('class','d-none');
          $('#reports').attr('class','d-none');

          $('#sdate').removeAttr('required','required');
          $('#edate').removeAttr('required','required');
          $('#dcustomer').removeAttr('required','required');
          
          $('#month').removeAttr('required','required');
          $('#year').removeAttr('required','required');
          $('#mcustomer').removeAttr('required','required');
          
          $('#ryear').attr('required','required');
          $('#ycustomer').attr('required','required');

          $('#customer').removeAttr('required','required');
          });

        $('#ocust').click(function(){
          $('#yreports').attr('class','d-none');
          $('#dreports').attr('class','d-none');
          $('#mreports').attr('class','d-none');
          $('#reports').removeAttr('class','d-none');

          $('#sdate').removeAttr('required','required');
          $('#edate').removeAttr('required','required');
          $('#dcustomer').removeAttr('required','required');
          
          $('#month').removeAttr('required','required');
          $('#year').removeAttr('required','required');
          $('#mcustomer').removeAttr('required','required');
          
          $('#ryear').removeAttr('required','required');
          $('#ycustomer').removeAttr('required','required');

          $('#customer').attr('required','required');
          });
        });
    </script> 