<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Company / Warehouse</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Company / Warehouse</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <?php
    $exception = $this->session->userdata('exception');
    if(isset($exception))
    {
    echo $exception;
    $this->session->unset_userdata('exception');
    } ?>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Company / Warehouse List</h3>
                <?php if($_SESSION['newcprofile'] == 1){ ?>
                <button type="button" class="btn btn-primary newCompany" data-toggle="modal" data-target=".bs-example-modal-newCompany" style="float: right" ><i class="fa fa-plus"></i> New Company</button>
                <?php } ?>
              </div>
              <div class="box-body">
                <div id="table-content ">
                  <table id="datatable" class="table table-responsive table-bordered table-hover">
                    <thead>
                      <tr>
                        <th style="width: 5%;">#SN.</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Email</th>
                        <th>Address</th>
                        <th>Vat Reg.</th>
                        <th style="width: 8%;">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $i = 0;
                      foreach ($company as $key => $value){
                      $i++;
                      ?>
                      <tr class="gradeX">
                        <td><?php echo $i; ?></td>
                        <td><?php echo $value['com_name']; ?></td>
                        <td><?php echo $value['com_mobile']; ?></td>
                        <td><?php echo $value['com_email']; ?></td>
                        <td><?php echo $value['com_address']; ?></td>
                        <td><?php echo $value['com_vat']; ?></td>       
                        <td>
                          <?php if($_SESSION['editcprofile'] == 1){ ?>
                          <button type="button" class="btn btn-success btn-xs editComp" data-toggle="modal" data-target=".bs-example-modal-editComp" data-id="<?php echo $value['com_pid']; ?>" onclick="document.getElementById('editComp').style.display='block'" ><i class="fa fa-edit"></i></button>
                          <?php } if($_SESSION['deletecprofile'] == 1){ ?>
                          <a class="btn btn-danger btn-xs" href="<?php echo site_url('Company/delete_company').'/'.$value['com_pid']; ?>" onclick="return confirm('Are you sure you want to Delete this Company ?');" ><i class="fa fa-trash"></i></a>
                          <?php }  ?>
                        </td>
                      </tr>   
                      <?php } ?> 
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
    
      <div class="modal fade bs-example-modal-newCompany" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Warehouse Information</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <form action="<?php echo base_url('Company/save_company');?>" method="POST">
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Company / Warehouse Name *</label>
                <input type="text" class="form-control" name="com_name" placeholder="Company / Warehouse Name" required >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Contact Number *</label>
                <input type="text" class="form-control" name="com_mobile" placeholder="Contact Number" required >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Email</label>
                <input type="email" class="form-control" name="com_email" placeholder="example@gmail.com" >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Address *</label>
                <input type="text" class="form-control" name="com_address" placeholder="Address" required >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Vat Reg. Number</label>
                <input type="text" class="form-control" name="com_vat" placeholder="Vat Reg. Number" >
              </div>
              <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    
      <div class="modal fade bs-example-modal-editComp" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Warehouse Information</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <form action="<?php echo base_url('Company/update_company'); ?>" method="post">
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Company / Warehouse Name *</label>
                <input type="text" class="form-control" name="com_name" id="com_name" required >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Contact Number *</label>
                <input type="text" class="form-control" name="com_mobile" id="com_mobile" required >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Email</label>
                <input type="email" class="form-control" name="com_email" id="com_email" >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Address *</label>
                <input type="text" class="form-control" name="com_address" id="com_address" required >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-xs-12">
                <label>Vat Reg. Number</label>
                <input type="text" class="form-control" name="com_vat" id="com_vat" >
              </div>
              <input type="hidden" id="compid" name="compid" required >
              <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Update</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    
    
<?php $this->load->view('footer/footer'); ?>

    <script type="text/javascript">
      $(document).ready(function(){
        $(".editComp").click(function(){
          var compid = $(this).data('id');
            //alert(l_id);
          $('input[name="compid"]').val(compid);
          });

        $('.editComp').click(function(){
          var id = $(this).data('id');
          var url = '<?php echo base_url() ?>Company/get_company_data';
              //alert(url);
          $.ajax({
            method: 'POST',
            url     : url,
            dataType: 'json',
            data    : {'id' : id},
            success:function(data){ 
                //alert(data);
              var HTML = data["com_name"];
              var HTML2 = data["com_mobile"];
              var HTML3 = data["com_email"];
              var HTML4 = data["com_address"];
              var HTML5 = data["com_vat"];
                //alert(HTML);
              $("#com_name").val(HTML);
              $("#com_mobile").val(HTML2);
              $("#com_email").val(HTML3);
              $("#com_address").val(HTML4);
              $("#com_vat").val(HTML5);
              },
            error:function(){
              alert('error');
              }
            });
          });
        });
    </script>