<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Purchase extends CI_Controller {

public function __construct()
    {
    parent::__construct();
    $this->load->model("prime_model","pm");
    $this->checkPermission();
}

public function index()
    {
    $data['title'] = 'Purchase';

    $join = array(
        'suppliers' => 'suppliers.supplierID = purchase.supplier'
            );
    $other = array(
        'order_by'=>'purchaseID',
        'join' => 'left'
            );
    $field = array(
        'purchase' => 'purchase.*',
        'suppliers' => 'suppliers.supplierName'
            );    
  if($_SESSION['role'] > 2)
    {
    $where = array(
      'purchase.compid' => $_SESSION['compid']
            );
            
    $data['purchase'] = $this->pm->get_data('purchase',$where,$field,$join,$other);
    }
  else
    {
    $data['purchase'] = $this->pm->get_data('purchase',false,$field,$join,$other);
    }
    
    $this->load->view('purchase/purchase_list',$data);
}

public function new_purchase() 
    {
    $data['title'] = 'Purchase';

    $where = array(
        'compid' => $_SESSION['compid']
            );
    $uwhere = array(
        'status' => 'Active',
        'compid' => $_SESSION['compid']  
            );

    $data['product'] = $this->pm->get_data('products',$where);
    $data['supplier'] = $this->pm->get_data('suppliers',$where);
    $data['category'] = $this->pm->get_data('categories',$uwhere);
    $data['unit'] = $this->pm->get_data('sma_units',$uwhere);

    $this->load->view('purchase/newPurchase',$data);
}

public function get_purchase_supplier()
  {
  $where = array(
    'compid' => $_SESSION['compid']
        );
  $grup = $this->pm->get_data('suppliers',$where);
  $someJSON = json_encode($grup);
  echo $someJSON;
}

public function get_purchase_product()
  {
  $where = array(
    'compid'   => $_SESSION['compid'],
    'supplier' => $_POST['id']
        );
  $grup = $this->pm->get_data('products',$where);
  $someJSON = json_encode($grup);
  echo $someJSON;
}

public function get_Product($id)
    {
    $str = "";

    $where = array(
        'productID' => $id
            );

    $productlist = $this->pm->get_data('products',$where);
    foreach ($productlist as $value)
        {
        $id = $value['productID'];
        $str .= "<tr>
        <td>".$value['productName']."<input type='hidden' readonly='readonly' name='product_id[]' value='".$id."'></td>
        <td><input type='text' class='form-control' id='quantity_".$id."' onkeyup='getTotal(".$id.")' name='quantity[]' value='1'></td>
        <td><input type='text' class='form-control' onkeyup='getTotal(".$id.")' id='tp_".$id."' name='pprice[]' value='".$value['pprice']."'></td>
        <td><input type='text' class='form-control' id='totalPrice_".$id."' name='total_price[]' value='".$value['pprice']."' readonly ></td>
        <td><span class='item_remove btn btn-danger btn-sm' onClick='$(this).parent().parent().remove();'>x</span>
        </td></tr>";
        }
    echo json_encode($str);
}

public function saved_supplier()
    {
    $info = $this->input->post();
    
    $query = $this->db->select('supplierID')
                  ->from('suppliers')
                  ->where('compid',$_SESSION['compid'])
                  ->limit(1)
                  ->order_by('supplierID','DESC')
                  ->get()
                  ->row();
    if ($query)
        {
        $sn = $query->supplierID+1;
        }
    else
        {
        $sn = 1;
        }

    $cn = strtoupper(substr($_SESSION['compname'],0,3));
    $pc = sprintf("%'05d",$sn);

    $cusid = 'C-'.$cn.$pc;

    $data = array(
        'compid'       => $_SESSION['compid'],
        'sup_id'       => $cusid,
        'supplierName' => $info['supplierName'],
        'compname'     => $info['compname'],
        'mobile'       => $info['mobile'],
        'email'        => $info['email'],
        'address'      => $info['address'],
        'balance'      => $info['balance'],         
        'regby'        => $_SESSION['uid']
            );

    $result = $this->pm->insert_data('suppliers',$data);

    if($result)
        {
        echo "";
        }
    else{
         $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
           <h4><i class="icon fa fa-ban"></i> Failed !</h4></div>'
                ];
        $this->session->set_userdata($sdata);
        }
    redirect('newPurchase');
}

public function savedPurchase()
    {
    $info = $this->input->post();

    // $query = $this->db->select('challanNo')
    //               ->from('purchase')
    //               ->where('compid',$_SESSION['compid'])
    //               ->limit(1)
    //               ->order_by('challanNo','DESC')
    //               ->get()
    //               ->row();
    // if($query)
    //     {
    //     $sn = substr($query->challanNo,6)+1;
    //     }
    // else
    //     {
    //     $sn = 1;
    //     }
    // $cn = strtoupper(substr($_SESSION['compname'],0,3));
    // $pc = sprintf("%'05d",$sn);

    // $cusid = 'PO-'.$cn.$pc;
    //var_dump($cusid); exit();
    $purchase = array(
        'compid'       => $_SESSION['compid'],
        'challanNo'    => $info['challanNo'],
        'purchaseDate' => date('Y-m-d', strtotime($info['date'])),
        'supplier'     => $info['suppliers'],
        'totalPrice'   => $info['totalPrice'],
        'paidAmount'   => $info['Paid'],
        'due'          => $info['totalPrice']-$info['Paid'],
        'accountType'  => $info['accountType'],
        'accountNo'    => $info['accountNo'],
        // 'sCompany'     => $info['sCompany'],
        // 'sName'        => $info['sName'],
        // 'sMobile'      => $info['sMobile'],
        // 'sAddress'     => $info['sAddress'],
        'note'         => $info['note'],
        'regby'        => $_SESSION['uid']
            );
       // var_dump($purchase); exit();
    $result = $this->pm->insert_data('purchase',$purchase);

    $length = count($info['product_id']);
        
    for ($i = 0; $i < $length; $i++)
        {
        $purchase_product = array(
            'purchaseID' => $result,
            'productID'  => $info['product_id'][$i],
            'quantity'   => $info['quantity'][$i],
            'pprice'     => $info['pprice'][$i],                    
            'totalPrice' => $info['total_price'][$i],
            'regby'      => $_SESSION['uid']
                );
        //var_dump($purchase_product);            
        $result2 = $this->pm->insert_data('purchase_product',$purchase_product); 

        $pid = $info['product_id'][$i];
        $aid = $_SESSION['compid'];

        $swhere = array(
            'compid'  => $_SESSION['compid'],
            'product' => $pid
                    );

        $stpd = $this->pm->get_data('stock',$swhere);

        $this->pm->delete_data('stock',$swhere);

        if($stpd)
            {
            $tquantity = $info['quantity'][$i]+$stpd[0]['totalPices'];
            $dtqnt = $stpd[0]['dtquantity'];
            }
        else{
            $tquantity = $info['quantity'][$i];
            $dtqnt = 0;
            }

        $stock_info = array(
            'compid'     => $_SESSION['compid'],
            'product'    => $info['product_id'][$i],
            'totalPices' => $tquantity,
            'dtquantity' => $dtqnt,
            'regby'      => $_SESSION['uid']
                    );
        //var_dump($stock_info);    
        $this->pm->insert_data('stock',$stock_info);                 
        }
    if($result && $result2)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Purchase add Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Purchase');
}

public function view_purchase($id)
    {
    $data['title'] = 'Purchase';

    $pwhere = array(
        'purchaseID' => $id
            );
    $pfield = array(
        'purchase_product' => 'purchase_product.*',
        'products' => 'products.productName,products.productcode,products.warranty',
        'sma_units' => 'sma_units.unitName'
            );
    $pjoin = array(
        'products' => 'products.productID = purchase_product.productID',
        'sma_units' => 'sma_units.id = products.unit'
            );
    $pother = array(
        'join' => 'left'
            );

    $data['pproduct'] = $this->pm->get_data('purchase_product',$pwhere,$pfield,$pjoin,$pother);

    $join = array(
        'suppliers' => 'purchase.supplier = suppliers.supplierID'
            );
    $field = array(
        'purchase' => 'purchase.*',
        'supplier' => 'suppliers.*'
            );

    $purchase = $this->pm->get_data('purchase',$pwhere,$field,$join,$pother);
    $data['purchase'] = $purchase[0];

    $sid = $purchase[0]['supplier'];
    //var_dump($cusid); exit();
    $data['csdue'] = $this->pm->supplier_purchases_due_details($id,$sid);
    $data['cvpa'] = $this->pm->supplier_paid_details($sid);
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('purchase/viewPurchase',$data);
}

public function edit_purchase($id)
    {
    $data['title'] = 'Purchase';

    $pwhere = array(
        'purchaseID' => $id
            );
    $pfield = array(
        'purchase_product' => 'purchase_product.*',
        'products' => 'products.productName,products.productcode'
            );
    $pjoin = array(
        'products' => 'products.productID = purchase_product.productID'
            );
    $pother = array(
        'join' => 'left'
            );

    $data['pproduct'] = $this->pm->get_data('purchase_product',$pwhere,$pfield,$pjoin,$pother);

    $purchase = $this->pm->get_data('purchase',$pwhere);
    $data['purchase'] = $purchase[0];

    $where = array(
       'compid' => $_SESSION['compid']  
            );

    $data['product'] = $this->pm->get_data('products',$where);
    $data['supplier'] = $this->pm->get_data('suppliers',$where);
    
    $this->load->view('purchase/editPurchase',$data);
}

public function update_purchase()
  {
  $info = $this->input->post();

  $purchase = array(
    'compid'      => $_SESSION['compid'],
    'challanNo'   => $info['challanNo'],
    'purchaseDate'=> date('Y-m-d',strtotime($info['date'])),
    'supplier'    => $info['suppliers'],
    'totalPrice'  => $info['totalPrice'],
    'paidAmount'  => $info['Paid'],
    'due'         => $info['totalPrice']-$info['Paid'],
    'accountType' => $info['accountType'],
    'accountNo'   => $info['accountNo'],
    // 'sCompany'    => $info['sCompany'],
    // 'sName'       => $info['sName'],
    // 'sMobile'     => $info['sMobile'],
    // 'sAddress'    => $info['sAddress'],
    'note'        => $info['note'],
    'upby'        => $_SESSION['uid']
        );

  $where = array(
    'purchaseID' => $info['purhcase_id']
        );

  $result = $this->pm->update_data('purchase',$purchase,$where);
  $pproduct = $this->pm->get_data('purchase_product',$where);
  $this->pm->delete_data('purchase_product',$where);
  $lnth = count($pproduct);

  for($i = 0; $i < $lnth; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pproduct)
        {
        $tquantity = ($spd[0]['totalPices']-$pproduct[$i]['quantity']);
        $dtqnt = $spd[0]['dtquantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stockinfo = array(
      'compid'     => $_SESSION['compid'],
      'product'    => $pproduct[$i]['productID'],
      'totalPices' => $tquantity,
      'dtquantity' => $dtqnt,
      'regby'      => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stockinfo); 
    }

  $length = count($info['product_id']);
    //var_dump($length); exit();
  for($i = 0; $i < $length; $i++)
    {
    $purproduct = array(
      'purchaseID' => $info['purhcase_id'],
      'productID'  => $info['product_id'][$i],
      'quantity'   => $info['quantity'][$i],
      'pprice'     => $info['pprice'][$i],                    
      'totalPrice' => $info['total_price'][$i],
      'regby'      => $_SESSION['uid']
          );
        //var_dump($purchase_product);            
    $this->pm->insert_data('purchase_product',$purproduct); 
    
    $pid = $this->input->post('product_id')[$i];
    $aid = $_SESSION['compid'];

    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pid
              );

    $stpd = $this->pm->get_data('stock',$swhere);
    $this->pm->delete_data('stock',$swhere);

    if($stpd)
      {
      $tquantity = $info['quantity'][$i]+$stpd[0]['totalPices'];
      $dtqnt = $stpd[0]['dtquantity'];
      }
    else
      {
      $tquantity = $info['quantity'][$i];
      $dtqnt = 0;
      }

    $stock_info = array(
      'compid'     => $_SESSION['compid'],
      'product'    => $this->input->post('product_id')[$i],
      'totalPices' => $tquantity,
      'dtquantity' => $dtqnt,
      'regby'      => $_SESSION['uid']
              );
        //var_dump($stock_info); exit();    
    $this->pm->insert_data('stock',$stock_info);                 
    }

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
      <h4><i class="icon fa fa-check"></i> Purchase update Successfully !</h4></div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
      <h4><i class="icon fa fa-ban"></i> Failed !</h4></div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Purchase');
}

public function delete_purchases($id)
    {
    $where = array(
        'purchaseID' => $id
            );

    $result = $this->pm->delete_data('purchase',$where);
    $pproduct = $this->pm->get_data('purchase_product',$where);
    $result2 = $this->pm->delete_data('purchase_product',$where);
    
  $length = count($pproduct);

  for($i = 0; $i < $length; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pproduct)
        {
        $tquantity = ($spd[0]['totalPices']-$pproduct[$i]['quantity']);
        $dtqnt = $spd[0]['dtquantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stock_info = array(
      'compid'     => $_SESSION['compid'],
      'product'    => $pproduct[$i]['productID'],
      'totalPices' => $tquantity,
      'dtquantity' => $dtqnt,
      'regby'      => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stock_info); 
    }

    if($result && $result2)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Purchase delete Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Purchase');
}

public function purchases_reports()
    {
    $data = ['title' => 'Purchase Reports'];
    $where = array('compid' => $_SESSION['compid']);

    $data['supplier'] = $this->pm->get_data('suppliers',$where);
    $data['company'] = $this->pm->get_data('com_profile',false);

    if(isset($_GET['search']))
        {
        $report = $_GET['reports'];
        
        if($report == 'dailyReports')
            {
            $sdate = date("Y-m-d", strtotime($_GET['sdate']));
            $edate = date("Y-m-d", strtotime($_GET['edate']));
            $supid = $_GET['dsupplier'];
            $compid = $_GET['dcompany'];
            $data['sdate'] = $sdate;
            $data['edate'] = $edate;
            $data['report'] = $report;
            //var_dump($employee); exit();
            $data['purchase'] = $this->pm->get_dpurchses_data($sdate,$edate,$supid,$compid);
            }
        else if ($report == 'monthlyReports')
            {
            $month = $_GET['month'];
            $data['month'] = $month;
            $year = $_GET['year'];
            $data['year'] = $year;
            //var_dump($data['month']); exit();
            if($month == 01)
                {
                $name = 'January';
                }
            elseif ($month == 02)
                {
                $name = 'February';
                }
            elseif ($month == 03)
                {
                $name = 'March';
                }
            elseif ($month == 04)
                {
                $name = 'April';
                }
            elseif ($month == 05)
                {
                $name = 'May';
                }
            elseif ($month == 06)
                {
                $name = 'June';
                }
            elseif ($month == 07)
                {
                $name = 'July';
                }
            elseif ($month == 8)
                {
                $name = 'August';
                }
            elseif ($month == 9)
                {
                $name = 'September';
                }
            elseif ($month == 10)
                {
                $name = 'October';
                }
            elseif ($month == 11)
                {
                $name = 'November';
                }
            else
                {
                $name = 'December';
                }
            $supid = $_GET['msupplier'];
            $compid = $_GET['mcompany'];
            $data['name'] = $name;
            $data['report'] = $report;

            $data['purchase'] = $this->pm->get_mpurchses_data($month,$year,$supid,$compid);
            }
        else if ($report == 'yearlyReports')
            {
            $year = $_GET['ryear'];
            $supid = $_GET['ysupplier'];
            $data['year'] = $year;
            $data['report'] = $report;
            $compid = $_GET['ycompany'];

            $data['purchase'] = $this->pm->get_ypurchses_data($year,$supid,$compid);
            }
        }
    else
        {
        $data['purchase'] = $this->pm->get_purchses_data();
        }

    $this->load->view('purchase/purchase_reports',$data);
}

public function get_purchase_payment()
    {
    $section = $this->pm->get_purchase_payment($_POST['id']);
    $someJSON = json_encode($section);
    echo $someJSON;
}

public function save_purchase_payment()
    {
    $info = $this->input->post();

    $sale = [
        'pur_id' => $info['purchaseID'],
        'amount' => $info['amount'],            
        'regby'  => $_SESSION['uid']
            ];
    //var_dump($sale); exit();
    $result = $this->pm->insert_data('purchase_payment',$sale);

    $where = array(
        'purchaseID' => $info['purchaseID']
                );

    $data = [
        'paidAmount' => $info['amount']+$info['pamount'],
        'due'        => $info['damount']-$info['amount'],
        'upby'       => $_SESSION['uid']
            ];
       
    $result2 = $this->pm->update_data('purchase',$data,$where);
    if($result && $result2)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i> Purchase Payment add Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Purchase');
}

public function daily_purchases_reports()
    {
    $data = ['title' => 'Purchase Reports'];
    $where = array('compid' => $_SESSION['compid']);

    $data['supplier'] = $this->pm->get_data('suppliers',$where);

    $sdate = date('Y-m-d');
    $edate = date('Y-m-d');
    $supplier = 'All';
    $data['sdate'] = $sdate;
    $data['edate'] = $edate;
    $data['report'] = 'dailyReports';
        //var_dump($employee); exit();
    $data['purchase'] = $this->pm->get_dpurchses_data($sdate,$edate,$supplier);

    $this->load->view('purchase/purchase_reports',$data);
}
public function purchase_due_reports()
    {
    $data['title'] = 'Purchase Due Report';

    $data['suppliers'] = $this->pm->get_data('suppliers',false);
    
    $data['company'] = $this->pm->company_details();

    $this->load->view('purchase/purchase_due_reports',$data);
}




}