<?php
if(!defined('BASEPATH'))
  exit('No direct script access allowed');

class Category extends CI_Controller {

public function __construct()
  {
  parent::__construct();
  $this->load->model("prime_model","pm");
  //$this->checkPermission();
}

public function index()
  {
  $data['title'] = 'Category';

  $where = array(
    'compid' => $_SESSION['compid']
          );

  $data['category'] = $this->pm->get_data('categories',$where);
  
  $this->load->view('category/category',$data);
}

public function save_category()
  {
  $info = $this->input->post();

  $data = array(
    'compid'       => $_SESSION['compid'],
    'categoryName' => $info['catName'],          
    'regby'        => $_SESSION['uid']
        );

  $result = $this->pm->insert_data('categories',$data);

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Category add Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Category');
}

public function get_category_data()
  {
  $section = $this->pm->get_category_data($_POST['id']);
  $someJSON = json_encode($section);
  echo $someJSON;
}

public function update_category()
  {
  $info = $this->input->post();

  $data = array(
    'compid'       => $_SESSION['compid'],
    'categoryName' => $info['categoryName'],
    'status'       => $info['status'],            
    'upby'         => $_SESSION['uid']
        );

  $where = array(
    'categoryID' => $info['cat_id']
        );

  $result = $this->pm->update_data('categories',$data,$where);

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Category update Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Category');
}

public function delete_category($id)
  {
  $where = array(
    'categoryID' => $id
        );

  $empu = $this->pm->get_data('products',$where);

  if($empu[0] == null)
    {
    $result = $this->pm->delete_data('categories',$where);

    if($result)
      {
      $sdata = [
        'exception' =>'<div class="alert alert-success alert-dismissible">
          <h4><i class="icon fa fa-check"></i> Category delete Successfully !</h4>
          </div>'
              ];  
      }
    else
      {
      $sdata = [
        'exception' =>'<div class="alert alert-danger alert-dismissible">
          <h4><i class="icon fa fa-ban"></i> Failed !</h4>
          </div>'
              ];
      }
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> All ready add this Category in Product !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Category');
}

public function product_units()
  {
  $data['title'] = 'Unit';

  $where = array(
    'compid' => $_SESSION['compid']
        );

  $data['unit'] = $this->pm->get_data('sma_units',$where);

  $this->load->view('category/product_units',$data);
}

public function save_units()
  {
  $info = $this->input->post();

  $data = array(
    'compid'   => $_SESSION['compid'],
    'unitName' => $info['unitName'],         
    'regby'    => $_SESSION['uid']
        );

  $result = $this->pm->insert_data('sma_units',$data);

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i>Units add Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Unit');
}

public function get_unit_data()
  {
  $section = $this->pm->get_unit_data($_POST['id']);
  $someJSON = json_encode($section);
  echo $someJSON;
}

public function update_units()
  {
  $info = $this->input->post();

  $data = array(
    'compid'   => $_SESSION['compid'],
    'unitName' => $info['unitName'],
    'status'   => $info['status'],            
    'upby'     => $_SESSION['uid']
        );

  $where = array(
    'id' => $info['unit_id']
        );

  $result = $this->pm->update_data('sma_units',$data,$where);

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i>Unit update Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Unit');
}

public function delete_units($id)
  {
  $where = array(
    'unit' => $id
        );
  $empu = $this->pm->get_data('products',$where);

  if($empu[0] == null)
    {
    $uwhere = array(
      'id' => $id
          );

    $result = $this->pm->delete_data('sma_units',$uwhere);

    if($result)
      {
      $sdata = [
        'exception' =>'<div class="alert alert-success alert-dismissible">
          <h4><i class="icon fa fa-check"></i> Unit delete Successfully !</h4>
          </div>'
              ];  
      }
    else
      {
      $sdata = [
        'exception' =>'<div class="alert alert-danger alert-dismissible">
          <h4><i class="icon fa fa-ban"></i> Failed !</h4>
          </div>'
              ];
      }
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> All ready add this Unit in Product !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Unit');
}






}