<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Sales</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Sales</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Sale Information</h3>
              </div>

              <div class="card-body">
                <form method="POST" action="<?php echo base_url() ?>Sale/saved_sale" enctype='multipart/form-data' >
                  <div class="row">
                    <div class="form-group col-md-4 col-sm-4 col-12">
                      <label>Sale Date *</label>
                      <input type="text" name="date" class="form-control datepicker" value="<?php echo date('m/d/Y') ?>" required >
                    </div>
                    
                    <div class="form-group col-md-4 col-sm-4 col-12">
                      <label>Select Customer *</label>
                        <div class="input-group input-group-sm">
                        <select name="customerID" id="customerID" class="form-control select2" required>
                       <option value="">Select One</option>
                        </select>
                       <span class="input-group-append">
                        <button type="button" class="btn btn-danger btn-sm customer_add" data-toggle="modal" data-target=".bs-example-modal-customer_add">
                       <i class="fa fa-plus"></i>
                        </button>
                         </span>
                     </div>
                    </div>



                    
                    <div class="form-group col-md-4 col-sm-4 col-12">
                      <label>Select Product *</label>
                      <!--<input type="text" id="productID" class="form-control" placeholder="Select Product" list="pdlist"  >-->
                      <select name="productID" id="productID" class="form-control select2" required >
                        <option value="">Select One</option>
                        <?php foreach($product as $value){ ?>
                        <option value="<?php echo $value['productID']; ?>"><?php echo $value['productName'].' ( '.$value['productcode'].' )'; ?></option>
                        <?php } ?>
                      </select>
                    </div>
                  </div>

                    <div class="col-md-12 col-sm-12 col-12" >
                      <table id="mtable" class="table table-bordered table-striped">
                        <thead class="btn-default">
                          <tr>
                            <th>Code</th>
                            <th>Product</th>
                            <th>Stock</th>
                            <th>Quantity</th>
                            <th>Unit Price</th>
                            <th>Sub Total</th> 
                            <th>Action</th>                       
                          </tr>
                        </thead>
                        <tbody id="tbody">

                        </tbody>
                        <tbody>
                          <!--<tr>-->
                          <!--  <td colspan="5" align="right">Discount ( % )</td>-->
                          <!--  <td>-->
                          <!--    <input type="hidden" class="form-control" id="totaldprice" >-->
                          <!--    <input type="number" class="form-control" name="discount" id="discount" placeholder="Discount" onkeyup="discountType()" value="0" >-->
                          <!--    <input type="hidden" class="form-control" id="discounttype" name="discounttype" >-->
                          <!--    <input type="hidden" class="form-control" id="discountamount" name="discountamount" >-->
                          <!--  </td>-->
                          <!--  <td></td>-->
                          <!--</tr>-->
                          <!--<tr>-->
                          <!--  <td colspan="5" align="right">VAT ( % )</td>-->
                          <!--  <td>-->
                          <!--    <input type="hidden" class="form-control" id="tvata" >-->
                          <!--    <input type="number" class="form-control" name="salevat" id="salevat" placeholder="VAT" onkeyup="salevatAmount()" value="0" >-->
                          <!--  </td>-->
                          <!--  <td></td>-->
                          <!--</tr>-->
                          <tr>
                            <td colspan="5" align="right" >VAT (%)</td>
                            <td>
                              <input type="hidden" class="form-control" id="tsAmount"  value="0" required >
                              <input type="text" class="form-control" name="vCost" id="vCost" onkeyup="vatcostcalculator()" value="0" >
                              <input type="hidden" class="form-control" name="vType" id="vType" value="0" >
                              <input type="hidden" class="form-control" name="vAmount" id="vAmount" value="0" >
                            </td>
                            <td></td>
                          </tr>
                          <tr>
                            <td colspan="5" align="right" >Net Amount</td>
                            <td>
                              <input type="text" class="form-control" name="nAmount" id="nAmount" required readonly >
                            </td>
                            <td></td>
                          </tr>
                          <tr>
                            <td colspan="5" align="right" >Discount</td>
                            <td>
                              <input type="text" class="form-control" name="discount" id="discount" onkeyup="discountType()" value="0" >
                              <input type="hidden" class="form-control" id="disType" name="disType" value="0" >
                              <input type="hidden" class="form-control" id="disAmount" name="disAmount" value="0" >
                            </td>
                            <td></td>
                        </tr>
                          <tr>
                            <td colspan="5" align="right">Total Amount *</td>
                            <td><input type="text" name="totalprice" class="form-control" id="totalprice" required readonly ></td>
                            <td></td>
                          </tr>
                          <tr>
                            <td colspan="5" align="right">Paid Amount *</td>
                            <td><input type="text" id="total_paid" class="form-control" name="total_paid" onkeyup="calculate_remain()" onkeypress="return isNumberKey(event)" value="0" required ></td>
                            <td></td>
                          </tr>
                          <tr>
                            <td colspan="5" align="right">Due Amount</td>
                            <td><input type="text" name="due" class="form-control" id="total_remain" readonly ></td>
                            <td></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                    <div class="row">
                      
                        <div class="form-group col-md-4 col-sm-4 col-12">
                          <label>Account Type *</label>
                          <select class="form-control" name="accountType" id="accountType" required >
                            <option value="Cash">Cash</option>
                            <option value="Bank">Bank</option>
                            <option value="Mobile">Mobile</option>
                          </select>
                        </div>
                        <div class="form-group col-md-4 col-sm-4 col-12">
                            <label>Account Number *</label>
                            <select name="accountNo" id="accountNo" class="form-control" required >
                              <option value="">Select Account Type First</option>
                            </select>
                          </div>
                        <div class="form-group col-md-4 col-sm-4 col-12">
                          <label>Note</label>
                          <textarea type="text" class="form-control" name="note" placeholder="If have any note" rows="1" ></textarea>
                        </div>
                        <div class="form-group col-md-12 col-sm-12 col-12">
                          <label>Terms & Conditions</label>
                          <textarea type="text" class="form-control" name="terms" id="editor" placeholder="Terms & Conditions"></textarea>
                        </div>
                        
                    </div>
                    
                  <div class="form-group col-md-12 col-sm-12 col-xs-12" style="margin-top:20px; text-align: center;">
                    <button type="submit" class="btn btn-info" onclick="this.form.submit(); this.disabled = true;" ><i class="far fa-save"></i>&nbsp;&nbsp;Submit</button>
                    <a href="<?php echo site_url('Sale') ?>" class="btn btn-danger" ><i class="fa fa-arrow-left" ></i>&nbsp;&nbsp;Back</a>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

    <div id="customer_add" class="modal fade bs-example-modal-customer_add" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-sm">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Customer Information</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          </div>
          <form method="POST" action="<?php echo base_url() ?>Sale/saved_customer" >
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="form-group col-md-12 col-sm-12 col-xs-12">
              <input type="text" class="form-control" name="mobile" id="mobile" placeholder="Mobile Number *" onkeypress="return isNumberKey(event)" maxlength="11" minlength="11" required >
            </div>
            <div class="form-group col-md-12 col-sm-12 col-xs-12">
              <input type="text" class="form-control" name="customerName" id="customerName" placeholder="Customer Name " >
            </div>
            <div class="form-group col-md-12 col-sm-12 col-xs-12">
              <input type="text" class="form-control" name="address" id="address" placeholder="Address *" required >
            </div>
            <div class="form-group col-md-12 col-sm-12 col-xs-12">
              <input type="email" class="form-control" name="email" id="email" placeholder="example@sunshine.com">
            </div>
            <input type="hidden" class="form-control" name="balance" id="balance" value="0" >
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary" id="pbsubmit" ><i class="far fa-save"></i>&nbsp;&nbsp;Submit</button>
            <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="far fa-window-close"></i>&nbsp;&nbsp;Cancel</button>
          </div>
          </form>
        </div>
      </div>
    </div>


<?php $this->load->view('footer/footer'); ?>

<script type="text/javascript">
  $(function(){
    load_customers();
    function load_customers(){
      var url = "<?php echo base_url()?>Sale/get_sale_customer";
      $.ajax({
        type: 'POST',
        url: url,       
        dataType: 'json',
        success: function(data){
          var HTML = '<option value="">Select One</option>';
          if (data) {
            $.each(data, function(index, item){
              HTML += '<option value="' + item.customerID + '">' + item.customerName + ' ( ' + item.mobile + ' )</option>';
            });
          }
          $("#customerID").html(HTML);
          $("#customerID").select2(); // Re-apply Select2
        }
      });
    }
  
  

        // $("#pbsubmit").click(function(){
        //   var customerName = $("#customerName").val();
        //   var mobile = $("#mobile").val();
        //   var email = $("#email").val();
        //   var address = $("#address").val();
        //   var balance = $("#balance").val();
        //   var dataString = 'customerName='+ customerName + '&mobile='+ mobile + '&email='+ email + '&address='+ address + '&balance='+ balance;
        //   // AJAX Code To Submit Form.
        //   $.ajax({
        //     type: "POST",
        //     url: "<?php echo site_url('Customer/add_customer') ?>",
        //     data: dataString,
        //     cache: false,
        //     success: function(result){
        //       //alert(result);
        //       load_customers();
        //       $(".card-body").css({ overflow:"auto" });
        //       $('#customer_add').remove();
        //       $('.modal-backdrop').remove();
        //       }
        //     });
        //   return false;
        // });
      });
      
    </script>
    
    <script type="text/javascript">

      $('#productID').change(function(){
        var id = $('#productID').val();
        var url = '<?php echo base_url() ?>' + 'Sale/get_product_details/'+id;
          //alert(id); exit();
        $.ajax({
          type: 'GET',
          url: url,
          dataType: 'text',
          success: function(data){
            //   alert(data);
             if(data==1){
                 alert('No available Stock');
             }
             else{
                var jsondata = JSON.parse(data);
                $('#mtable').append(jsondata);
                calculateTotalPrice();
             }
            }
          });
        });
    </script>
    
    <script type="text/javascript" >
      function deleteProduct(o) {
        var p=o.parentNode.parentNode;
         p.parentNode.removeChild(p);
         
         calculateTotalPrice();
        }
    </script>
    
    <script type="text/javascript">

        function totalPrice(id){
            var pices = $('#pices_'+id).val();
            var salePrice = $('#salePrice_'+id).val();
            // var stock = $('#stock').html();
                //alert(pices); alert(salePrice);
            var totalPrice = (parseFloat(salePrice).toFixed(2)*pices);
            $('#totalPrice_'+id).val(parseFloat(totalPrice).toFixed(2));
            
            calculateTotalPrice();
            }

        function calculateTotalPrice() {
            var sum=0;
            $(".totalPrice").each(function(){
                sum += parseFloat($(this).val());
                });
                //alert(sum);
            $('#totalprice').val(parseFloat(sum).toFixed(2));
            $('#tsAmount').val(parseFloat(sum).toFixed(2));
            $('#nAmount').val(parseFloat(sum).toFixed(2));
            // $('#total_remain').val(parseFloat(sum).toFixed(2));
            // $('#totalsprice').val(parseFloat(sum).toFixed(2));
            // $('#totaldprice').val(parseFloat(sum).toFixed(2));
            calculate_remain();
            vatcostcalculator();
            discountType();
            }
            
        // function calculate_tamount(){
        //     var paid = $('#shiping_cost').val();
        //     var total = $('#totalsprice').val();
        //     //alert(paid); alert(total); 
        //     var remaining = +total + +paid;
            
        //     $('#totalprice').val(parseFloat(remaining).toFixed(2));
        //     $('#total_remain').val(parseFloat(remaining).toFixed(2));
        //     $('#totaldprice').val(parseFloat(remaining).toFixed(2));
        //     }

        function calculate_remain(){
            var paid = $('#total_paid').val();
            var total = $('#totalprice').val();
            var remaining = parseFloat(total).toFixed(2)-parseFloat(paid).toFixed(2);
            $('#total_remain').val(remaining);
            }
            
        // function calculate_emi(){
        //     var paid = $('#nEmi').val();
        //     var total = $('#total_remain').val();
            
        //     var remaining = parseFloat(total).toFixed(2) / parseFloat(paid).toFixed(2);
        //     $('#pEmi').val(Math.round(remaining));
        //     }
        
    </script>
    
     <script type="text/javascript">
      function shippingCost(){
        var sCost = 0;
        var total = $('#tsAmount').val();
        // var tdis = $('#disAmount').val();
        var tvat = $('#vAmount').val();
    //   console.log(sCost, total, tdis);
        var da = +sCost + +total;
        var dat = +da + +tvat;
            //alert(da);alert(dat);
        var total = dat;
            //alert(remaining);
        
        $('#nAmount').val(parseFloat(total).toFixed(2));
        $('#totalprice').val(parseFloat(total).toFixed(2));
        // $('#Paid').val(parseFloat(total).toFixed(2));
        calculate_remain();
        discountType();
        }
    </script>
    
    <script type="text/javascript">
      function vatcostcalculator(){
        var vat = $('#vCost').val();
        var total = $('#tsAmount').val();
        var discc = vat.slice(-1);
        var disca = vat.substring(0, vat.length - 1);
        //alert(discc);
        $('#vType').val(discc);
        
        if(discc == '%')
          {
          var da = parseFloat(total).toFixed(2)*parseFloat(disca).toFixed(2);
          var dat = parseFloat(da).toFixed(2)/100;
            //alert(da);alert(dat);
          //var remaining = parseFloat(total).toFixed(2)-parseFloat(dat).toFixed(2);
            
          $('#vAmount').val(dat);
          }
        else
          {
          var remaining = parseFloat(total).toFixed(2)-parseFloat(vat).toFixed(2);
          $('#vAmount').val(vat);
          }
            //alert(remaining);
        shippingCost();
        }
    </script>
    
    <script type="text/javascript">
      function discountType(){
        var disc = $('#discount').val();
        var total = $('#nAmount').val();
        // var discc = disc.slice(-1);
        var discc = '%';
        var disca = disc.substring(0, disc.length - 1);
            // alert(disc);
        $('#disType').val(discc);
        
        if(discc == '%')
          {
          var da = parseFloat(total).toFixed(2)*parseFloat(disc).toFixed(2);
          var dat = parseFloat(da).toFixed(2)/100;
            //alert(da);alert(dat);
          var remaining = parseFloat(total).toFixed(2)-parseFloat(dat).toFixed(2);
            
          $('#disAmount').val(dat);
          }
        else
          {
          var remaining = parseFloat(total).toFixed(2)-parseFloat(disc).toFixed(2);
          $('#disAmount').val(disc);
          }
          //alert(remaining);
        
        $('#totalprice').val(parseFloat(remaining).toFixed(2));
        // $('#Paid').val(parseFloat(remaining).toFixed(2));
        calculate_remain();
        }
    </script>

     <script type="text/javascript">
    //   function discountType(){
    //     var disc = $('#discount').val();
    //     var total = $('#totalsprice').val();
    //     var tsa = $('#totaldprice').val();
    //     var discc = disc.slice(-1);
    //     var disca = disc.substring(0, disc.length - 1);
    //     //alert(total); alert(tsa);
    //     $('#discounttype').val(discc);
    //     $('#discountamount').val(disca);
        
    //     if(discc == '%')
    //       {
    //       var dis = total*disca;
    //       var dsa = dis/100;
          
    //       var total = tsa-dsa;
    //       }
    //     else
    //       {
    //       var total = tsa-disc;
    //       }
          
    //     $('#totalprice').val(parseFloat(total).toFixed(2));
    //     $('#tvata').val(parseFloat(total).toFixed(2));
    //     $('#total_remain').val(parseFloat(total).toFixed(2));
    //     calculate_remain();
    //     }
    // </script>
    
     <script type="text/javascript">
    //   function salevatAmount(){
    //     var disc = $('#salevat').val();
    //     var total = $('#totaldprice').val();
    //     var tp = $('#tvata').val();
    //     //alert(disc); alert(total); alert(tp);
        
    //     var dis = total*disc;
    //     var dsa = dis/100;
          
    //     var tva = +tp + +dsa;
          
    //     $('#totalprice').val(parseFloat(tva).toFixed(2));
    //     $('#total_remain').val(parseFloat(tva).toFixed(2));
        
    //       calculate_remain();
    //     }
    
    //     function emi_charge(){
    //         var paid = $('#emiSchrge').val();
    //         var total = $('#total_remain').val();
            
    //         var tpp = ((total*paid)/100);
    //         var tpa = +total + +tpp;
            
    //         $('#total_remain').val(Math.round(tpa));
    //         }
    // </script>

    <script type="text/javascript">
    
        $(document).ready(function(){
            var value = $("#accountType").val();
            $('#accountNo').empty();
            getAccountNo(value, '#accountNo');
            $('#accountNo').val(1);
            });

      $('#accountType').on('change',function(){
        var value = $(this).val();
        $('#accountNo').empty();
        getAccountNo(value, '#accountNo');
        });
        
        function getAccountNo(value,place){
          $(place).empty();
          if(value != ''){
            $.ajax({
              url: '<?php echo site_url()?>Voucher/getAccountNo',
              async: false,
              dataType: "json",
              data: 'id=' + value,
              type: "POST",
              success: function (data){
                $(place).append(data);
                $(place).trigger("chosen:updated");
                }
              });
            }
          else
            {
            customAlert('Please Select Account Type', "error", true);
            }
          }
    </script>

    <script type="text/javascript">
      $(function(){
        $(".select2").select2();
      });
    </script>
    
    <script type="text/javascript">
      $(document).ready(function() {
        $('#sType').click(function(){
          var id = $('#sType').val();
          
          if(id == 2)
            {
            $('#paidStatus').removeAttr('class','d-none');
            }
          else
            {
            $('#paidStatus').attr('class','d-none');
            }
          });
        });
    </script>