<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Product Stock Report</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Stock Report</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Product Stock Report</h3>
                <!--<a class="btn btn-primary" href="<?php echo site_url('Product/stock_product_export'); ?>" style="float: right" ><i class="far fa-file-excel"></i> Export Excel</a>-->
              </div>

              <div class="card-body">
                <div class="row">
                  <div class="col-md-6 col-sm-6 col-xs-12">
                  <form action="<?php echo base_url(); ?>stockReport" method="get">
                    <div class="row">
                    <input type="hidden" class="form-control" name="sType" value="1" required >
                      <div class="form-group col-md-8 col-sm-8 col-xs-12">
                        <label>Select Category *</label>
                        <select class="form-control" name="category" required >
                          <option value="">Select One</option>
                          <?php foreach($category as $value) { ?>
                          <option value="<?php echo $value['categoryID']; ?>"><?php echo $value['categoryName']; ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <div class="form-group col-md-3 col-sm-3 col-xs-12">
                        <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus" ></i>&nbsp;Search</button>
                      </div>
                    </div>
                  </form>
                  </div>
                  
                  <div class="col-md-6 col-sm-6 col-xs-12">
                  <form action="<?php echo base_url(); ?>stockReport" method="get">
                    <div class="row">
                      <input type="hidden" class="form-control" name="sType" value="2" required >
                      <div class="form-group col-md-8 col-sm-8 col-xs-12">
                        <label>Select Product Type *</label>
                        <select class="form-control" name="ptype" required >
                          <option value="">Select One</option>
                          <option value="1">Fresh Product</option>
                          <option value="2">Damage Product</option>
                        </select>
                      </div>
                      <div class="form-group col-md-3 col-sm-3 col-xs-12">
                        <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus" ></i>&nbsp;Search</button>
                      </div>
                    </div>
                  </form>
                  </div>
                </div>
                
                <div id="print">
                  <table id="example" class="table table-responsive table-bordered" >
                    <thead>
                      <tr>
                        <th style="width: 5%;">#SN.</th>
                        <th>Name</th>
                        <th>Code</th>
                        <th>Sale</th>
                        <th>Purchase</th>
                        <th>In Qnt</th>
                        <th>Out Qnt</th>
                        <th>Stock</th>
                        <th>D-Stock</th>
                        <th>Sale Price</th>
                        <th style="width: 10%;">Purchase Price</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $i = 0;
                      $tpiq = 0;
                      $tpoq = 0;
                      $tpsq = 0;
                      $tpsp = 0;
                      $tppp = 0;
                      $tdpsq = 0;
                      foreach ($stock as $result){
                      $i++;
                      $pid = $result->product;
                      $cid = $result->compid;

                      $pp = $this->db->select("SUM(purchase_product.quantity) as tpq,purchase.compid")
                                    ->from('purchase_product')
                                    ->join('purchase','purchase.purchaseID = purchase_product.purchaseID','left')
                                    ->where('productID',$pid)
                                    // ->group_by('purchase_product.purchaseID')
                                    ->get()
                                    ->row();
                                    
                      $pRate = $this->db->select("purchase_product.pprice, purchase.compid, purchase_product.productID")
                                    ->from('purchase_product')
                                    ->join('purchase','purchase.purchaseID = purchase_product.purchaseID','left')
                                    ->where('purchase_product.productID',$pid)
                                    ->order_by('purchase_product.regdate', 'desc')
                                    ->limit(1)
                                    ->get()
                                    ->row();
                        // var_dump($pRate);

                      $spp = $this->db->select("SUM(sale_product.quantity) as tsq,sales.compid")
                                    ->from('sale_product')
                                    ->join('sales','sales.saleID = sale_product.saleID','left')
                                    ->where('productID',$pid)
                                    // ->group_by('sale_product.saleID')
                                    ->get()
                                    ->row();
                        // var_dump($spp);
                      
                      $sRate = $this->db->select("sale_product.sprice, sales.compid, sale_product.productID")
                                    ->from('sale_product')
                                    ->join('sales','sales.saleID = sale_product.saleID','left')
                                    ->where('sale_product.productID',$pid)
                                    ->order_by('sale_product.regdate', 'desc')
                                    ->limit(1)
                                    ->get()
                                    ->row();
                      
                      $rp = $this->db->select("SUM(returns_product.quantity) as trq,returns.compid")
                                    ->from('returns_product')
                                    ->join('returns','returns.returnId = returns_product.rt_id','left')
                                    ->where('productID',$pid)
                                    // ->group_by('returns_product.rt_id')
                                    ->get()
                                    ->row();
                      
                      $rpp = $this->db->select("SUM(quantity) as trq")
                                    ->from('preturns_product')
                                    ->where('product',$pid)
                                    ->get()
                                    ->row();

                      ?>
                      <tr>
                        <td><?= $i; ?></td>
                        <td><?= $result->productName; ?></td>
                        <td><?= $result->productcode; ?></td>
                        <td><?= $result->sprice; ?></td>
                        <td><?= $result->pprice; ?></td>
                        <td>
                            <?php 
                            // var_dump($spp);
                            if ($pp && $rpp) { 
                                $difference = $pp->tpq - $rpp->trq;
                                echo $difference; 
                                $tpiq += $difference;
                            } elseif ($pp && !$rpp) {
                                echo $pp->tpq; 
                                $tpiq += $pp->tpq;
                            } else { 
                                echo '00'; 
                                $tpiq += 0; // Ensure it's added as 0 not as a string
                            } 
                            ?>
                        </td>
                        <td>
                            <?php 
                            if ($spp && $rp) {
                                $sold_diff = $spp->tsq - $rp->trq;
                                echo $sold_diff;
                                $tpoq += $sold_diff;
                            } elseif ($spp && !$rp) {
                                echo $spp->tsq;
                                $tpoq += $spp->tsq;
                            } else {
                                echo '00'; 
                                $tpoq += 0; // Ensure it's added as 0 not as a string
                            }
                            ?>
                        </td>
                        <td><?= $result->totalPices; $tpsq += $result->totalPices; ?></td>
                        <td><?= $result->dtquantity; $tdpsq += $result->dtquantity; ?></td>
                        <td><?= number_format(($result->totalPices * $result->sprice), 2); $tpsp += ($result->totalPices * $result->sprice); ?></td>
                        <td><?= number_format(($result->totalPices * $result->pprice), 2); $tppp += ($result->totalPices * $result->pprice); ?></td>
                    </tr>

                      <?php } ?>
                    </tbody>
                    <tfoot>
                      <tr>
                        <th colspan="5" style="text-align: right;" >Total</th>
                        <th><?php echo $tpiq; ?></th>
                        <th><?php echo $tpoq; ?></th>
                        <th><?php echo $tpsq; ?></th>
                        <th><?php echo $tdpsq; ?></th>
                        <th><?php echo number_format($tpsp, 2); ?></th>
                        <th><?php echo number_format($tppp, 2); ?></th>
                      </tr>
                    </tfoot>
                  </table>
                </div><br>
                <div class="form-group col-md-12" style="text-align: center;margin-top: 20px">
                  <a href="javascript:void(0)" style="width: 100px;" value="Print" onclick="printDiv('print')" class="btn btn-primary"><i class="fa fa-print"> </i>  Print</a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

<?php $this->load->view('footer/footer'); ?>