<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Product History Report</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Product History Report</li>
          </ol>
        </div>
      </div>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-12 col-sm-12 col-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Product History Report</h3>
              <a class="btn btn-success btn-sm" href="<?php echo site_url('Product/stock_product_export'); ?>" style="float: right; margin-right: 10px;"><i class="far fa-file-excel"></i> Export Excel</a>
            </div>

            <div class="card-body">
              <div class="col-sm-12 col-md-12 col-12">
                <form action="<?php echo base_url(); ?>historyProduct2" method="get">
                  <div class="col-md-12 col-sm-12 col-12">
                    <div class="form-group col-md-12 col-sm-12 col-12">
                      <b>
                        <input type="radio" name="reports" value="categoryReports" id="category" required> Category
                        <input type="radio" name="reports" value="productReports" id="product" required> Product
                        <input type="radio" name="reports" value="allReports" id="all" required> All Products
                      </b>
                    </div>

                    <!-- Category Reports Form -->
                    <div class="d-none" id="creports">
                      <div class="row">
                        <div class="form-group col-md-3 col-sm-3 col-12">
                          <label>Start Date *</label>
                          <input type="text" class="form-control datepicker" name="csdate" value="<?php echo date('m/d/Y') ?>" id="csdate" required>
                        </div>
                        <div class="form-group col-md-3 col-sm-3 col-12">
                          <label>End Date *</label>
                          <input type="text" class="form-control datepicker" name="cedate" value="<?php echo date('m/d/Y') ?>" id="cedate" required>
                        </div>
                        <div class="form-group col-md-4 col-sm-4 col-12">
                          <label>Select Category *</label>
                          <select class="form-control select2" name="category" id="categorySelect" required>
                            <option value="">Select One</option>
                            <option value="All">All Categories</option>
                            <?php foreach($category as $value) { ?>
                              <option value="<?php echo $value['categoryID']; ?>"><?php echo $value['categoryName']; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <div class="form-group col-md-2 col-sm-2 col-12">
                          <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus"></i> Search</button>
                        </div>
                      </div>
                    </div>

                    <!-- Product Reports Form -->
                    <div class="d-none" id="preports">
                      <div class="row">
                        <div class="form-group col-md-3 col-sm-3 col-12">
                          <label>Start Date *</label>
                          <input type="text" class="form-control datepicker" name="psdate" value="<?php echo date('m/d/Y') ?>" id="psdate" required>
                        </div>
                        <div class="form-group col-md-3 col-sm-3 col-12">
                          <label>End Date *</label>
                          <input type="text" class="form-control datepicker" name="pedate" value="<?php echo date('m/d/Y') ?>" id="pedate" required>
                        </div>
                        <div class="form-group col-md-4 col-sm-4 col-12">
                          <label>Select Product *</label>
                          <select class="form-control select2" name="product" id="productSelect" required>
                            <option value="">Select One</option>
                            <option value="All">All Products</option>
                            <?php foreach($product as $value) { ?>
                             <option value="<?php echo $value['productID']; ?>"><?php echo $value['productName'] . ' (' . $value['productcode'] . ')'; ?></option>

                            <?php } ?> 
                          </select>
                        </div>
                        <div class="form-group col-md-2 col-sm-2 col-12">
                          <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus"></i> Search</button>
                        </div>
                      </div>
                    </div>

                    <!-- All Products Reports Form -->
                    <div class="d-none" id="areports">
                      <div class="row">
                        <div class="form-group col-md-3 col-sm-3 col-12">
                          <label>Start Date *</label>
                          <input type="text" class="form-control datepicker" name="asdate" value="<?php echo date('m/d/Y') ?>" id="asdate" required>
                        </div>
                        <div class="form-group col-md-3 col-sm-3 col-12">
                          <label>End Date *</label>
                          <input type="text" class="form-control datepicker" name="aedate" value="<?php echo date('m/d/Y') ?>" id="aedate" required>
                        </div>
                        <div class="form-group col-md-2 col-sm-2 col-12">
                          <button type="submit" name="search" class="btn btn-info" style="margin-top: 30px;"><i class="fa fa-search-plus"></i> Search</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>

              <!-- Table -->
              <div class="col-sm-12 col-md-12 col-12">
                <div id="print">
                  <div class="d-flex justify-content-center mt-4">
                    <div class="text-center p-4 bg-light rounded shadow-sm" style="min-width: 300px; max-width: 600px;">
                      <?php if (!empty($selected_category_name)) : ?>
                        <h5 class="mb-3" style="font-weight: bold; color: #000;">
                          Category:
                          <span style="font-weight: bold; color: #000;">
                            <?php echo htmlspecialchars($selected_category_name == 'All Categories' ? 'All Categories' : $selected_category_name); ?>
                          </span>
                        </h5>
                      <?php endif; ?>
                      <?php if (!empty($selected_product_name)) : ?>
                        <h5 class="mb-0" style="font-weight: bold; color: #000;">
                          Product:
                          <span style="font-weight: bold; color: #000;">
                            <?php echo htmlspecialchars($selected_product_name); ?>
                            <?php if ($selected_product_name != 'All Products' && isset($selected_product_code) && $selected_product_code !== 'All products') : ?>
                              (<?php echo htmlspecialchars($selected_product_code ?: 'N/A'); ?>)
                            <?php endif; ?>
                          </span>
                        </h5>
                      <?php endif; ?>
                    </div>
                  </div>

                  <table id="example" class="table table-bordered">
                    <thead>
                      <tr>
                        <th style="width: 5%;">#SL. No.</th>
                        <th>Customer Name</th>
                        <th>Invoice Date</th>
                        <th>Invoice No</th>
                        <th>Sold Quantity</th>
                        <th>Selling Price</th>
                        <th>Total</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $i = 1;
                      $totalAmount = 0;
                      if (!empty($sales)) {
                          foreach ($sales as $result) {
                      ?>
                      <tr>
                        <td><?php echo $i++; ?></td>
                        <td><?php echo isset($result->customerName) ? htmlspecialchars($result->customerName) : ''; ?></td>
                        <td><?php echo isset($result->invoiceDate) ? htmlspecialchars($result->invoiceDate) : ''; ?></td>
                        <td><?php echo isset($result->invoiceNo) ? htmlspecialchars($result->invoiceNo) : ''; ?></td>
                        <td><?php echo isset($result->soldQuantity) ? htmlspecialchars($result->soldQuantity) : '0'; ?></td>
                        <td><?php echo isset($result->sellingPrice) ? number_format($result->sellingPrice, 2) : '0.00'; ?></td>
                        <td><?php echo isset($result->total) ? number_format($result->total, 2) : '0.00'; $totalAmount += isset($result->total) ? $result->total : 0; ?></td>
                      </tr>
                      <?php
                          }
                      } else {
                          echo '<tr><td colspan="7">No data available in table</td></tr>';
                      }
                      ?>
                    </tbody>
                    <tfoot>
                      <tr>
                        <th colspan="6" style="text-align: right;">Total</th>
                        <th><?php echo number_format($totalAmount, 2); ?></th>
                      </tr>
                    </tfoot>
                  </table>
                </div>
                <div class="row no-print">
                  <div class="col-sm-12 col-md-12 col-12" style="text-align: center;">
                    <a href="javascript:void(0)" class="btn btn-primary" onclick="printDiv('print')"><i class="fas fa-print"></i> Print</a>
                  </div>
                </div>
              </div><!-- /col -->
            </div><!-- /card-body -->
          </div><!-- /card -->
        </div>
      </div>
    </div>
  </section>
</div>

<?php $this->load->view('footer/footer'); ?>

<script type="text/javascript">
  $(document).ready(function() {
    // DataTables
    $('#example').DataTable();

    // Datepicker
    $('.datepicker').datepicker({
      format: 'mm/dd/yyyy',
      autoclose: true,
      todayHighlight: true
    });

    // Radio button logic
    $('#category').click(function() {
      $('#creports').removeClass('d-none');
      $('#preports').addClass('d-none');
      $('#areports').addClass('d-none');
      $('#categorySelect').prop('required', true);
      $('#productSelect').prop('required', false);
      $('#csdate, #cedate').prop('required', true);
      $('#psdate, #pedate, #asdate, #aedate').prop('required', false);
    });

    $('#product').click(function() {
      $('#preports').removeClass('d-none');
      $('#creports').addClass('d-none');
      $('#areports').addClass('d-none');
      $('#categorySelect').prop('required', false);
      $('#productSelect').prop('required', true);
      $('#psdate, #pedate').prop('required', true);
      $('#csdate, #cedate, #asdate, #aedate').prop('required', false);
    });

    $('#all').click(function() {
      $('#areports').removeClass('d-none');
      $('#creports').addClass('d-none');
      $('#preports').addClass('d-none');
      $('#categorySelect').prop('required', false);
      $('#productSelect').prop('required', false);
      $('#asdate, #aedate').prop('required', true);
      $('#csdate, #cedate, #psdate, #pedate').prop('required', false);
    });

    // Initialize Select2
    $('.select2').select2();
  });

  function printDiv(divId) {
    var printContents = document.getElementById(divId).innerHTML;
    var originalContents = document.body.innerHTML;
    document.body.innerHTML = printContents;
    window.print();
    document.body.innerHTML = originalContents;
  }
</script>