<?php $this->load->view('header/header'); ?>
<?php $this->load->view('navbar/navbar'); ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Product</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>Dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Product</li>
            </ol>
          </div>
        </div>
      </div>
    </section>

    <?php
    $exception = $this->session->userdata('exception');
    if(isset($exception))
    {
    echo $exception;
    $this->session->unset_userdata('exception');
    } ?>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12 col-sm-12 col-12">
            <div class="card">
              <div class="card-header"> 
                <h3 class="card-title">Product List</h3>
                <?php if($_SESSION['newproduct'] == 1){ ?>
                <button type="button" class="btn btn-primary product_add" data-toggle="modal" 
                data-target=".bs-example-modal-product_add" style="float: right; margin-left: 10px;" >
                    <i class="fa fa-plus"></i>&nbsp;Add Product</button>
                <?php } if($_SESSION['storeproduct'] == 1){ ?>
                <button type="button" class="btn product_store" data-toggle="modal" 
                data-target=".bs-example-modal-product_store" 
                style="float: right; margin-left: 10px;background-color:#dc35cd;color:white;" >
                    <i class="fa fa-plus"></i>&nbsp;Store Product</button>
                <!--<button type="button" class="btn btn-danger damageProduct" data-toggle="modal" -->
                <!--data-target=".bs-example-modal-damageProduct" style="float: right; margin-left: 10px;" >-->
                <!--    <i class="fa fa-plus"></i>&nbsp;Damage Product</button>-->
                <?php } ?>
                <button type="button" class="btn template" data-toggle="modal" data-target=".bs-example-modal-template" 
                style="float: right;background-color:#9ea728;color:white;" ><i class="fa fa-file-excel"></i> Import</button>
              </div>

              <div class="card-body">
                <table id="example" class="table table-bordered" >
                  <thead>
                    <tr>
                      <th style="width: 5%;">#SN.</th>
                      <!--<th>Image</th>-->
                      <th>Product Model</th>
                      <th>Name</th>
                      <th>Category</th>
                      <!--<th>Supplier</th>-->
                      <!--<th>Unit</th>-->
                      <th>Purchase</th>
                      <th>Sales</th>
                      <th>Quantity</th>
                       <!--<th>Product Piece</th>-->
                      <!--<th>Damage Stock</th>-->
                      <th style="width: 10%;">Action</th> 
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $i = 0;
                    foreach ($product as $value){
                    $i++;
                    
                    $stock = $this->db->select('*')
                                    ->from('stock')
                                    ->where('product',$value['productID'])
                                    //->where('compid',$_SESSION['compid'])
                                    ->get()
                                    ->row();

                    if($stock)
                      {
                      $st = $stock->totalPices;
                      $dst = $stock->dtquantity;
                      }
                    else
                      {
                      $st = '0';
                      $dst = 0;
                      }
                    ?>
                    <tr>
                      <td><?php echo $i; ?></td>
                      <!--<td>-->
                      <!--  <?php if($value['image'] == null) { ?>-->
                      <!--  <i class="fa fa-shopping-cart fa-4x" aria-hidden="true" ></i>-->
                      <!--  <?php } else{ ?> -->
                      <!--  <img src="<?php echo base_url().'/upload/product/'.$value['image']; ?>" style="width: 50px; height: 50px;">-->
                      <!--  <?php } ?> -->
                      <!--</td>-->
                      <td><a href="<?php echo site_url('viewProduct').'/'.$value['productID']; ?>">
                          <?php echo $value['productcode']; ?></a></td>
                      <td><?php echo $value['productName']; ?></td>
                      <td><?php echo $value['categoryName']; ?></td>
                      <!--<td><?php echo $value['supplierName']; ?></td>-->
                      
                      <!--<td><?php echo $value['unitName']; ?></td>-->
                      <td><?php echo number_format($value['pprice'], 2); ?></td>
                      <td><?php echo number_format($value['sprice'], 2); ?></td>
                      <td><?php echo $st; ?></td>
                      <!--<td><?php echo $value['totalppiece']; ?></td>-->
                      <!--<td><?php echo $dst; ?></td>    -->
                      <td>
                        <div class="input-group input-group-md mb-3">
                          <div class="input-group-prepend">
                            <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown"> Action </button>
                            <ul class="dropdown-menu">
                              <li class="dropdown-item"><a href="<?php echo site_url('viewProduct').'/'.$value['productID']; ?>">
                                  <i class="fa fa-eye"></i> View</a></li>
                              <li class="dropdown-divider"></li>
                              <?php if($_SESSION['editproduct'] == 1){ ?>
                              <li class="dropdown-item"><a href="<?php echo site_url('editProduct').'/'.$value['productID']; ?>">
                                  <i class="fa fa-edit"></i> Edit</a></li>
                              <?php } if($_SESSION['deleteproduct'] == 1){ ?>
                              <li class="dropdown-divider"></li>
                              <li class="dropdown-item"><a href="<?php echo site_url('Product/delete_products').'/'.$value['productID']; ?>">
                                  <i class="fa fa-trash"></i> Delete</a></li>
                              <?php } if($_SESSION['barcodeproduct'] == 1){ ?>
                              <li class="dropdown-divider"></li>
                              <li class="dropdown-item"><a href="<?php echo site_url('pBarcode').'/'.$value['productID']; ?>">
                                  <i class="fa fa-print"></i> Barcode</a></li>
                              <?php } ?>
                            </ul>
                          </div>
                        </div>
                      </td>
                    </tr>   
                    <?php } ?> 
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>


    <div class="modal fade bs-example-modal-product_add" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-sm">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Product Information</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          </div>
          <form method="POST" action="<?php echo base_url() ?>Product/save_product" enctype="multipart/form-data" >
            <div class="form-group col-md-12 col-sm-12 col-12">
              <input type="text" class="form-control" name="pCode" placeholder="Product Model ★" required >
            </div>
            <div class="form-group col-md-12 col-sm-12 col-12">
              <input type="text" class="form-control" name="productName" placeholder="Product Name ★" required >
            </div>
            <!--<div class="form-group col-md-12 col-sm-12 col-12">-->
            <!--  <select name="supplier" class="form-control" required >-->
            <!--    <option value="">Select Supplier ★</option>-->
            <!--    <?php foreach($supplier as $value) { ?>-->
            <!--    <option value="<?php echo $value['supplierID']; ?>"><?php echo $value['supplierName'].' ( '.$value['mobile'].' )'; ?></option>-->
            <!--    <?php } ?>-->
            <!--  </select>-->
            <!--</div>-->
            <div class="form-group col-md-12 col-sm-12 col-12">
              <select name="categoryID" id="categoryID" class="form-control" required >
                <option value="">Select category ★</option>
                <?php foreach($category as $value) { ?>
                <option value="<?php echo $value['categoryID']; ?>"><?php echo $value['categoryName']; ?></option>
                <?php } ?>
                <option value="newCategory">New Category</option>
              </select>
            </div>
            <div class="d-none" id="newCategory">
              <div class="form-group col-md-12 col-sm-12 col-12">
                <input type="text" class="form-control" name="newCategory" placeholder="New Category ★" id="newcat" required="" >
              </div>
            </div>
            <div class="form-group col-md-12 col-sm-12 col-12">
              <select name="units" id="unit" class="form-control" required >
                <option value="">Select units ★</option>
                <?php  foreach($unit as $value) { ?>
                <option value="<?php echo $value['id']; ?>"><?php echo $value['unitName']; ?></option>
                <?php } ?>
                <option value="newUnit">New Unit</option>
              </select>
            </div>
            <div class="d-none" id="newUnit">
              <div class="form-group col-md-12 col-sm-12 col-12">
                <input type="text" class="form-control" name="newUnit" placeholder="New Unit ★" id="newut" required="" >
              </div>
            </div>
            <div class="form-group col-md-12 col-sm-12 col-12">
              <input type="text" class="form-control" name="pprice" placeholder="Purchase price ★" required >
            </div>
            <div class="form-group col-md-12 col-sm-12 col-12">
              <input type="text" class="form-control" name="sprice" placeholder="Sale price"   >
            </div>
            <div class="form-group col-md-12 col-sm-12 col-12">
              <input type="text" class="form-control" name="warranty" placeholder="Product warranty"   >
            </div>
            <!--<div class="form-group col-md-12 col-sm-12 col-12">-->
            <!--  <label>Product Image <br><small style="color: red; font-size:10px">( Maximum image size 500kb and png, jpg format )</small></label>-->
            <!--  <input type="file" name="userfile" >-->
            <!--</div>-->
            <div class="modal-footer form-group">
              <button type="submit" class="btn btn-primary"><i class="far fa-save"></i>&nbsp;&nbsp;Submit</button>
              <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="far fa-window-close"></i>&nbsp;&nbsp;Cancel</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div class="modal fade bs-example-modal-product_store" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-sm">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Store Information</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          </div>
          <form action="<?php echo base_url() ?>Product/save_product_store" method="POST" >
            <div class="col-md-12 col-sm-12 col-12">
              <div class="form-group">
                <label>Select Product</label>
                <div>
                <select name="product" class="form-control select2" required style="width: 100%;" >
                  <option value="">Select One</option>
                  <?php foreach($product as $value) { ?>
                  <option value="<?php echo $value['productID']; ?>"><?php echo $value['productName'].' ( '.$value['productcode'].' )'; ?></option>
                  <?php } ?>
                </select>
                </div>
              </div>
              <div class="form-group">
                <label>Product Piece</label>
                <input type="text" class="form-control" name="quantity" placeholder="Product Cartoon" required >
              </div>
              <!--<div class="form-group">-->
              <!--  <label>Product Piece</label>-->
              <!--  <input type="text" class="form-control" name="pquantity" placeholder="Product Quantity" required >-->
              <!--</div>-->
            </div>
            <div class="modal-footer form-group">
              <button type="submit" class="btn btn-primary"><i class="far fa-save"></i>&nbsp;&nbsp;Submit</button>
              <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="far fa-window-close"></i>&nbsp;&nbsp;Cancel</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    
    <div class="modal fade bs-example-modal-damageProduct" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-sm">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Damage Product Info.</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          </div>
          <form action="<?php echo base_url() ?>Product/save_damage_product" method="POST" >
            <div class="col-md-12 col-sm-12 col-12">
              <div class="form-group">
                <label>Select Product</label>
                <select name="product" class="form-control" required >
                  <option value="">Select One</option>
                  <?php foreach($product as $value) { ?>
                  <option value="<?php echo $value['productID']; ?>"><?php echo $value['productName'].' ( '.$value['productcode'].' )'; ?></option>
                  <?php } ?>
                </select>
              </div>
              <div class="form-group">
                <label>Damage Quantity</label>
                <input type="text" class="form-control" name="quantity" placeholder="Damage Quantity" required >
              </div>
            </div>
            <div class="modal-footer form-group">
              <button type="submit" class="btn btn-primary"><i class="far fa-save"></i>&nbsp;&nbsp;Submit</button>
              <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="far fa-window-close"></i>&nbsp;&nbsp;Cancel</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div id="templete" class="modal fade bs-example-modal-template" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-md">
        <div class="modal-content" >
          <div class="modal-header">
            <h4 class="modal-title">Import Product</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
          </div>
          <div class="col-md-12 col-sm-12 col-12">
            <div class="row">
              <div class="form-group col-md-6 col-sm-6 col-12">
                <div style="width: 100%;height: 100px;background: #fff4f4;text-align: center;">
                  <a href="<?php echo base_url('assets/templates/products.xlsx') ?>" style="padding:1em;text-align: center;display:inline-block;text-decoration: none !important;margin:0 auto;">Blank format</a>
                </div>
              </div>
              <div class="form-group col-md-6 col-sm-6 col-12">
                <div style="width: 100%;height: 100px;background: #fff4f4;text-align: center;">
                  <a href="<?php echo base_url('Product/export_action') ?>" style="padding:1em;text-align: center;display:inline-block;text-decoration: none !important;margin:0 auto;">Sample data</a>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-12 col-sm-12 col-12">
            <form method="post" id="import_form" enctype="multipart/form-data">
              <div class="form-group col-md-12 col-sm-12 col-12">
                <label>Import Product<span style="color: red">  *</span><br>(Excel file Upload)</label>
                <input type="file" name="file" id="file" required accept=".xls, .xlsx" >
              </div>
              <div class="form-group col-md-12 col-sm-12 col-12" style="margin-top: 20px; text-align: center;">
                <input type="submit" name="import" value="Import" class="btn btn-primary" >
              </div>
            </form>
            <div class="progress">
              <div id="progressBar" class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
          </div>
        </div>
      </div>
    </div>

<?php $this->load->view('footer/footer'); ?>

      <script type="text/javascript">
        $(document).ready(function(){
          $('#categoryID').change(function(){
            var catid = $('#categoryID').val();
              //alert(catid);
            if(catid == 'newCategory')
              {
              $('#newCategory').removeAttr('class','d-none');
              $('#newcat').attr('required','required');
              }
            else
              {
              $('#newCategory').attr('class','d-none');
              $('#newcat').removeAttr('required','required');
              }
            });
          });
      </script>

      <script type="text/javascript">
        $(document).ready(function(){
          $('#unit').change(function(){
            var catid = $('#unit').val();
              //alert(catid);
            if(catid == 'newUnit')
              {
              $('#newUnit').removeAttr('class','d-none');
              $('#newut').attr('required','required');
              }
            else
              {
              $('#newUnit').attr('class','d-none');
              $('#newut').removeAttr('required','required');
              }
            });
          });
      </script>

           <script type="text/javascript">
        $(document).ready(function(){
          $('#import_form').on('submit',function(event){
            event.preventDefault();
            $.ajax({
              url:"<?php echo base_url(); ?>Product/excel_import",
              method:"POST",
              data:new FormData(this),
              contentType:false,
              cache:false,
              processData:false,
              xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener('progress', function (e) {
                  if (e.lengthComputable) {
                    var percent = Math.round((e.loaded / e.total) * 100);
                    $('#progressBar').css('width', percent + '%').html(percent + '%');
                  }
                });
                return xhr;
              },
              success:function(data){
                $('#file').val('');
                // load_data();
                // alert(data);
                console.log(data);
                $('#templete').remove();
                $('.modal-backdrop').remove();
                // window.location.reload();
              }
            });
          });
        });
      </script>    
      