<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Prime_model extends CI_Model {

public function get_data($table,$where = false,$fields = false,$join_table = false,$other = false)
  {
  if ($fields != false)
    {
    foreach ($fields as $coll => $value)
      {
      $this->db->select($value);
      }
    }

  $this->db->from($table);

  if($join_table != false)
    {
    if(is_array($other) && array_key_exists('join',$other))
      {
      foreach($join_table as $coll => $value)
        {
        $this->db->join($coll, $value, $other['join']);
        }
      }
    else
      {
      foreach($join_table as $coll => $value)
        {
        $this->db->join($coll, $value);
        }
      }
    }

  if($where != false)
    {
    $this->db->where($where);
    }

  if($other != false)
    {
    if(array_key_exists('or_where', $other))
      {
      $this->db->or_where($other['or_where']);
      }
    if(array_key_exists('order_by', $other))
      {
      $this->db->order_by($other['order_by'], 'desc');
      }
    if(array_key_exists('group_by', $other))
      {
      $this->db->group_by($other['group_by']);
      }
    if(array_key_exists('limit', $other))
      {
      if(array_key_exists('offset', $other))
        {
        $this->db->limit($other['limit'], $other['offset']);
        }
      else
        {
        $this->db->limit($other['limit']);
        }
      }

    if(array_key_exists('like', $other))
      {
      foreach ($other['like'] as $key => $value)
        {
        $this->db->like($key, $value);
        }
      }
    if(array_key_exists('or_like', $other))
      {
      foreach ($other['or_like'] as $key => $value)
        {
        $this->db->or_like($key, $value);
        }
      }
    }
  $query = $this->db->get();
// $query2=$this->db->last_query($query);
// var_dump($query2);
// die();
  $result = $query->result_array();

  return $result;
}

public function insert_data($table,$data)
  {
  $this->db->insert($table,$data);
  
  return $this->db->insert_id();
}

public function update_data($table,$data = false,$where = false)
  {
  $this->db->update($table,$data,$where);

  return $this->db->affected_rows();
}

public function delete_data($table, $where)
  {
  $this->db->where($where);
  $this->db->delete($table);
  
  return $this->db->affected_rows();
}

public function count_all($tbl)
  {
  return $this->db->count_all($tbl);
}

public function all_query($sql)
  {
  return $result = $this->db->query($sql)->result_array();
}

public function check_user_email($id)
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('email',$id)
                ->get();

  $count_row = $query->num_rows();

  if($count_row == 0)
    {
    return 1;
    }
  else
    {
    return 0;
    }
}

public function get_category_data($id)
  {
  $query = $this->db->select('*')
                ->from('categories')
                ->where('categoryID',$id)
                ->get()
                ->row();
  return $query;
}

public function get_unit_data($id)
  {
  $query = $this->db->select('*')
                ->from('sma_units')
                ->where('id',$id)
                ->get()
                ->row();
  return $query;
}

public function get_cost_type_data($id)
  {
  $query = $this->db->select("*")
                  ->from('cost_type')
                  ->where('ct_id',$id)
                  ->get()
                  ->row();

  return $query;  
}

public function get_dept_data($id)
  {
  $query = $this->db->select('*')
                  ->from('department')
                  ->where('dpt_id',$id)
                  ->get()
                  ->row();
  return $query; 
}

public function get_bank_account($id)
  {
  $query = $this->db->select('*')
                ->from('bankaccount')
                ->where('ba_id',$id)
                ->get()
                ->row();
  return $query;
}

public function get_mobile_transaction($id)
  {
  $query = $this->db->select('*')
                ->from('mobileaccount')
                ->where('ma_id',$id)
                ->get()
                ->row();
  return $query;
}
public function get_due_inv($cust)
  {
  $query = $this->db->select('invoice_no, dueamount, paidAmount, totalAmount, saleID')
                ->from('sales')
                ->where('customerID',$cust)
                ->where('dueamount >', 0)
                ->get()
                ->result();
  return $query;
}
public function get_pur_due_inv($supp)
  {
  $query = $this->db->select('challanNo, due, paidAmount, totalPrice, purchaseID')
                ->from('purchase')
                ->where('supplier',$supp)
                ->where('due >', 0)
                ->get()
                ->result();
  return $query;
}

public function get_user_notice()
  {
  $query = $this->db->select('*')
                    ->from('notice')
                    ->or_where('ntype','All')
                    ->or_where('ntype',$_SESSION['uid'])
                    ->order_by('nid','DESC')
                    ->get()
                    ->result();
  return $query;
}

public function get_user_role_data($id)
  {
  $query = $this->db->select('*')
                ->from('access_lavels')
                ->where('ax_id',$id)
                ->get()
                ->row();
  return $query;
}

public function get_customer_data($id)
  {
  $query = $this->db->select('*')
                  ->from('customers')
                  ->where('customerID',$id)
                  ->get()
                  ->row();
  return $query; 
}

public function get_data_with_due($where){

  $query = $this->db->select("(c.customerID) AS customerID,(c.customerName) AS customerName,(c.mobile) as mobile,sum(s.dueamount) as due")
                    ->from('customers c')
                    ->join('sales s','s.customerID=c.customerID','left')
                    ->where('c.compid',$where)
                    ->group_by('c.customerID')
                    ->order_by('c.regdate DESC')
                    ->get()
                    ->result_array();
  return $query;
}
public function get_data_with_pay_due($where){

  $query = $this->db->select("(c.supplierID) AS supplierID,(c.supplierName) AS supplierName,(c.mobile) as smobile,sum(s.dueamount) as due")
                    ->from('suppliers c')
                    ->join('purchase s','s.supplier=c.supplierID','left')
                    ->where('c.compid',$where)
                    ->group_by('c.supplierID')
                    ->order_by('c.regdate DESC')
                    ->get()
                    ->result_array();
  return $query;
}
public function get_sales_report_data()
{
    $query = $this->db->select('
        customers.customerName AS customerName, 
        sales.saleDate AS invoiceDate, 
        sales.invoice_no AS invoiceNo, 
        SUM(sale_product.quantity) AS soldQuantity, 
        sale_product.sprice AS sellingPrice, 
        (sale_product.quantity * sale_product.sprice) AS total
    ')
    ->from('sale_product')
    ->join('sales', 'sales.saleID = sale_product.saleID', 'left')
    ->join('customers', 'customers.customerID = sales.customerID', 'left')
    ->group_by('invoiceNo')
    ->get()
    ->result();
    
    return $query;
}
public function get_sales_report_data_all_product($sdate, $edate)
{
    $query = $this->db->select('
        customers.customerName AS customerName, 
        sales.saleDate AS invoiceDate, 
        sales.invoice_no AS invoiceNo, 
        SUM(sale_product.quantity) AS soldQuantity, 
        sale_product.sprice AS sellingPrice, 
        (sale_product.quantity * sale_product.sprice) AS total
    ')
    ->from('sale_product')
    ->join('sales', 'sales.saleID = sale_product.saleID', 'left')
    ->join('customers', 'customers.customerID = sales.customerID', 'left')
    ->group_by('invoiceNo')
    ->where('sales.saleDate >=', $sdate )
    ->where('sales.saleDate <=', $edate )
    ->get()
    ->result();
    
    return $query;
}
public function get_sales_report_data_by_product($sdate, $edate, $pid)
{
    if($pid != 'All'){
        $query = $this->db->select('
            customers.customerName AS customerName, 
            sales.saleDate AS invoiceDate, 
            sales.invoice_no AS invoiceNo, 
            sale_product.quantity AS soldQuantity, 
            sale_product.productID, 
            sale_product.sprice AS sellingPrice, 
            (sale_product.quantity * sale_product.sprice) AS total
        ')
        ->from('sale_product')
        ->join('sales', 'sales.saleID = sale_product.saleID', 'left')
        ->join('customers', 'customers.customerID = sales.customerID', 'left')
        // ->group_by('invoiceNo')
        ->where('sales.saleDate >=', $sdate )
        ->where('sales.saleDate <=', $edate )
        ->where('sale_product.productID', $pid)
        ->get()
        ->result();
    }else{
        $query = $this->db->select('
            customers.customerName AS customerName, 
            sales.saleDate AS invoiceDate, 
            sales.invoice_no AS invoiceNo, 
            SUM(sale_product.quantity) AS soldQuantity, 
            sale_product.sprice AS sellingPrice, 
            (sale_product.quantity * sale_product.sprice) AS total
        ')
        ->from('sale_product')
        ->join('sales', 'sales.saleID = sale_product.saleID', 'left')
        ->join('customers', 'customers.customerID = sales.customerID', 'left')
        ->group_by('invoiceNo')
        ->where('sales.saleDate >=', $sdate )
        ->where('sales.saleDate <=', $edate )
        ->get()
        ->result();
    }
    
    return $query;
}

public function get_sales_report_data_by_category($sdate, $edate, $catid)
{
    if($catid != 'All'){
        $query = $this->db->select('
            customers.customerName AS customerName, 
            sales.saleDate AS invoiceDate, 
            sales.invoice_no AS invoiceNo, 
            sale_product.quantity AS soldQuantity, 
            sale_product.productID, 
            categories.categoryID, 
            sale_product.sprice AS sellingPrice, 
            (sale_product.quantity * sale_product.sprice) AS total
        ')
        ->from('sale_product')
        ->join('sales', 'sales.saleID = sale_product.saleID', 'left')
        ->join('products','products.productID = sale_product.productID', 'left')
        ->join('categories', 'categories.categoryID = products.categoryID', 'left')
        ->join('customers', 'customers.customerID = sales.customerID', 'left')
        // ->group_by('invoiceNo')
        ->where('sales.saleDate >=', $sdate )
        ->where('sales.saleDate <=', $edate )
        ->where('categories.categoryID', $catid)
        ->get()
        ->result();
    }else{
        $query = $this->db->select('
            customers.customerName AS customerName, 
            sales.saleDate AS invoiceDate, 
            sales.invoice_no AS invoiceNo, 
            SUM(sale_product.quantity) AS soldQuantity, 
            sale_product.sprice AS sellingPrice, 
            (sale_product.quantity * sale_product.sprice) AS total
        ')
        ->from('sale_product')
        ->join('sales', 'sales.saleID = sale_product.saleID', 'left')
        ->join('customers', 'customers.customerID = sales.customerID', 'left')
        ->group_by('invoiceNo')
        ->where('sales.saleDate >=', $sdate )
        ->where('sales.saleDate <=', $edate )
        ->get()
        ->result();
    }
    
    return $query;
}

public function get_sales_customer_data($id)
  {
  $cust = $this->db->select('customerID')
                  ->from('sales')
                  ->where('saleID',$id)
                  ->get()
                  ->row();
                  
  $query = $this->db->select('mobile')
                  ->from('customers')
                  ->where('customerID',$cust->customerID)
                  ->get()
                  ->row();
  return $query; 
}

public function get_supplier_data($id)
  {
  $query = $this->db->select('*')
                  ->from('suppliers')
                  ->where('supplierID',$id)
                  ->get()
                  ->row();
  return $query; 
}

public function get_emp_data($id)
  {
  $query = $this->db->select('*')
                  ->from('employees')
                  ->where('employeeID',$id)
                  ->get()
                  ->row();
  return $query; 
}

public function get_employee()
  {
  $emp = $this->db->select('empid')
        ->from('users')
        ->where('compid',$_SESSION['compid'])
        ->get()
        ->result_array();
    //var_dump($emp); exit();
  $emp_id = array_map (function($value){
  return $value['empid'];
  },$emp);
    //var_dump($emp_id); exit();
  if($emp_id == NULL)
      {
      $empid = 0;
      }
  else{
      $empid = $emp_id;
      }
    //var_dump($empid); exit();
  return $this->db->select('employeeID,employeeName')
              ->from('employees')
              ->where_not_in('employeeID',$empid)
              ->where('compid',$_SESSION['compid'])
              ->get()
              ->result();
}

public function get_user_data($id)
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('uid',$id)
                ->get()
                ->row();
  return $query;
}

public function company_profile_details()
  {
  $query = $this->db->select('*')
              ->from('com_profile')
              ->where('com_pid',1)
              ->get()
              ->row();
  return $query;  
}

public function company_details()
  {
  $query = $this->db->select('*')
              ->from('com_profile')
              ->where('com_pid',1)
              ->get()
              ->row();
  return $query;  
}

public function get_company_data($id)
  {
  $query = $this->db->select('*')
              ->from('com_profile')
              ->where('com_pid',$id)
              ->get()
              ->row();
  return $query;  
}

public function supplier_purchases_due_details($id,$sid)
  {
  $query = $this->db->select("SUM(`due`) as total")
                  ->FROM('purchase')
                  ->where_not_in('purchaseID',$id)
                  ->where('supplier',$sid)
                  ->get()
                  ->row();
  return $query;  
}

public function supplier_paid_details($sid)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('supplier',$sid)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function customer_sales_due_details($id,$cusid)
  {
  $query = $this->db->select("SUM(`totalAmount`) as total,SUM(`paidAmount`) as ptotal,SUM(`dueamount`) as dtotal")
                  ->FROM('sales')
                  ->where_not_in('saleID',$id)
                  ->WHERE('customerID',$cusid)
                  ->get()
                  ->row();
  return $query;  
}

public function customer_vaucher_paid_details($cusid)
  {
  $query = $this->db->select('SUM(`totalamount`) as total')
                  ->from('vaucher')
                  ->where('customerID',$cusid)
                  ->where('vauchertype','Credit Voucher')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query; 
}

public function customer_returns_details($cusid)
  {
  $query = $this->db->select('SUM(`paidAmount`) as total')
                  ->from('returns')
                  ->where('customerID',$cusid)
                  ->get()
                  ->row();
  return $query; 
}

public function customer_sales_payment($cusid)
  {
  $query = $this->db->select('SUM(sales_payment.amount) as total,sales.customerID, sales_payment_details.paidamount')
                  ->from('sales_payment')
                  ->join('sales_payment_details','sales_payment_details.sp_id = sales_payment.sp_id','left')
                  ->join('sales','sales.saleID = sales_payment_details.saleID','left')
                  ->where('sales.customerID',$cusid)
                  ->get()
                  ->row();
  return $query; 
}

public function get_profile_data()
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('uid',$_SESSION['uid'])
                ->get()
                ->row();
  return $query;
}

public function current_password_check($cpassword)
  {
  return $this->db->select('*')
                ->from('users')
                ->where('password',$cpassword)
                ->get()
                ->row();
}

public function get_sales_data()
  {
  if($_SESSION['role'] > 2)
    {
    $query = $this->db->select('
                          sales.*,
                          customers.cus_id,
                          customers.customerName,
                          customers.mobile,
                          customers.email,
                          customers.address,
                          users.empid,
                          users.name,
                          users.mobile as umobile')
                  ->from('sales')
                  ->join('customers','customers.customerID = sales.customerID','left')
                  ->join('users','users.uid = sales.regby','left')
                  ->where('sales.compid',$_SESSION['compid'])
                  ->get()
                  ->result();
    }
  else
    {
    $query = $this->db->select('
                          sales.*,
                          customers.cus_id,
                          customers.customerName,
                          customers.mobile,
                          customers.email,
                          customers.address,
                          users.empid,
                          users.name,
                          users.mobile as umobile')
                  ->from('sales')
                  ->join('customers','customers.customerID = sales.customerID','left')
                  ->join('users','users.uid = sales.regby','left')
                  ->get()
                  ->result();
    }
  return $query;  
}

public function get_dsales_data($sdate,$edate,$customer,$employee,$compid)
  {
  if ($customer == 'All' && $employee == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All' && $employee == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.regby',$employee)
                    ->get()
                    ->result();
    }
  else if ($employee == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.customerID',$customer)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.regby',$employee)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($employee == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.customerID',$customer)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.customerID',$customer)
                    ->where('sales.regby',$employee)
                    ->get()
                    ->result();
    }
  else
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('sales.saleDate >=',$sdate)
                    ->where('sales.saleDate <=',$edate)
                    ->where('sales.customerID',$customer)
                    ->where('sales.regby',$employee)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  return $query;  
}

public function get_msales_data($month,$year,$customer,$employee,$compid)
  {
  if ($customer == 'All' && $employee == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All' && $employee == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.regby',$employee)
                    ->get()
                    ->result();
    }
  else if ($employee == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.regby',$employee)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($employee == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->where('sales.regby',$employee)
                    ->get()
                    ->result();
    }
  else
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('MONTH(sales.saleDate)',$month)
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->where('sales.regby',$employee)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  return $query;  
}

public function get_ysales_data($year,$customer,$employee,$compid)
  {
  if ($customer == 'All' && $employee == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All' && $employee == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.regby',$employee)
                    ->get()
                    ->result();
    }
  else if ($employee == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->get()
                    ->result();
    }
  else if ($customer == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.regby',$employee)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($employee == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  else if ($compid == 'All')
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->where('sales.regby',$employee)
                    ->get()
                    ->result();
    }
  else
    {
    $query = $this->db->select('
                            sales.*,
                            customers.cus_id,
                            customers.customerName,
                            customers.mobile,
                            customers.email,
                            customers.address,
                            users.empid,
                            users.name,
                            users.mobile as umobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->join('users','users.uid = sales.regby','left')
                    ->where('YEAR(sales.saleDate)',$year)
                    ->where('sales.customerID',$customer)
                    ->where('sales.regby',$employee)
                    ->where('sales.compid',$compid)
                    ->get()
                    ->result();
    }
  return $query;  
}

public function get_purchses_data()
  {
  if($_SESSION['role'] > 2)
    {
    $query = $this->db->select('
                          purchase.*,
                          suppliers.sup_id,
                          suppliers.supplierName')
                  ->from('purchase')
                  ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                  ->where('purchase.compid',$_SESSION['compid'])
                  ->get()
                  ->result();
    }
  else
    {
    $query = $this->db->select('
                          purchase.*,
                          suppliers.sup_id,
                          suppliers.supplierName')
                  ->from('purchase')
                  ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                  ->get()
                  ->result();
    }
  return $query;
}

public function get_dpurchses_data($sdate,$edate,$supid,$compid)
  {
  if($supid == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('purchase.purchaseDate >=',$sdate)
                ->where('purchase.purchaseDate <=',$edate)
                ->get()
                ->result();
      }
    else if($supid == 'All')
      {
      $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('purchase.purchaseDate >=',$sdate)
                ->where('purchase.purchaseDate <=',$edate)
                ->where('purchase.compid',$compid)
                ->get()
                ->result();
      }
    else if($compid == 'All')
      {
      $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('purchase.purchaseDate >=',$sdate)
                ->where('purchase.purchaseDate <=',$edate)
                ->where('purchase.supplier',$supid)
                ->get()
                ->result();
      }
    else
      {
      $query = $this->db->select('
                          purchase.*,
                          suppliers.sup_id,
                          suppliers.supplierName')
                  ->from('purchase')
                  ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                  ->where('purchase.purchaseDate >=',$sdate)
                  ->where('purchase.purchaseDate <=',$edate)
                  ->where('purchase.supplier',$supid)
                  ->where('purchase.compid',$compid)
                  ->get()
                  ->result();
      }
  return $query;  
}

public function get_mpurchses_data($month,$year,$supid,$compid)
  {
  if($supid == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('MONTH(purchaseDate)',$month)
                ->where('YEAR(purchaseDate)',$year)
                ->get()
                ->result();
      }
    else if($supid == 'All')
      {
      $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('MONTH(purchaseDate)',$month)
                ->where('YEAR(purchaseDate)',$year)
                ->where('purchase.compid',$compid)
                ->get()
                ->result();
      }
    else if($compid == 'All')
      {
      $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('MONTH(purchaseDate)',$month)
                ->where('YEAR(purchaseDate)',$year)
                ->where('purchase.supplier',$supid)
                ->get()
                ->result();
      }
    else
      {
      $query = $this->db->select('
                          purchase.*,
                          suppliers.sup_id,
                          suppliers.supplierName')
                  ->from('purchase')
                  ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                  ->where('MONTH(purchaseDate)',$month)
                  ->where('YEAR(purchaseDate)',$year)
                  ->where('purchase.supplier',$supid)
                  ->where('purchase.compid',$compid)
                  ->get()
                  ->result();
      }
      
  return $query;  
}

public function get_ypurchses_data($year,$supid,$compid)
  {
  if($supid == 'All' && $compid == 'All')
    {
    $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('YEAR(purchaseDate)',$year)
                ->get()
                ->result();
      }
    else if($supid == 'All')
      {
      $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('YEAR(purchaseDate)',$year)
                ->where('purchase.compid',$compid)
                ->get()
                ->result();
      }
    else if($compid == 'All')
      {
      $query = $this->db->select('
                        purchase.*,
                        suppliers.sup_id,
                        suppliers.supplierName')
                ->from('purchase')
                ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                ->where('YEAR(purchaseDate)',$year)
                ->where('purchase.supplier',$supid)
                ->get()
                ->result();
      }
    else
      {
      $query = $this->db->select('
                          purchase.*,
                          suppliers.sup_id,
                          suppliers.supplierName')
                  ->from('purchase')
                  ->join('suppliers','suppliers.supplierID = purchase.supplier','left')
                  ->where('YEAR(purchaseDate)',$year)
                  ->where('purchase.supplier',$supid)
                  ->where('purchase.compid',$compid)
                  ->get()
                  ->result();
      }
  return $query;  
}

public function total_sales_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_purchases_amount()
  {
  $query = $this->db->select("sale_product.quantity,products.pprice")
                  ->FROM('sale_product')
                  ->join('products','products.productID = sale_product.productID','left')
                  ->get()
                  ->result();
  return $query;  
}

// public function total_purchases_amount()
//   {
//   $query = $this->db->select("SUM(`paidAmount`) as total")
//                   ->FROM('purchase')
//                   ->where('compid',$_SESSION['compid'])
//                   ->get()
//                   ->row();
//   return $query;  
// }

public function total_emp_payments_amount()
  {
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_returns_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_cvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_dvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_svoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_dsales_amount($sdate,$edate)
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('sales.saleDate >=', $sdate)
                  ->where('sales.saleDate <=', $edate)
                  ->get()
                  ->row();
  return $query;  
}

public function total_dpurchases_amount($sdate,$edate)
  {
  $query = $this->db->select("sale_product.quantity,products.pprice")
                  ->FROM('sale_product')
                  ->join('products','products.productID = sale_product.productID','left')
                  ->where('DATE(sale_product.regdate) >=', $sdate)
                  ->where('DATE(sale_product.regdate) <=', $edate)
                  ->get()
                  ->result();
  return $query;  
}

// public function total_dpurchases_amount($sdate,$edate)
//   {
//   $query = $this->db->select("SUM(`paidAmount`) as total")
//                   ->FROM('purchase')
//                   ->WHERE('compid',$_SESSION['compid'])
//                   ->where('purchaseDate >=', $sdate)
//                   ->where('purchaseDate <=', $edate)
//                   ->get()
//                   ->row();
//   return $query;  
// }

public function total_demp_payments_amount($sdate,$edate)
  {
  $query = $this->db->select("SUM(salary) as total")
                  ->FROM('employee_payment')
                  //->WHERE('compid',$_SESSION['compid'])
                  ->where('DATE(regdate) >=', $sdate)
                  ->where('DATE(regdate) <=', $edate)
                  ->get()
                  ->row();
  return $query;  
}

public function total_dreturns_amount($sdate,$edate)
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('returnDate >=', $sdate)
                  ->where('returnDate <=', $edate)
                  ->get()
                  ->row();
  return $query;  
}

public function total_dcvoucher_amount($sdate,$edate)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('voucherdate >=', $sdate)
                  ->where('voucherdate <=', $edate)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_ddvoucher_amount($sdate,$edate)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('voucherdate >=', $sdate)
                  ->where('voucherdate <=', $edate)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_dsvoucher_amount($sdate,$edate)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('voucherdate >=', $sdate)
                  ->where('voucherdate <=', $edate)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_msales_amount($month,$year)
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('MONTH(sales.regdate)',$month)
                  ->where('YEAR(sales.regdate)',$year)
                  ->get()
                  ->row();
  return $query;  
}

public function total_mpurchases_amount($month,$year)
  {
  $query = $this->db->select("sale_product.quantity,products.pprice")
                  ->FROM('sale_product')
                  ->join('products','products.productID = sale_product.productID','left')
                  ->where('MONTH(sale_product.regdate)',$month)
                  ->where('YEAR(sale_product.regdate)',$year)
                  ->get()
                  ->result();
  return $query;  
}

public function total_memp_payments_amount($month,$year)
  {
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('MONTH(regdate)',$month)
                  ->where('YEAR(regdate)',$year)
                  ->get()
                  ->row();
  return $query;  
}

public function total_mreturns_amount($month,$year)
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('MONTH(returnDate)',$month)
                  ->where('YEAR(returnDate)',$year)
                  ->get()
                  ->row();
  return $query;  
}

public function total_mcvoucher_amount($month,$year)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('MONTH(voucherdate)',$month)
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_mdvoucher_amount($month,$year)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('MONTH(voucherdate)',$month)
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_msvoucher_amount($month,$year)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('MONTH(voucherdate)',$month)
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_ysales_amount($year)
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('YEAR(sales.regdate)',$year)
                  ->get()
                  ->row();
  return $query;  
}

public function total_ypurchases_amount($year)
  {
  $query = $this->db->select("sale_product.quantity,products.pprice")
                  ->FROM('sale_product')
                  ->join('products','products.productID = sale_product.productID','left')
                  ->where('YEAR(sale_product.regdate)',$year)
                  ->get()
                  ->result();
  return $query;  
}

public function total_yemp_payments_amount($year)
  {
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('YEAR(regdate)',$year)
                  ->get()
                  ->row();
  return $query;  
}

public function total_yreturns_amount($year)
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->where('YEAR(returnDate)',$year)
                  ->get()
                  ->row();
  return $query;  
}

public function total_ycvoucher_amount($year)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_ydvoucher_amount($year)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function total_ysvoucher_amount($year)
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->WHERE('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function check_email($empemail)
  {
  return $this->db->select('*')
                    ->from('users')
                    ->where('email',$empemail)
                    ->get()
                    ->row();
}

public function check_mobile_number($mid)
  {
  return $this->db->select('*')
                    ->from('users')
                    ->where('mobile',$mid)
                    ->get()
                    ->row();
}

public function sales_cust_ledger_data($customer)
  {
  $query = $this->db->select("sales.*, sales_payment_details.paidamount, sales_payment_details.regdate as pdate,sales_payment.rec_code")
                  ->FROM('sales')
                  ->join('sales_payment_details', 'sales_payment_details.saleID = sales.saleID', 'left')
                //   ->join('sales_payment', 'sales_payment.sp_id = sales.saleID', 'left' )
                 ->join('sales_payment', 'sales_payment.sp_id = sales_payment_details.sp_id', 'left')
                //   ->join('sales_payment', 'sales_payment.customerID = sales.customerID', 'left')
                  ->WHERE('sales.customerID',$customer)
                //   ->group_by('sales.saleID')
                  ->get()
                  ->result();
//   $query = $this->db->select("sales.*")
//                   ->FROM('sales')
//                   ->WHERE('sales.customerID',$customer)
//                   ->get()
//                   ->result();
  return $query;  
}

public function voucher_cust_ledger_data($customer)
  {
  $query = $this->db->select("*")
                  ->FROM('vaucher')
                  ->WHERE('customerID',$customer)
                  ->where('status',1)
                  ->get()
                  ->result();
  return $query;  
}

public function return_cust_ledger_data($customer)
  {
  $query = $this->db->select("*")
                  ->FROM('returns')
                  ->WHERE('customerID',$customer)
                  ->get()
                  ->result();
  return $query;  
}

public function sales_dcust_ledger_data($customer,$sdate,$edate)
  {
  $query = $this->db->select("sales.*, sales_payment_details.paidamount, sales_payment_details.regdate as pdate,sales_payment.rec_code")
                  ->FROM('sales')
                  ->join('sales_payment_details', 'sales_payment_details.saleID = sales.saleID', 'left')
                //   ->join('sales_payment', 'sales_payment.customerID = sales.customerID', 'left')
                  ->join('sales_payment', 'sales_payment.sp_id = sales_payment_details.sp_id', 'left')
                  ->WHERE('sales.customerID',$customer)
                  ->where('sales.saleDate >=', $sdate)
                  ->where('sales.saleDate <=', $edate)
                  ->get()
                  ->result();
                  //var_dump($query); exit();
  return $query;  
}

public function voucher_dcust_ledger_data($customer,$sdate,$edate)
  {
  $query = $this->db->select("voucherdate,vauchertype,invoice,totalamount")
                  ->FROM('vaucher')
                  ->WHERE('customerID',$customer)
                  ->where('voucherdate >=', $sdate)
                  ->where('voucherdate <=', $edate)
                  ->where('status',1)
                  ->get()
                  ->result();
                  //var_dump($query); exit();
  return $query;  
}

public function return_dcust_ledger_data($customer,$sdate,$edate)
  {
  $query = $this->db->select("returnDate,rid,totalPrice,scAmount,paidAmount")
                  ->FROM('returns')
                  ->WHERE('customerID',$customer)
                  ->where('returnDate >=', $sdate)
                  ->where('returnDate <=', $edate)
                  ->get()
                  ->result();
                  //var_dump($query); exit();
  return $query;  
}

public function sales_mcust_ledger_data($customer,$month,$year)
  {
  $query = $this->db->select("sales.*, sales_payment_details.paidamount, sales_payment_details.regdate as pdate,sales_payment.rec_code")
                  ->FROM('sales')
                  ->join('sales_payment_details', 'sales_payment_details.saleID = sales.saleID', 'left')
                //   ->join('sales_payment', 'sales_payment.customerID = sales.customerID', 'left')
                  ->join('sales_payment', 'sales_payment.sp_id = sales_payment_details.sp_id', 'left')
                  ->WHERE('sales.customerID',$customer)
                  ->where('MONTH(sales.saleDate)',$month)
                  ->where('YEAR(sales.saleDate)',$year)
                  ->get()
                  ->result();
  return $query;  
}

public function voucher_mcust_ledger_data($customer,$month,$year)
  {
  $query = $this->db->select("voucherdate,vauchertype,invoice,totalamount")
                  ->FROM('vaucher')
                  ->WHERE('customerID',$customer)
                  ->where('MONTH(voucherdate)',$month)
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->result();
  return $query;  
}

public function return_mcust_ledger_data($customer,$month,$year)
  {
  $query = $this->db->select("returnDate,rid,totalPrice,scAmount,paidAmount")
                  ->FROM('returns')
                  ->WHERE('customerID',$customer)
                  ->where('MONTH(returnDate)',$month)
                  ->where('YEAR(returnDate)',$year)
                  ->get()
                  ->result();
  return $query;  
}

public function sales_ycust_ledger_data($customer,$year)
  {
  $query = $this->db->select("sales.*, sales_payment_details.paidamount, sales_payment_details.regdate as pdate,sales_payment.rec_code")
                  ->FROM('sales')
                  ->join('sales_payment_details', 'sales_payment_details.saleID = sales.saleID', 'left')
                //   ->join('sales_payment', 'sales_payment.customerID = sales.customerID', 'left')
                  ->join('sales_payment', 'sales_payment.sp_id = sales_payment_details.sp_id', 'left')
                  ->WHERE('sales.customerID',$customer)
                  ->where('YEAR(sales.saleDate)',$year)
                  ->get()
                  ->result();
  return $query;  
}

public function voucher_ycust_ledger_data($customer,$year)
  {
  $query = $this->db->select("voucherdate,vauchertype,invoice,totalamount")
                  ->FROM('vaucher')
                  ->WHERE('customerID',$customer)
                  ->where('YEAR(voucherdate)',$year)
                  ->where('status',1)
                  ->get()
                  ->result();
  return $query;  
}

public function return_ycust_ledger_data($customer,$year)
  {
  $query = $this->db->select("returnDate,rid,totalPrice,scAmount,paidAmount")
                  ->FROM('returns')
                  ->WHERE('customerID',$customer)
                  ->where('YEAR(returnDate)',$year)
                  ->get()
                  ->result();
  return $query;  
}


public function get_cvoucher_data()
  {
  if($_SESSION['role'] > 2)
    {
    $query = $this->db->select("vaucher.*, SUM(vaucher.totalamount) as tamount")
                  ->from('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->where('vauchertype', 'Credit Voucher')
                  ->where('status',1)
                  ->group_by('customerID')
                  ->get()
                  ->result();
    }
  else
    {
    $query = $this->db->select("vaucher.*, SUM(vaucher.totalamount) as tamount")
                  ->from('vaucher')
                  ->where('vauchertype', 'Credit Voucher')
                  ->where('status',1)
                  ->group_by('customerID')
                  ->get()
                  ->result();
    }
  return $query;  
}

public function get_dvoucher_data()
  {
  if($_SESSION['role'] > 2)
    {
    $query = $this->db->select("*")
                  ->from('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->where('vauchertype', 'Debit Voucher')
                  ->where('status',1)
                  ->get()
                  ->result();
    }
  else
    {
    $query = $this->db->select("*")
                  ->from('vaucher')
                  ->where('vauchertype', 'Debit Voucher')
                  ->where('status',1)
                  ->get()
                  ->result();
    }
  return $query;  
}

public function get_svoucher_data()
  {
  if($_SESSION['role'] > 2)
    {
    $query = $this->db->select("*")
                  ->from('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->where('vauchertype', 'Supplier Pay')
                  ->where('status',1)
                  ->get()
                  ->result();
    }
  else
    {
    $query = $this->db->select("*")
                  ->from('vaucher')
                  ->where('vauchertype', 'Supplier Pay')
                  ->where('status',1)
                  ->get()
                  ->result();
    }
  return $query;  
}

public function get_dall_voucher_data($sdate,$edate,$vtype,$compid)
  {
  if($vtype == 'All' && $compid = 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('voucherdate >=', $sdate)
                    ->where('voucherdate <=', $edate)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else if($vtype == 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('voucherdate >=', $sdate)
                    ->where('voucherdate <=', $edate)
                    ->where('compid',$compid)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else if($compid == 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('voucherdate >=', $sdate)
                    ->where('voucherdate <=', $edate)
                    ->where('vauchertype',$vtype)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('voucherdate >=', $sdate)
                    ->where('voucherdate <=', $edate)
                    ->where('vauchertype',$vtype)
                    ->where('compid',$compid)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  return $query;  
}

public function get_mall_voucher_data($month,$year,$vtype,$compid)
  {
  if($vtype == 'All' && $compid = 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('MONTH(voucherdate)',$month)
                    ->where('YEAR(voucherdate)',$year)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else if($vtype == 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('MONTH(voucherdate)',$month)
                    ->where('YEAR(voucherdate)',$year)
                    ->where('compid',$compid)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else if($compid == 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('MONTH(voucherdate)',$month)
                    ->where('YEAR(voucherdate)',$year)
                    ->where('vauchertype',$vtype)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('MONTH(voucherdate)',$month)
                    ->where('YEAR(voucherdate)',$year)
                    ->where('vauchertype',$vtype)
                    ->where('compid',$compid)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  return $query;  
}

public function get_yall_voucher_data($year,$vtype,$compid)
  {
  if($vtype == 'All' && $compid = 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('YEAR(voucherdate)',$year)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else if($vtype == 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('YEAR(voucherdate)',$year)
                    ->where('compid',$compid)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else if($compid == 'All')
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('YEAR(voucherdate)',$year)
                    ->where('vauchertype',$vtype)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  else
    {
    $query = $this->db->select("*")
                    ->from('vaucher')
                    ->where('YEAR(voucherdate)',$year)
                    ->where('vauchertype',$vtype)
                    ->where('compid',$compid)
                    ->where('status',1)
                    ->get()
                    ->result();
    }
  return $query;  
}

public function today_sales_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(paidAmount) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('saleDate',$date)
                  ->get()
                  ->row();
                  //var_dump($query); exit();
  return $query;  
}
public function today_received_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(amount) as total")
                  ->FROM('sales_payment')
                  ->where('recDate',$date)
                  ->get()
                  ->row();
                  //var_dump($query); exit();
  return $query;  
}
public function today_order_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(totalAmount) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('saleDate',$date)
                  ->get()
                  ->row();
                  //var_dump($query); exit();
  return $query;  
}

public function today_purchases_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("sale_product.quantity,products.pprice")
                  ->FROM('sale_product')
                  ->join('products','products.productID = sale_product.productID','left')
                  ->where('DATE(sale_product.regdate)',$date)
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->result();
  return $query;  
}

public function today_purchases_sum_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(paidAmount) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->where('purchaseDate',$date)
                  ->get()
                  ->row();
  return $query;  
}
public function today_payment_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(amount) as total")
                  ->FROM('purchase_payment')
                  ->where('payDate',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_emp_payments_amount()
  {
  $d = date('d');
  $m = date('m');
  $y = date('Y');
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  ->where('DAY(regdate)',$d)
                  ->where('MONTH(regdate)',$m)
                  ->where('YEAR(regdate)',$y)
                  ->get()
                  ->row();
  return $query;  
}

public function today_returns_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$_SESSION['compid'])
                  ->where('returnDate',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_due_payment()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`amount`) as total")
                  ->FROM('sales_payment')
                  ->where('DATE(regdate)',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_bank_withdraw()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`amount`) as total")
                  ->FROM('transfer_account')
                  ->where('facType','Bank')
                  ->where('DATE(regdate)',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_bank_transfer()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`amount`) as total")
                  ->FROM('transfer_account')
                  ->where('sacType','Bank')
                  ->where('DATE(regdate)',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_cvoucher_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('voucherdate',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function today_dvoucher_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('voucherdate',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function today_svoucher_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('voucherdate',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function today_empslry_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  //->WHERE('vauchertype','Supplier Pay')
                  ->where('DATE(regdate)',$date)
                  ->get()
                  ->row();
    //var_dump($query); exit();
  return $query;  
}

public function today_product_sales_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(sale_product.totalPrice) as ta,SUM(sale_product.quantity) as tq,sale_product.productID,sale_product.quantity,sales.saleDate")
                  ->FROM('sale_product')
                  ->join('sales','sales.saleID = sale_product.saleID','left')
                  ->where('sales.saleDate',$date)
                  ->where('compid',$_SESSION['compid'])
                  ->group_by('sale_product.productID')
                  ->get()
                  ->result();
  return $query;  
}

public function pre_sales_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('saleDate <',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function pre_purchases_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->where('purchaseDate <',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function pre_emp_payments_amount()
  {
  $d = date('d');
  $m = date('m');
  $y = date('Y');
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  ->where('DAY(regdate) <',$d)
                  ->where('MONTH(regdate) <=',$m)
                  ->where('YEAR(regdate) <=',$y)
                  ->get()
                  ->row();
  return $query;  
}

public function pre_returns_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$_SESSION['compid'])
                  ->where('returnDate <',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function pre_cvoucher_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('voucherdate <',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function pre_dvoucher_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('voucherdate <',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function pre_svoucher_amount()
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('voucherdate <',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function get_dspurchase_data($sdate,$edate,$sid)
  {
  $query = $this->db->select('*')
                  ->from('purchase')
                  ->where('purchaseDate >=', $sdate)
                  ->where('purchaseDate <=', $edate)
                  ->where('supplier',$sid)
                  ->get()
                  ->result();

  return $query;  
}

public function get_dsvoucher_data($sdate,$edate,$sid)
  {
  $query = $this->db->select('*')
                  ->from('vaucher')
                  ->where('voucherdate >=', $sdate)
                  ->where('voucherdate <=', $edate)
                  ->where('supplier',$sid)
                  ->where('status',1)
                  ->get()
                  ->result();

  return $query;  
}

public function get_dpurchase_return_data($sdate,$edate,$sid)
  {
  $query = $this->db->select('*')
                  ->from('preturns')
                  ->where('prDate >=', $sdate)
                  ->where('prDate <=', $edate)
                  ->where('customerID',$sid)
                  ->get()
                  ->result();

  return $query;  
}

public function get_mspurchase_data($month,$year,$sid)
  {
  $query = $this->db->select('*')
                  ->from('purchase')
                  ->where('MONTH(purchaseDate)',$month)
                  ->where('YEAR(purchaseDate)',$year)
                  ->where('supplier',$sid)
                  ->get()
                  ->result();

  return $query;  
}

public function get_msvoucher_data($month,$year,$sid)
  {
  $query = $this->db->select('*')
              ->from('vaucher')
              ->where('MONTH(voucherdate)',$month)
              ->where('YEAR(voucherdate)',$year)
              ->where('supplier',$sid)
              ->where('status',1)
              ->get()
              ->result();

  return $query;  
}

public function get_mpurchase_return_data($month,$year,$sid)
  {
  $query = $this->db->select('*')
                  ->from('preturns')
                  ->where('MONTH(prDate)',$month)
                  ->where('YEAR(prDate)',$year)
                  ->where('customerID',$sid)
                  ->get()
                  ->result();

  return $query;  
}


public function get_yspurchase_data($year,$sid)
  {
  $query = $this->db->select('*')
              ->from('purchase')
              ->where('YEAR(purchaseDate)',$year)
              ->where('supplier',$sid)
              ->get()
              ->result();

  return $query;  
}

public function get_ysvoucher_data($year,$sid)
  {
  $query = $this->db->select('*')
              ->from('vaucher')
              ->where('YEAR(voucherdate)',$year)
              ->where('supplier',$sid)
              ->where('status',1)
              ->get()
              ->result();

  return $query;  
}

public function get_ypurchase_return_data($year,$sid)
  {
  $query = $this->db->select('*')
                  ->from('preturns')
                  ->where('YEAR(prDate)',$year)
                  ->where('customerID',$sid)
                  ->get()
                  ->result();

  return $query;  
}

public function total_category()
  {
  $query = $this->db->select('*')
                ->from('categories')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_unit()
  {
  $query = $this->db->select('*')
                ->from('sma_units')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}



public function total_expense_type()
  {
  $query = $this->db->select('*')
                ->from('cost_type')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_depertment()
  {
  $query = $this->db->select('*')
                ->from('department')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_bank_account()
  {
  $query = $this->db->select('*')
                ->from('bankaccount')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_mobile_account()
  {
  $query = $this->db->select('*')
                ->from('mobileaccount')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_notice()
  {
  $query = $this->db->select('*')
                ->from('notice')
                ->or_where('ntype','All')
                ->or_where('ntype',$_SESSION['uid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_user_type()
  {
  $query = $this->db->select('*')
                ->from('access_lavels')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_balance_transfer()
  {
  $query = $this->db->select('SUM(amount) as total')
                ->from('transfer_account')
                ->get()
                ->row();

  return $query;
}

public function product_fetch_data($compid)
  {
  $this->db->order_by("productID","DESC");
  $this->db->where('compid', $compid);
  $query = $this->db->get("products");
  
  return $query->result();
}

public function insert_product_data($data)
  {
  $this->db->insert_batch('products',$data);
}

public function get_purchase_payment($id)
  {
  $query = $this->db->select('paidAmount,due')
              ->from('purchase')
              ->where('purchaseID',$id)
              ->get()
              ->row();
  return $query; 
}

public function get_sales_payment($id)
  {
  $query = $this->db->select('paidAmount,dueamount')
              ->from('sales')
              ->where('saleID',$id)
              ->get()
              ->row();
  return $query; 
}
public function get_receipt_details($id)
  {
  $query = $this->db->select('sales_payment_details.*, sales.invoice_no')
              ->from('sales_payment_details')
              ->join('sales', 'sales.saleID = sales_payment_details.saleID', 'left')
              ->where('sales_payment_details.sp_id',$id)
              ->get()
              ->result();
  return $query; 
}
public function get_payment_details($id)
  {
  $query = $this->db->select('purchase_payment_details.*, purchase.challanNo')
              ->from('purchase_payment_details')
              ->join('purchase', 'purchase.purchaseID = purchase_payment_details.pur_id', 'left')
              ->where('purchase_payment_details.pp_id',$id)
              ->get()
              ->result();
  return $query; 
}

public function total_customer()
  {
  $query = $this->db->select('*')
                ->from('customers')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_supplier()
  {
  $query = $this->db->select('*')
                ->from('suppliers')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_product()
  {
  $query = $this->db->select('*')
                ->from('products')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_employee()
  {
  $query = $this->db->select('*')
                ->from('employees')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_user()
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('compid',$_SESSION['compid'])
                ->get();

  $count_row = $query->num_rows();

  return $count_row;
}

public function total_sale()
  {
  $query = $this->db->select("SUM(`totalAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_sale_month()
  {
   $month = date('m');
  $query = $this->db->select("SUM(`totalAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('MONTH(saleDate)', $month)
                  ->get()
                  ->row();
  return $query;  
}
public function total_purchase_month()
  {
   $month = date('m');
  $query = $this->db->select("SUM(`totalPrice`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->where('MONTH(purchaseDate)', $month)
                  ->get()
                  ->row();
  return $query;  
}

public function total_purchase()
  {
  $query = $this->db->select("SUM(`totalPrice`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}
public function total_receivable()
  {
  $query = $this->db->select("SUM(`dueamount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_payable()
  {
  $query = $this->db->select("SUM(`due`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_cash_in_hand()
  {
  $query = $this->db->select("SUM(`balance`) as total")
                  ->FROM('cash')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();
  return $query;  
}

public function total_stock()
  {
  $query = $this->db->select('SUM(`totalPices`) as total')
                ->from('stock')
                ->where('compid',$_SESSION['compid'])
                ->get()
                ->row();
  return $query;
}

public function total_voucher()
    {
    $query = $this->db->select("SUM(`totalamount`) as total")
                    ->FROM('vaucher')
                    ->where('compid',$_SESSION['compid'])
                    ->where('status',1)
                    ->get()
                    ->row();
    return $query;  
}

public function get_stock_data($id)
  {
  $query = $this->db->select('totalPices')
                ->from('stock')
                ->where('product',$id)
                ->where('compid',$_SESSION['compid'])
                ->get()
                ->row();
  return $query;
}

public function customer_fetch_data($compid)
  {
  $this->db->where('compid',$compid);
  $query = $this->db->get("customers");
  return $query->result();
}

public function insert_customer_data($data)
  {
  $this->db->insert_batch('customers',$data);
}

public function supplier_fetch_data($compid)
  {
  $this->db->order_by("supplierID","DESC");
  $this->db->where('compid',$compid);
  $query = $this->db->get("suppliers");
  return $query->result();
}

public function insert_supplier_data($data)
  {
  $this->db->insert_batch('suppliers',$data);
}

public function count_all_user()
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('userrole',2)
                ->get();

  $count_row = $query->num_rows();
  return $count_row;
}

public function count_all_active_user()
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('userrole',2)
                ->where('status','Active')
                ->get();

  $count_row = $query->num_rows();
  return $count_row;
}

public function count_all_inactive_user()
  {
  $query = $this->db->select('*')
                ->from('users')
                ->where('userrole',2)
                ->where('status','Inactive')
                ->get();

  $count_row = $query->num_rows();
  return $count_row;
}

public function count_all_today_user()
  {
  $d = date('d'); $m = date('m'); $y = date('Y');

  $query = $this->db->select('*')
                ->from('users')
                ->where('userrole',2)
                ->where('DAY(regdate)',$d)
                ->where('MONTH(regdate)',$m)
                ->where('YEAR(regdate)',$y)
                ->get();

  $count_row = $query->num_rows();
  return $count_row;
}

public function count_all_month_user()
  {
  $m = date('m'); $y = date('Y');

  $query = $this->db->select('*')
                ->from('users')
                ->where('userrole',2)
                ->where('MONTH(regdate)',$m)
                ->where('YEAR(regdate)',$y)
                ->get();

  $count_row = $query->num_rows();
  return $count_row;
}
public function get_categories() {
        return $this->db->select('categoryID, categoryName')
                        ->from('categories')
                        ->get()
                        ->result_array();
    }

    public function get_products() {
        return $this->db->select('productID, productName')
                        ->from('products')
                        ->get()
                        ->result_array();
    }

    public function get_product_sales_data($filters = array()) {
        // Base query for sales and sale products
        $this->db->select('
            sale_product.saleID,
            sale_product.productID,
            sale_product.quantity as soldQuantity,
            sale_product.sprice as sellingPrice,
            (sale_product.quantity * sale_product.sprice) as total,
            sales.invoice_no as invoiceNo,
            sales.regdate as invoiceDate,
            customer.customerName,
            products.productName
        ');
        $this->db->from('sale_product');
        $this->db->join('sales', 'sales.saleID = sale_product.saleID', 'left');
        $this->db->join('customer', 'customer.customerID = sales.customerID', 'left');
        $this->db->join('products', 'products.productID = sale_product.productID', 'left');

        // Apply filters
        if (!empty($filters['start_date']) && !empty($filters['end_date'])) {
            $this->db->where('sales.regdate >=', $filters['start_date']);
            $this->db->where('sales.regdate <=', $filters['end_date']);
        }

        if (!empty($filters['month']) && !empty($filters['year'])) {
            $this->db->where('MONTH(sales.regdate)', $filters['month']);
            $this->db->where('YEAR(sales.regdate)', $filters['year']);
        }

        if (!empty($filters['year']) && empty($filters['month'])) {
            $this->db->where('YEAR(sales.regdate)', $filters['year']);
        }

        if (!empty($filters['categoryID'])) {
            $this->db->where('products.categoryID', $filters['categoryID']);
        }

        if (!empty($filters['productID'])) {
            $this->db->where('sale_product.productID', $filters['productID']);
        }

        // Execute query and return results
        $query = $this->db->get();
        return $query->result();
    }
public function graph_data_point()
  {
  $date_arr = $this->getLastNDays(30, 'Y-m-d');
  $dataPoints = array();

  for($i = 0; $i < 30; $i++)
    {
    array_push($dataPoints, array("y" => $this->get_today_sale(preg_replace('/[^A-Za-z0-9\-]/','',$date_arr[$i])),"label" => preg_replace('/[^A-Za-z0-9\-]/','',$date_arr[$i])));
    }

    return $dataPoints;
}

public function get_today_sale($date)
  {
  $query = $this->db->select("SUM(`totalAmount`) as total")
                  ->FROM('sales')
                  ->where('saleDate',$date)
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->row();

  if($query->total)
    {
    return $query->total;
    }
  else
    {
    $dt = 0;
    return $dt;
    }
}

public function getLastNDays($days, $format = 'd-m')
  {
  $m = date("m"); $de= date("d"); $y= date("Y");
  $dateArray = array();
  for($i=0; $i<=$days-1; $i++)
    {
    $dateArray[] = '"'.date($format, mktime(0,0,0,$m,($de-$i),$y)).'"'; 
    }
  return array_reverse($dateArray);
}

// public function get_sales_data2($period)
//  {
//     $this->db->select('DATE_FORMAT(saleDate, "%d") AS day, SUM(totalAmount) AS total_sales');
//     $this->db->group_by('day');

//     switch ($period) {
//       case '7days':
//         $this->db->where('saleDate >=', date('Y-m-d', strtotime('-7 days')));
//         break;
//       case '30days':
//         $this->db->where('saleDate >=', date('Y-m-d', strtotime('-30 days')));
//         break;
//       case '12months':
//         $this->db->where('YEAR(saleDate)', date('Y'));
//         $this->db->group_by('MONTH(saleDate)');
//         break;
//     }

//     $query = $this->db->get('sales');
//     return $query->result_array();
//   }

public function get_page_and_function()
  {
  $query = $this->db->select('
              tbl_page_functions.pfunc_id,
              tbl_page_functions.pageid,
              tbl_page_functions.fcname,
              tbl_pages.pageid,
              tbl_pages.master_page,
              tbl_pages.cname,
              tbl_master_page_title.master_id,
              tbl_master_page_title.c_master_title')
            ->from('tbl_pages')
            ->join('tbl_master_page_title','tbl_master_page_title.master_id = tbl_pages.master_page','left')
            ->join('tbl_page_functions','tbl_page_functions.pageid = tbl_pages.pageid','left')
            ->get()
            ->result();
  return $query;
}

public function saveNewMaster_data($data)
  {
  $column = $data['master_title'] ;
  $table = 'tbl_user_m_permission';

  $fields = array(
    'preferences' => array('type' => 'INT','constraint' => 5 )
      );

  $fields2 = array(
    'preferences' => array(
      'name' => $column ,
      'type' => 'INT',
      'constraint' => 5
        ),
      );
    // $add = mysql_query("ALTER TABLE $table ADD $column INT( 1 ) NOT NULL");
  $this->load->dbforge();
  $this->dbforge->add_column('tbl_user_m_permission',$fields);

  $this->load->dbforge();
  $add = $this->dbforge->modify_column('tbl_user_m_permission',$fields2);
  // var_dump($add); exit();
  return $this->db->insert('tbl_master_page_title', $data); 
}

public function saveNewPage_data($data)
  {
  $column = $data['pagename'] ;
  $table = 'tbl_user_p_permission';

  $fields = array(
    'preferences' => array('type' => 'INT','constraint' => 5 )
      );

  $fields2 = array(
    'preferences' => array(
      'name' => $column,
      'type' => 'INT',
      'constraint' => 5
        ),
      );
    // $add = mysql_query("ALTER TABLE $table ADD $column INT( 1 ) NOT NULL");
  $this->load->dbforge();
  $this->dbforge->add_column('tbl_user_p_permission',$fields);

  $this->load->dbforge();
  $add = $this->dbforge->modify_column('tbl_user_p_permission',$fields2);
    // var_dump($add); exit();
  return $this->db->insert('tbl_pages', $data); 
}

public function saveNewPageFunction_data($data)
  {
  $column = $data['pfunc_name'] ;
  $table = 'tbl_user_f_permission';

  $fields = array(
    'preferences' => array('type' => 'INT','constraint' => 5 )
      );

  $fields2 = array(
    'preferences' => array(
      'name' => $column,
      'type' => 'INT',
      'constraint' => 5
        ),
      );
    // $add = mysql_query("ALTER TABLE $table ADD $column INT( 1 ) NOT NULL");
  $this->load->dbforge();
  $this->dbforge->add_column('tbl_user_f_permission',$fields);

  $this->load->dbforge();
  $add = $this->dbforge->modify_column('tbl_user_f_permission', $fields2);
    // var_dump($add); exit();
  return $this->db->insert('tbl_page_functions',$data); 
}

public function get_page_data_by_master($id)
  {
  $query = $this->db->select('*')
            ->from('tbl_pages')
            ->where('master_page',$id)
            ->get()
            ->result();
  return $query;
}

public function get_user_permission_data()
  {
  $emp = $this->db->select('compid')
                ->from('tbl_user_m_permission')
                ->get()
                ->result_array();
  //var_dump($emp); exit();
  $emp_id = array_map (function($value){
    return $value['compid'];
    },$emp);

  if ($emp_id == null) {
    $emp_id = 0;
    }

  $emps = $this->db->select('compid,name,compname')
                ->from('users')
                ->where_not_in('compid',$emp_id)
                ->where('userrole',2)
                ->get()
                ->result();
  return $emps;
}

public function total_sales_product()
  {
  $query = $this->db->select("
                        SUM(sale_product.quantity) as tq,
                        SUM(sale_product.totalPrice) as ta,
                        sale_product.productID,
                        sales.compid,
                        sale_product.saleID,
                        sales.saleDate")
                    ->from('sale_product')
                    ->join('sales','sales.saleID = sale_product.saleID','left')
                    ->group_by('productID')
                    ->where('compid',$_SESSION['compid'])
                    ->get()
                    ->result();
  return $query;
}

public function total_dsales_product($sdate,$edate)
  {
  $query = $this->db->select("
                        SUM(sale_product.quantity) as tq,
                        SUM(sale_product.totalPrice) as ta,
                        sale_product.productID,
                        sales.compid,
                        sales.saleDate,sales.saleID")
                    ->from('sale_product')
                    ->join('sales','sales.saleID = sale_product.saleID','left')
                    ->where('compid',$_SESSION['compid'])
                    ->where('saleDate >=', $sdate)
                    ->where('saleDate <=', $edate)
                    ->group_by('productID')
                    ->get()
                    ->result();
  return $query;
}

public function total_msales_product($month,$year)
  {
  $query = $this->db->select("
                        SUM(sale_product.quantity) as tq,
                        SUM(sale_product.totalPrice) as ta,
                        sale_product.productID,
                        sales.compid,
                        sales.saleDate")
                    ->from('sale_product')
                    ->join('sales','sales.saleID = sale_product.saleID','left')
                    ->group_by('productID')
                    ->where('compid',$_SESSION['compid'])
                    ->where('MONTH(saleDate)',$month)
                    ->where('YEAR(saleDate)',$year)
                    ->get()
                    ->result();
  return $query;
}

public function total_ysales_product($year)
  {
  $query = $this->db->select("
                        SUM(sale_product.quantity) as tq,
                        SUM(sale_product.totalPrice) as ta,
                        sale_product.productID,
                        sales.compid,
                        sales.saleDate")
                    ->from('sale_product')
                    ->join('sales','sales.saleID = sale_product.saleID','left')
                    ->group_by('productID')
                    ->where('compid',$_SESSION['compid'])
                    ->where('YEAR(saleDate)',$year)
                    ->get()
                    ->result();
  return $query;
}

public function get_help_reply_data($id)
  {
  $query = $this->db->select("help_support_reply.reply,users.name")
                    ->from('help_support_reply')
                    ->join('users','users.uid = help_support_reply.regby','left')
                    ->where('hp_id',$id)
                    ->get()
                    ->result();
  return $query;
}

public function get_user_notice_data($id)
  {
  $query = $this->db->select('*')
                  ->from('notice')
                  ->where('nid',$id)
                  ->get()
                  ->row();
  return $query; 
}



public function today_sales($cid)
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalAmount`) as total,SUM(`paidAmount`) as ptotal")
                  ->FROM('sales')
                  ->where('compid',$cid)
                  ->where('saleDate',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_purchases($cid)
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalPrice`) as total,SUM(`paidAmount`) as ptotal")
                  ->FROM('purchase')
                  ->where('compid',$cid)
                  ->where('purchaseDate',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_emp_payments($cid)
  {
  $d = date('d');
  $m = date('m');
  $y = date('Y');
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$cid)
                  ->where('DAY(regdate)',$d)
                  ->where('MONTH(regdate)',$m)
                  ->where('YEAR(regdate)',$y)
                  ->get()
                  ->row();
  return $query;  
}

public function today_returns($cid)
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$cid)
                  ->where('returnDate',$date)
                  ->get()
                  ->row();
  return $query;  
}

public function today_cvouchers($cid)
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$cid)
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('voucherdate',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function today_dvouchers($cid)
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$cid)
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('voucherdate',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function today_svouchers($cid)
  {
  $date = date('Y-m-d');
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$cid)
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('voucherdate',$date)
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

// public function get_mall_emp_payments_data($month,$year)
//     {
//     $query = $this->db->select('*')
//                     ->from('employee_payment')
//                     ->where('compid',$_SESSION['compid'])
//                     ->where('MONTH(regdate)',$month)
//                     ->where('YEAR(regdate)',$year)
//                     ->get()
//                     ->result();
//     return $query; 
// }

// public function get_mall_returns_data($month,$year)
//     {
//     $query = $this->db->select('*')
//                     ->from('returns')
//                     ->where('compid',$_SESSION['compid'])
//                     ->where('MONTH(returnDate)',$month)
//                     ->where('YEAR(returnDate)',$year)
//                     ->get()
//                     ->result();
//     return $query; 
// }

// public function get_mall_vouchers_data($month,$year)
//     {
//     $query = $this->db->select('*')
//                     ->from('vaucher')
//                     ->where('compid',$_SESSION['compid'])
//                     ->where('MONTH(voucherdate)',$month)
//                     ->where('YEAR(voucherdate)',$year)
//                     ->get()
//                     ->result();
//     return $query; 
// }


// public function get_yall_emp_payments_data($year)
//     {
//     $query = $this->db->select('*')
//                     ->from('employee_payment')
//                     //->where('company',$_SESSION['company'])
//                     ->where('YEAR(regdate)',$year)
//                     ->get()
//                     ->result();
//     return $query; 
// }


public function cash_sales_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Cash')
                  ->get()
                  ->row();
  return $query;  
}

public function cash_purchases_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Cash')
                  ->get()
                  ->row();
  return $query;  
}

public function cash_cvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('accountType','Cash')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function cash_dvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('accountType','Cash')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function cash_svoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('accountType','Cash')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function cash_emp_payments_amount()
  {
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Cash')
                  ->get()
                  ->row();
  return $query;  
}

public function cash_returns_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Cash')
                  ->get()
                  ->row();
  return $query;  
}

public function bank_sales_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Bank')
                  ->get()
                  ->row();
  return $query;  
}

public function bank_purchases_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Bank')
                  ->get()
                  ->row();
  return $query;  
}

public function bank_cvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('accountType','Bank')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function bank_dvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('accountType','Bank')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function bank_svoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('accountType','Bank')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function bank_emp_payments_amount()
  {
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Bank')
                  ->get()
                  ->row();
  return $query;  
}

public function bank_returns_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Bank')
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_sales_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Mobile')
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_purchases_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('purchase')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Mobile')
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_cvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Credit Voucher')
                  ->where('accountType','Mobile')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_dvoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Debit Voucher')
                  ->where('accountType','Mobile')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_svoucher_amount()
  {
  $query = $this->db->select("SUM(`totalamount`) as total")
                  ->FROM('vaucher')
                  ->where('compid',$_SESSION['compid'])
                  ->WHERE('vauchertype','Supplier Pay')
                  ->where('accountType','Mobile')
                  ->where('status',1)
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_emp_payments_amount()
  {
  $query = $this->db->select("SUM(`salary`) as total")
                  ->FROM('employee_payment')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Mobile')
                  ->get()
                  ->row();
  return $query;  
}

public function mobile_returns_amount()
  {
  $query = $this->db->select("SUM(`paidAmount`) as total")
                  ->FROM('returns')
                  ->where('compid',$_SESSION['compid'])
                  ->where('accountType','Mobile')
                  ->get()
                  ->row();
  return $query;  
}

public function get_salary_emp($id,$id2,$id3)
  {
  $emp = $this->db->select('empid')
                ->from('employee_payment')
                ->where('month',$id)
                ->where('year',$id2)
                ->where('empid',$id3)
                ->where('compid',$_SESSION['compid'])
                ->get()
                ->row();
  //var_dump($emp); exit();
//   $emp_id = array_map (function($value)
//     {
//     return $value['empid'];
//     },$emp);

  if($emp)
    {
    $empid = $emp->empid;
    }
  else
    {
    $empid = $id3;
    }

  $emps = $this->db->select('
                    employees.employeeID,
                    employees.employeeName,
                    employees.joiningDate,
                    employees.salary,
                    department.dept_name,
                    SUM(employee_payment.salary) as total')
                ->from('employees')
                ->join('department','department.dpt_id = employees.dpt_id','left')
                ->join('employee_payment','employee_payment.empid = employees.employeeID','left')
                ->where('employees.employeeID',$empid)
                ->where('employees.compid',$_SESSION['compid'])
                ->get()
                ->row();
  return $emps;
}

public function get_order_track_data($oid)
  {
  $query = $this->db->select('order.*,customers.customerName,customers.mobile,customers.email,customers.address')
              ->from('order')
              ->join('customers','customers.customerID = order.custid','left')
              ->where('oCode',$oid)
              ->get()
              ->row();
  return $query;  
}

public function get_morder_track_data($oid)
  {
  $query = $this->db->select('order.*,customers.customerName,customers.mobile,customers.email,customers.address')
              ->from('order')
              ->join('customers','customers.customerID = order.custid','left')
              ->where_in('customers.mobile',$oid)
              ->get()
              ->result();
  return $query;  
}

public function sales_fetch_data()
  {
  $query = $this->db->select('sales.*,customers.customerName,customers.mobile,customers.email,customers.address,users.name,users.mobile as umobile')
              ->from('sales')
              ->join('customers','customers.customerID = sales.customerID','left')
              ->join('users','users.uid = sales.regby','left')
              ->where('sales.compid',$_SESSION['compid'])
              ->get()
              ->result();
  return $query;  
}

public function user_dorder_ledger($uid,$sdate,$edate)
  {
  if($uid == 'All')
    {
    $query = $this->db->select('
                        order.*,
                        customers.customerName,
                        customers.mobile,
                        customers.address')
                ->from('order')
                ->join('customers','customers.customerID = order.custid','left')
                ->where('oDate >=',$sdate)
                ->where('oDate <=',$edate)
                ->get()
                ->result();
      }
    else
      {
      $query = $this->db->select('
                        order.*,
                        customers.customerName,
                        customers.mobile,
                        customers.address')
                ->from('order')
                ->join('customers','customers.customerID = order.custid','left')
                ->where('oDate >=',$sdate)
                ->where('oDate <=',$edate)
                ->where('order.regby',$uid)
                ->get()
                ->result();
      }
  return $query;  
}

public function user_morder_ledger($uid,$month,$year)
  {
  if($uid == 'All')
    {
    $query = $this->db->select('
                        order.*,
                        customers.customerName,
                        customers.mobile,
                        customers.address')
                ->from('order')
                ->join('customers','customers.customerID = order.custid','left')
                ->where('MONTH(oDate)',$month)
                ->where('YEAR(oDate)',$year)
                ->get()
                ->result();
      }
    else
      {
      $query = $this->db->select('
                        order.*,
                        customers.customerName,
                        customers.mobile,
                        customers.address')
                ->from('order')
                ->join('customers','customers.customerID = order.custid','left')
                ->where('MONTH(oDate)',$month)
                ->where('YEAR(oDate)',$year)
                ->where('order.regby',$uid)
                ->get()
                ->result();
      }
  return $query;  
}

public function user_yorder_ledger($uid,$year)
  {
  if($uid == 'All')
    {
    $query = $this->db->select('
                        order.*,
                        customers.customerName,
                        customers.mobile,
                        customers.address')
                ->from('order')
                ->join('customers','customers.customerID = order.custid','left')
                ->where('YEAR(oDate)',$year)
                ->get()
                ->result();
      }
    else
      {
      $query = $this->db->select('
                        order.*,
                        customers.customerName,
                        customers.mobile,
                        customers.address')
                ->from('order')
                ->join('customers','customers.customerID = order.custid','left')
                ->where('YEAR(oDate)',$year)
                ->where('order.regby',$uid)
                ->get()
                ->result();
      }
  return $query;  
}

public function user_aorder_ledger($uid)
  {
  $query = $this->db->select('
                    order.*,
                    customers.customerName,
                    customers.mobile,
                    customers.address')
            ->from('order')
            ->join('customers','customers.customerID = order.custid','left')
            ->where('order.regby',$uid)
            ->get()
            ->result();
  return $query;  
}

public function sales_adata()
  {
  $query = $this->db->select('*')
                  ->from('sales')
                  ->where('compid',$_SESSION['compid'])
                  ->get()
                  ->result();
  return $query;  
}

public function sales_ddata($sdate,$edate)
  {
    $query = $this->db->select('*')
                    ->from('sales')
                    ->where('saleDate >=',$sdate)
                    ->where('saleDate <=',$edate)
                    ->where('compid',$_SESSION['compid'])
                    ->get()
                    ->result();
  return $query;  
}

public function sales_mdata($month,$year)
  {
    $query = $this->db->select('*')
                    ->from('sales')
                    ->where('MONTH(saleDate)',$month)
                    ->where('YEAR(saleDate)',$year)
                    ->where('compid',$_SESSION['compid'])
                    ->get()
                    ->result();
  return $query;  
}

public function sales_ydata($year)
  {
    $query = $this->db->select('*')
                    ->from('sales')
                    ->where('YEAR(saleDate)',$year)
                    ->where('compid',$_SESSION['compid'])
                    ->get()
                    ->result();

  return $query;  
}

public function sales_due_adata()
  {
  $query = $this->db->select('sales.*,customers.customerName,customers.mobile,')
                  ->from('sales')
                  ->join('customers','customers.customerID = sales.customerID','left')
                  ->where('totalAmount > paidAmount')
                  ->where('sales.compid',$_SESSION['compid'])
                  ->get()
                  ->result();
  return $query;  
}

public function sales_due_ddata($sdate,$edate)
  {
    $query = $this->db->select('sales.*,customers.customerName,customers.mobile,')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->where('totalAmount > paidAmount')
                    ->where('sales.compid',$_SESSION['compid'])
                    ->where('saleDate >=',$sdate)
                    ->where('saleDate <=',$edate)
                    ->get()
                    ->result();
  return $query;  
}

public function sales_due_mdata($month,$year)
  {
    $query = $this->db->select('sales.*,customers.customerName,customers.mobile,')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->where('totalAmount > paidAmount')
                    ->where('sales.compid',$_SESSION['compid'])
                    ->where('MONTH(saleDate)',$month)
                    ->where('YEAR(saleDate)',$year)
                    ->get()
                    ->result();
  return $query;  
}

public function sales_due_ydata($year)
  {
    $query = $this->db->select('sales.*,customers.customerName,customers.mobile')
                    ->from('sales')
                    ->join('customers','customers.customerID = sales.customerID','left')
                    ->where('totalAmount > paidAmount')
                    ->where('sales.compid',$_SESSION['compid'])
                    ->where('YEAR(saleDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}




public function get_bank_purchase_data()
  {
  $query = $this->db->select('*')
                    ->from('purchase')
                    ->where('accountType','Bank')
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_sale_data()
  {
  $query = $this->db->select('*')
                    ->from('sales')
                    ->where('accountType','Bank')
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_sreturn_data()
  {
  $query = $this->db->select('*')
                    ->from('returns')
                    ->where('accountType','Bank')
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_preturn_data()
  {
  $query = $this->db->select('*')
                    ->from('preturns')
                    ->where('accountType','Bank')
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_voucher_data()
  {
  $query = $this->db->select('*')
                    ->from('vaucher')
                    ->where('accountType','Bank')
                    ->where('status',1)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_dpurchase_data($sdate,$edate)
  {
  $query = $this->db->select('*')
                    ->from('purchase')
                    ->where('accountType','Bank')
                    ->where('purchaseDate >=',$sdate)
                    ->where('purchaseDate <=',$edate)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_dsale_data($sdate,$edate)
  {
  $query = $this->db->select('*')
                    ->from('sales')
                    ->where('accountType','Bank')
                    ->where('saleDate >=',$sdate)
                    ->where('saleDate <=',$edate)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_dsreturn_data($sdate,$edate)
  {
  $query = $this->db->select('*')
                    ->from('returns')
                    ->where('accountType','Bank')
                    ->where('returnDate >=',$sdate)
                    ->where('returnDate <=',$edate)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_dpreturn_data($sdate,$edate)
  {
  $query = $this->db->select('*')
                    ->from('preturns')
                    ->where('accountType','Bank')
                    ->where('prDate >=',$sdate)
                    ->where('prDate <=',$edate)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_dvoucher_data($sdate,$edate)
  {
  $query = $this->db->select('*')
                    ->from('vaucher')
                    ->where('accountType','Bank')
                    ->where('voucherdate >=',$sdate)
                    ->where('voucherdate <=',$edate)
                    ->where('status',1)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_mpurchase_data($month,$year)
  {
  $query = $this->db->select('*')
                    ->from('purchase')
                    ->where('accountType','Bank')
                    ->where('MONTH(purchaseDate)',$month)
                    ->where('YEAR(purchaseDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_msale_data($month,$year)
  {
  $query = $this->db->select('*')
                    ->from('sales')
                    ->where('accountType','Bank')
                    ->where('MONTH(saleDate)',$month)
                    ->where('YEAR(saleDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_msreturn_data($month,$year)
  {
  $query = $this->db->select('*')
                    ->from('returns')
                    ->where('accountType','Bank')
                    ->where('MONTH(returnDate)',$month)
                    ->where('YEAR(returnDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_mpreturn_data($month,$year)
  {
  $query = $this->db->select('*')
                    ->from('preturns')
                    ->where('accountType','Bank')
                    ->where('MONTH(prDate)',$month)
                    ->where('YEAR(prDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_mvoucher_data($month,$year)
  {
  $query = $this->db->select('*')
                    ->from('vaucher')
                    ->where('accountType','Bank')
                    ->where('MONTH(voucherdate)',$month)
                    ->where('YEAR(voucherdate)',$year)
                    ->where('status',1)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_ypurchase_data($year)
  {
  $query = $this->db->select('*')
                    ->from('purchase')
                    ->where('accountType','Bank')
                    ->where('YEAR(purchaseDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_ysale_data($year)
  {
  $query = $this->db->select('*')
                    ->from('sales')
                    ->where('accountType','Bank')
                    ->where('YEAR(saleDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_ysreturn_data($year)
  {
  $query = $this->db->select('*')
                    ->from('returns')
                    ->where('accountType','Bank')
                    ->where('YEAR(returnDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_ypreturn_data($year)
  {
  $query = $this->db->select('*')
                    ->from('preturns')
                    ->where('accountType','Bank')
                    ->where('YEAR(prDate)',$year)
                    ->get()
                    ->result();

  return $query;  
}

public function get_bank_yvoucher_data($year)
  {
  $query = $this->db->select('*')
                    ->from('vaucher')
                    ->where('accountType','Bank')
                    ->where('YEAR(voucherdate)',$year)
                    ->where('status',1)
                    ->get()
                    ->result();

  return $query;  
}

public function get_product_stock_data()
  {
  $emp = $this->db->select('productID')
        ->from('products')
        ->get()
        ->result_array();
    //var_dump($emp); exit();
  $emp_id = array_map (function($value){
  return $value['productID'];
  },$emp);
    //var_dump($emp_id); exit();
  if($emp_id == NULL)
      {
      $empid = 0;
      }
  else{
      $empid = $emp_id;
      }
      
  $query = $this->db->select('stock.*,products.productName,products.productcode,products.pprice,products.sprice,products.categoryID,products.unit')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where_in('stock.product',$empid)
                ->where('totalPices > 0')
                ->get()
                ->result();
  return $query;  
}
public function get_product_by_id_sstock_data2($productId)
{
    if ($productId == 'All' || empty($productId)) {
        // Return all products if "All" is selected
        $query = $this->db->select('stock.*, products.productName, products.productcode, products.pprice, products.sprice')
            ->from('stock')
            ->join('products', 'products.productID = stock.product', 'left')
            ->where('totalPices > 0')
            ->get()
            ->result();
    } else {
        // Filter by specific product ID
        $query = $this->db->select('stock.*, products.productName, products.productcode, products.pprice, products.sprice')
            ->from('stock')
            ->join('products', 'products.productID = stock.product', 'left')
            ->where('stock.product', $productId)
            ->where('totalPices > 0')
            ->get()
            ->result();
    }
    return $query;
}

public function get_product_sstock_data2($catid)
{
    $emp = $this->db->select('productID')
        ->from('products')
        ->where('categoryID', $catid)
        ->get()
        ->result_array();

    $emp_id = array_map(function($value) {
        return $value['productID'];
    }, $emp);

    if (empty($emp_id)) {
        $empid = 0;
    } else {
        $empid = $emp_id;
    }

    $query = $this->db->select('stock.*, products.productName, products.productcode, products.pprice, products.sprice')
        ->from('stock')
        ->join('products', 'products.productID = stock.product', 'left')
        ->where('totalPices > 0')
        ->where_in('stock.product', $empid)
        ->get()
        ->result();

    return $query;
}
public function get_product_stock_data2($catid = null)
{
    $emp = $this->db->select('productID')
        ->from('products')
        ->get()
        ->result_array();

    $emp_id = array_map(function($value) {
        return $value['productID'];
    }, $emp);

    if (empty($emp_id)) {
        $empid = 0;
    } else {
        $empid = $emp_id;
    }

    $this->db->select('stock.*, products.productName, products.productcode, products.pprice, products.sprice')
        ->from('stock')
        ->join('products', 'products.productID = stock.product', 'left')
        ->where('totalPices > 0')
        ->where_in('stock.product', $empid);

    // Only add category filter if $catid is provided
    if ($catid !== null) {
        $this->db->where('categoryID', $catid);
    }

    $query = $this->db->get()->result();
    return $query;
}

public function get_product_ptype_sstock_data($catid)
  {
  $emp = $this->db->select('productID')
        ->from('products')
        ->get()
        ->result_array();
    //var_dump($emp); exit();
  $emp_id = array_map (function($value){
  return $value['productID'];
  },$emp);
    //var_dump($emp_id); exit();
  if($emp_id == NULL)
      {
      $empid = 0;
      }
  else{
      $empid = $emp_id;
      }
  
  if($catid == 1)
    {
    $query = $this->db->select('stock.*,products.productName,products.productcode,products.pprice,products.sprice')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where('totalPices > 0')
                ->where_in('stock.product',$empid)
                ->get()
                ->result();
    }
  else
    {
    $query = $this->db->select('stock.*,products.productName,products.productcode,products.pprice,products.sprice')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where('dtquantity > 0')
                ->where_in('stock.product',$empid)
                ->get()
                ->result();
    }
  return $query;  
}
public function get_product_ptype_sstock_data2($catid)
  {
  $emp = $this->db->select('productID')
        ->from('products')
        ->get()
        ->result_array();
    //var_dump($emp); exit();
  $emp_id = array_map (function($value){
  return $value['productID'];
  },$emp);
    //var_dump($emp_id); exit();
  if($emp_id == NULL)
      {
      $empid = 0;
      }
  else{
      $empid = $emp_id;
      }
  
  if($catid == 1)
    {
    $query = $this->db->select('stock.*,products.productName,products.productcode,products.pprice,products.sprice')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where('totalPices > 0')
                ->where_in('stock.product',$empid)
                ->get()
                ->result();
    }
  else
    {
    $query = $this->db->select('stock.*,products.productName,products.productcode,products.pprice,products.sprice')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where('dtquantity > 0')
                ->where_in('stock.product',$empid)
                ->get()
                ->result();
    }
  return $query;  
}

public function get_dproduct_sstock_data()
  {
  $emp = $this->db->select('productID')
        ->from('products')
        ->get()
        ->result_array();
    //var_dump($emp); exit();
  $emp_id = array_map (function($value){
  return $value['productID'];
  },$emp);
    //var_dump($emp_id); exit();
  if($emp_id == NULL)
      {
      $empid = 0;
      }
  else{
      $empid = $emp_id;
      }
      
  $query = $this->db->select('stock.*,products.productName,products.productcode,products.pprice,products.sprice')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where('dtquantity > 0')
                ->where_in('stock.product',$empid)
                ->get()
                ->result();
  return $query;  
}

public function damage_product_data()
  {
  $query = $this->db->select('stock.*,products.productName,products.productcode')
                ->from('stock')
                ->join('products','products.productID = stock.product','left')
                ->where('dtquantity > 0')
                ->get()
                ->result();
  return $query;  
}

public function count_total_order()
  {
  $query = $this->db->select('*')
                ->from('order')
                ->get();

  $count_row = $query->num_rows();

  if($count_row)
    {
    return $count_row;
    }
  else
    {
    return 0;
    }
}

public function count_total_porder()
  {
  $query = $this->db->select('*')
                ->from('order')
                ->where('status',1)
                ->get();

  $count_row = $query->num_rows();

  if($count_row)
    {
    return $count_row;
    }
  else
    {
    return 0;
    }
}

public function count_total_corder()
  {
  $query = $this->db->select('*')
                ->from('order')
                ->where('status',5)
                ->get();

  $count_row = $query->num_rows();

  if($count_row)
    {
    return $count_row;
    }
  else
    {
    return 0;
    }
}

public function count_total_sorder()
  {
  $query = $this->db->select('*')
                ->from('order')
                ->where('status',2)
                ->get();

  $count_row = $query->num_rows();

  if($count_row)
    {
    return $count_row;
    }
  else
    {
    return 0;
    }
}


public function sales_due_payment_data()
  {
  $query = $this->db->select('sales_payment.*,sales.saleID,customers.customerName')
                ->from('sales_payment')
                ->join('sales','sales.saleID = sales_payment.saleID')
                ->join('customers','customers.customerID = sales.customerID','left')
                ->get()
                ->result();
  return $query; 
}

public function sales_due_dpayment_data($sdate,$edate)
  {
  $query = $this->db->select('sales_payment.*,sales.saleID,customers.customerName')
                ->from('sales_payment')
                ->join('sales','sales.saleID = sales_payment.saleID')
                ->join('customers','customers.customerID = sales.customerID','left')
                ->where('DATE(sales_payment.regdate) >=',$sdate)
                ->where('DATE(sales_payment.regdate) <=',$edate)
                ->get()
                ->result();
  return $query; 
}

public function sales_due_mpayment_data($month,$year)
  {
  $query = $this->db->select('sales_payment.*,sales.saleID,customers.customerName')
                ->from('sales_payment')
                ->join('sales','sales.saleID = sales_payment.saleID')
                ->join('customers','customers.customerID = sales.customerID','left')
                ->where('MONTH(sales_payment.regdate)',$month)
                ->where('YEAR(sales_payment.regdate)',$year)
                ->get()
                ->result();
  return $query; 
}

public function sales_due_ypayment_data($year)
  {
  $query = $this->db->select('sales_payment.*,sales.saleID,customers.customerName')
                ->from('sales_payment')
                ->join('sales','sales.saleID = sales_payment.saleID')
                ->join('customers','customers.customerID = sales.customerID','left')
                ->where('YEAR(sales_payment.regdate)',$year)
                ->get()
                ->result();
  return $query; 
}

public function get_transfer_account_data()
  {
  $query = $this->db->select('*')
                ->from('transfer_account')
                ->get()
                ->result();
  return $query; 
}

public function get_dtransfer_account_data($sdate,$edate)
  {
  $query = $this->db->select('*')
                ->from('transfer_account')
                ->where('DATE(regdate) >=',$sdate)
                ->where('DATE(regdate) <=',$edate)
                ->get()
                ->result();
  return $query; 
}

public function get_mtransfer_account_data($month,$year)
  {
  $query = $this->db->select('*')
                ->from('transfer_account')
                ->where('MONTH(regdate)',$month)
                ->where('YEAR(regdate)',$year)
                ->get()
                ->result();
  return $query; 
}

public function get_ytransfer_account_data($year)
  {
  $query = $this->db->select('*')
                ->from('transfer_account')
                ->where('YEAR(regdate)',$year)
                ->get()
                ->result();
  return $query; 
}

public function get_cost_report_data()
  {
  $query = $this->db->select('vaucher.*,cost_type.costName')
                ->from('vaucher')
                ->join('cost_type','cost_type.ct_id = vaucher.costType','left')
                ->where('vaucher.vauchertype','Debit Voucher')
                ->get()
                ->result();
  return $query; 
}

public function get_dcost_report_data($sdate,$edate,$vtype)
  {
  if($vtype == 'All')
    {
    $query = $this->db->select('vaucher.*,cost_type.costName')
                ->from('vaucher')
                ->join('cost_type','cost_type.ct_id = vaucher.costType','left')
                ->where('vaucher.vauchertype','Debit Voucher')
                ->where('DATE(voucherdate) >=',$sdate)
                ->where('DATE(voucherdate) <=',$edate)
                ->get()
                ->result();
    }
  else
    {
    $query = $this->db->select('vaucher.*,cost_type.costName')
                ->from('vaucher')
                ->join('cost_type','cost_type.ct_id = vaucher.costType','left')
                ->where('vaucher.vauchertype','Debit Voucher')
                ->where('DATE(voucherdate) >=',$sdate)
                ->where('DATE(voucherdate) <=',$edate)
                ->where('vaucher.costType',$vtype)
                ->get()
                ->result();
    }
  return $query; 
}

public function get_mcost_report_data($month,$year,$vtype)
  {
  $query = $this->db->select('vaucher.*,cost_type.costName')
                ->from('vaucher')
                ->join('cost_type','cost_type.ct_id = vaucher.costType','left')
                ->where('vaucher.vauchertype','Debit Voucher')
                ->where('MONTH(vaucher.voucherdate)',$month)
                ->where('YEAR(vaucher.voucherdate)',$year)
                ->where('vaucher.costType',$vtype)
                ->get()
                ->result();
  return $query; 
}

public function get_ycost_report_data($year,$vtype)
  {
  $query = $this->db->select('vaucher.*,cost_type.costName')
                ->from('vaucher')
                ->join('cost_type','cost_type.ct_id = vaucher.costType','left')
                ->where('vaucher.vauchertype','Debit Voucher')
                ->where('YEAR(vaucher.voucherdate)',$year)
                ->where('vaucher.costType',$vtype)
                ->get()
                ->result();
  return $query; 
}

public function get_sales_emi_payment($id)
  {
  $query = $this->db->select('*')
              ->from('sales')
              ->where('saleID',$id)
              ->get()
              ->row();
  return $query; 
}

public function today_cash_amount()
  {
  $query = $this->db->select('SUM(balance) as ta')
              ->from('cash')
              ->get()
              ->row();
  return $query; 
}

public function today_bank_amount()
  {
  $query = $this->db->select('SUM(balance) as ta')
              ->from('bankaccount')
              ->get()
              ->row();
  return $query; 
}

public function today_mobile_amount()
  {
  $query = $this->db->select('SUM(balance) as ta')
              ->from('mobileaccount')
              ->get()
              ->row();
  return $query; 
}

public function daily_demp_payments_amount($sdate,$edate)
  {
  $query = $this->db->select("employee_payment.*,employees.employeeName")
                  ->FROM('employee_payment')
                  ->join('employees','employees.employeeID = employee_payment.empid','left')
                  ->where('DATE(employee_payment.regdate) >=', $sdate)
                  ->where('DATE(employee_payment.regdate) <=', $edate)
                  ->get()
                  ->result();
  return $query;  
}

public function get_cash_account_data($id)
  {
  $query = $this->db->select('*')
                  ->from('cash')
                  ->where('ca_id',$id)
                  ->where('compid', $_SESSION['compid'])
                  ->get()
                  ->row();
  return $query; 
}

public function get_invoice_by_id($invoice_id) {
    // Ensure $invoice_id is sanitized to avoid SQL injection
    $invoice_id = (int) $invoice_id;

    // Query the sales table to get invoice details
    $this->db->select('sales.*, customers.customerName, customers.address, customers.mobile, customers.email');
    $this->db->from('sales');
    $this->db->join('customers', 'customers.customerID = sales.customerID', 'left'); // Assuming sales has a customer_id
    $this->db->where('sales.saleID', $invoice_id);
    
    // Execute the query
    $query = $this->db->get();
    
    // Check if the invoice exists
    if ($query->num_rows() > 0) {
        // Return the invoice details as an associative array
        return $query->row_array(); // Returns the first row as array
    }
    
    // Return false if no invoice is found
    return false;
}



}