<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once APPPATH . 'third_party/dompdf/autoload.inc.php'; // Adjust the path if necessary

use Dompdf\Dompdf;

class Dompdf_generator {

    protected $CI;
    protected $dompdf;

    public function __construct() {
        $this->CI =& get_instance();
        $this->dompdf = new Dompdf();
    }

    public function generate($data) {
        $this->CI->load->view('invoice_template', $data, TRUE);
        $html = $this->CI->output->get_output();
        $this->dompdf->loadHtml($html);
        $this->dompdf->setPaper('A4', 'portrait');
        $this->dompdf->render();
        $filename = 'invoice_' . time() . '.pdf';
        $filepath = FCPATH . 'uploads/invoices/' . $filename;
        file_put_contents($filepath, $this->dompdf->output());

        return $filename;
    }
}
