<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sale extends CI_Controller {

public function __construct() {
    parent::__construct();
    $this->load->model("prime_model","pm");
    // Apply authentication check to all methods *except* viewSale
    if ($this->router->fetch_method() !== 'view_invoice2') {
        $this->checkPermission();
    }
    $this->load->library('PHPExcel');
    $this->load->library('excel');
    $this->load->library('Dompdf_generator');
}

public function index()
    {
    $data['title'] = 'Sale';
    
    $other = array(
        'join' => 'left',
        'order_by' => 'saleID'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.customerName,customers.mobile'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID'
            );
    
  if($_SESSION['role'] > 2)
    {
    $where = array(
      'sales.compid' => $_SESSION['compid']
            );
            
    $data['sales'] = $this->pm->get_data('sales',$where,$field,$join,$other);
    }
  else
    {
    $data['sales'] = $this->pm->get_data('sales',false,$field,$join,$other);
    }

    $data['customer'] = $this->pm->get_data('customers',false);
    $data['product'] = $this->pm->get_data('products',false);
    $data['receivable'] = $this->pm->total_receivable();

    $this->load->view('sale/sales_list',$data);
}

public function new_sale()
    {
    $data['title'] = 'Sale';
    
    $where = array(
      'compid' => $_SESSION['compid']
            );
            
    
    $data['customer'] = $this->pm->get_data('customers',$where);
    $data['product'] = $this->pm->get_data('products',$where);

    $this->load->view('sale/NewSale',$data);
}

public function get_sale_customer()
    {
    $other = array(
        'order_by' => 'customerID'
            );
    $where = $_SESSION['compid'];
    $section = $this->pm->get_data_with_due($where);
    $someJSON = json_encode($section);
    echo $someJSON;
}

public function getDetails()
    {
    $join = false;
    $other = false;
    $table = $this->input->post('table');
    $id = $this->input->post('id');
 
    if ($table == "products") 
        {
        $where = array(
            'productID' => $id,
            'stock.compid' => $_SESSION['compid'],
            'stock.totalPices >' => 0
                );
        $join = array(
            'stock' => 'products.productID = stock.product'
                );
        $other = array(
            'join' => 'left'
                );
        }
    $products = $this->pm->get_data($table,$where,false,$join,$other);
    $str='';
    foreach($products as $value){
        $id = $value['productID'];
        $tpq = $value['totalPices'];
        $str.="<tr>
        <td><input type='text' name='productName[]' value='".$value['productName'].' ( '.$value['productcode'].' )'."' required ><input type='hidden' name='productID[]' value='".$value['productID']."'>
        </td>
        <td>".$value['totalPices']."</td>
        <td><input type='text' onkeyup='totalPrice(".$id.")' name='pices[]' id='pices_".$value['productID']."' value='0' max='$tpq' min='1'>
        </td>
        <td>".$value['sprice']."<input type='hidden' onkeyup='totalPrice(".$id.")' name='salePrice[]' id='salePrice_".$value['productID']."' value='".$value['sprice']."'>
        </td>
        <td>
        <input type='text' class='totalPrice'  name='totalPrice[]' readonly id='totalPrice_".$value['productID']."' value='0'>
        </td><td>
        <span class='item_remove btn btn-danger' onClick='$(this).parent().parent().remove();' >x</span>
        </td></tr>";
        }
    //var_dump($str); exit();
    echo json_encode($str);
}

public function get_product_details($id)
  {
  $where = array(
    'productID' => $id,
    'stock.compid' => $_SESSION['compid'],
    'stock.totalPices >' => 0
      );
  $other = array(
    'join' => 'left'
        );
  $field = array(
    'products' => 'products.*',
    'stock' => 'stock.totalPices'
        );
  $join = array(
    'stock' => 'products.productID = stock.product'
        );

  $products = $this->pm->get_data('products',$where,$field,$join,$other);
  
  $str = '';
   if($products){
  foreach($products as $value)
    {
    $pid = $value['productID'];
    $tpq = $value['totalPices'];
    $str.="<tr>
      <td>".$value['productcode']."</td>
      <td><input type='text' class='form-control' name='productName[]' value='".$value['productName']."' required readonly><input type='hidden' name='productID[]' value='".$value['productID']."' required readonly></td>
      <td>".$value['totalPices']."</td>
      <td><input type='text' class='form-control' onkeyup='totalPrice(".$value['productID'].")' name='pices[]' id='pices_".$value['productID']."' value='1' max='$tpq' min='1'></td>
      <td><input type='text' class='form-control' onkeyup='totalPrice(".$value['productID'].")' name='salePrice[]' id='salePrice_".$value['productID']."' value='".$value['sprice']."'></td>
      <td><input type='text' class='totalPrice form-control' name='totalPrice[]' readonly id='totalPrice_".$value['productID']."' value='".$value['sprice']."'></td>
      <td><span class='item_remove btn btn-danger' onclick='deleteProduct(this)' >x</span>
      </td>
      </tr>";
    }
  echo json_encode($str);
  }
  else{
       echo json_encode(1);
  }
}

public function saved_sale()
    {
    $info = $this->input->post();
    
    $ptoken = bin2hex(random_bytes(16)); // Secure 32-character token

    $query = $this->db->select('saleID')
                  ->from('sales')
                  ->limit(1)
                  ->order_by('saleID','DESC')
                  ->get()
                  ->row();
    if($query)
        {
        $sn = $query->saleID+1;
        }
    else
        {
        $sn = 1;
        }
    $cn = strtoupper(substr($_SESSION['compname'],0,3));
    $pc = sprintf("%'05d", $sn);

    $cusid = 'MS-'.$pc;
    // $cusid = $pc;

    if($info['disType'] == '%')
        {
        $disa = ($info['totalprice']*$info['disAmount'])/100;
        }
    else{
        $disa = $info['discount'];
        }
    
  $config['upload_path'] = './upload/';
  $config['allowed_types'] = '*';
  $config['max_size'] = 0;
  $config['max_width'] = 0;
  $config['max_height'] = 0;

  $this->load->library('upload',$config);
  $this->upload->initialize($config);
                    
  if($this->upload->do_upload('gnid'))
    {
    $gnid = $this->upload->data('file_name');
    }
  else
    {
    $gnid = '';
    }
  
  if($this->upload->do_upload('gcheck'))
    {
    $gcheck = $this->upload->data('file_name');
    }
  else
    {
    $gcheck = '';
    }

    $sale = array(
        'compid'         => $_SESSION['compid'],
        'invoice_no'     => $cusid,
        'saleDate'       => date('Y-m-d', strtotime($info['date'])),
        'public_token'     => $ptoken,
        'customerID'     => $info['customerID'],
        'totalAmount'    => $info['totalprice'],
        'paidAmount'     => $info['total_paid'],
        'pAmount'        => $info['total_paid'],
        'dueamount'      => $info['due'],
        'discount'       => $info['discount'], 
        'discountAmount' => $info['disAmount'], 
        'vCost'          => $info['vCost'],
        'vType'          => $info['vType'],             
        'vAmount'        => $info['vAmount'],
        // 'discountType'   => $info['discounttype'],
        // 'discountAmount' => $disa,
        'terms'          => $info['terms'],
        'accountType'    => $info['accountType'],
        'accountNo'      => $info['accountNo'],
        'note'           => $info['note'],
        'sstatus'        => 'Cash Sell',
        'regby'          => $_SESSION['uid']
            );
        //var_dump($sale); exit();
    $result = $this->pm->insert_data('sales',$sale);
       
    $length = count($info['productID']);

    for ($i = 0; $i < $length; $i++)
        {
        $spdata = array(
            'saleID'     => $result,
            'productID'  => $info['productID'][$i],
            'pName'      => $info['productName'][$i],
            'quantity'   => $info['pices'][$i],
            'sprice'     => $info['salePrice'][$i],
            'totalPrice' => $info['totalPrice'][$i],
            'regby'      => $_SESSION['uid']
                );

        $this->pm->insert_data('sale_product',$spdata);

        $pid = $info['productID'][$i];
        $aid = $_SESSION['compid'];

        // $swhere = array(
        //     'compid'  => $_SESSION['compid'],
        //     'product' => $pid
        //             );

        // $stpd = $this->pm->get_data('stock',$swhere);

        // $this->pm->delete_data('stock',$swhere);

        // if($stpd)
        //     {
        //     $tquantity = $stpd[0]['totalPices']-($info['pices'][$i]);
        //     $dtqnt = $stpd[0]['dtquantity'];
        //     }
        // else{
        //     $tquantity = '-'.($info['pices'][$i]);
        //     $dtqnt = 0;
        //     }

        // $stock_info = array(
        //     'compid'     => $_SESSION['compid'],
        //     'product'    => $info['productID'][$i],
        //     'totalPices' => $tquantity,
        //     'dtquantity' => $dtqnt,
        //     'regby'      => $_SESSION['uid']
        //             );
        // //var_dump($stock_info);    
        // $this->pm->insert_data('stock',$stock_info);  
        }
            
    if($result)
        {
            
        $invoice = 'https://metlercorporation.com/viewInvoice/'.$ptoken;
        
        $msg = "Dear Client,"."\n".
                "Your Recent Invoice No:".$cusid."\n".
                "Dated: ".date('Y-m-d', strtotime($info['date']))."\n".
                "Invoice Amount: BDT ".number_format($info['totalprice'],2)."\n".
                "Your Outstanding: BDT ".number_format($info['due'],2)."\n".
                "Invoice: ".$invoice."\n\n".
                "Thanking you,\n METLER CORPORATION";
    
        $cust = $this->pm->get_customer_data($info['customerID']);
    
        $mob = '+88'.$cust->mobile;
        $token = urlencode("2ngn1tqt-mi6kusln-vavoodmv-blsb9va2-6cwufe4w");
        $message = urlencode($msg);
        $to = urlencode($mob);
        $url = "https://smsplus.sslwireless.com/api/v3/send-sms?api_token=$token&sid=METLERNONBRAND&sms=$message&msisdn=$to&csms_id=1";
        
        $data = array(
            'to'      => "$to",
            'message' => "$message",
            'token'   =>"$token"
              );
            //var_dump($data); exit();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_ENCODING,'');
        curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $smsresult = curl_exec($ch);
        // var_dump($smsresult);die;
        
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Product Sold Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    //redirect('Sale');
    redirect('viewSale/'.$result);
}

public function view_invoice($id)
    {
    $data['title'] = 'Sale Invoice';

    $where = array(
        'saleID' => $id
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.*',
        'users' => 'users.name'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID',
        'users' => 'users.uid = sales.regby'
            );
    $prints = $this->pm->get_data('sales',$where,$field,$join,$other);
    $data['prints'] = $prints[0];

    $pfield = array(
        'sale_product' => 'sale_product.*',
        'products' => 'products.productName,products.productcode,products.warranty',
        'sma_units' => 'sma_units.unitName'
            );
    $pjoin = array(
        'products' => 'products.productID = sale_product.productID',
        'sma_units' => 'sma_units.id = products.unit'
            );

    $data['salesp'] = $this->pm->get_data('sale_product',$where,$pfield,$pjoin,$other);

    $cusid = $prints[0]['customerID'];
    //var_dump($cusid); exit();
    $data['csdue'] = $this->pm->customer_sales_due_details($id,$cusid);
    $data['cvpa'] = $this->pm->customer_vaucher_paid_details($cusid);
    $data['cra'] = $this->pm->customer_returns_details($cusid);
    $data['cpay'] = $this->pm->customer_sales_payment($cusid);
    
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('sale/print_page',$data);
    // // Load the view into a variable
    //     $html = $this->load->view('sale/print_page', $data, TRUE);

    //     // Generate the PDF
    //     $filename = 'invoice_' . $id . '.pdf';
    //     $this->dompdf_generator->generate($html, $filename);

    //     // Optionally, provide a link to download the PDF
    //     $this->load->helper('url');
    //     redirect('uploads/invoices/' . $filename);
}

public function view_invoice2($id)
    {
    $data['title'] = 'Sale Invoice';
    
    if(!$this->db->select('saleID')->from('sales')->where('public_token', $id)->get()->row()){
        show_error('Invalid or expired invoice link.', 404, 'Invoice Not Found');
        return;
    }
    $saleID = $this->db->select('saleID')->from('sales')->where('public_token', $id)->get()->row()->saleID;
    
    
    $where = array(
        'public_token' => $id
            );
    $where2 = array(
        'saleID' => $saleID
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.*',
        'users' => 'users.name'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID',
        'users' => 'users.uid = sales.regby'
            );
    $prints = $this->pm->get_data('sales',$where,$field,$join,$other);
    $data['prints'] = $prints[0];

    $pfield = array(
        'sale_product' => 'sale_product.*',
        'products' => 'products.productName,products.productcode,products.warranty',
        'sma_units' => 'sma_units.unitName'
            );
    $pjoin = array(
        'products' => 'products.productID = sale_product.productID',
        'sma_units' => 'sma_units.id = products.unit'
            );

    $data['salesp'] = $this->pm->get_data('sale_product',$where2,$pfield,$pjoin,$other);

    $cusid = $prints[0]['customerID'];
    //var_dump($cusid); exit();
    $data['csdue'] = $this->pm->customer_sales_due_details($saleID,$cusid);
    $data['cvpa'] = $this->pm->customer_vaucher_paid_details($cusid);
    $data['cra'] = $this->pm->customer_returns_details($cusid);
    $data['cpay'] = $this->pm->customer_sales_payment($cusid);
    
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('sale/public_invoice',$data);
    // // Load the view into a variable
    //     $html = $this->load->view('sale/print_page', $data, TRUE);

    //     // Generate the PDF
    //     $filename = 'invoice_' . $id . '.pdf';
    //     $this->dompdf_generator->generate($html, $filename);

    //     // Optionally, provide a link to download the PDF
    //     $this->load->helper('url');
    //     redirect('uploads/invoices/' . $filename);
}

// In application/controllers/Sale.php
public function invoice_view($invoice_id) {
    // Load the necessary models
    $data['title'] = 'Sale Invoice';
    // Fetch the invoice data based on the invoice ID (or invoice number)
    $invoice = $this->pm->get_invoice_by_id($invoice_id);
    if (!$invoice) {
        show_404(); // Show 404 if invoice is not found
    }

    // Get the company details for the header
    $data['company'] = $this->pm->company_details();

    $where = array(
        'saleID' => $invoice_id
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.*',
        'users' => 'users.name'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID',
        'users' => 'users.uid = sales.regby'
            );
    $prints = $this->pm->get_data('sales',$where,$field,$join,$other);
    $data['prints'] = $prints[0];

    $pfield = array(
        'sale_product' => 'sale_product.*',
        'products' => 'products.productName,products.productcode,products.warranty',
        'sma_units' => 'sma_units.unitName'
            );
    $pjoin = array(
        'products' => 'products.productID = sale_product.productID',
        'sma_units' => 'sma_units.id = products.unit'
            );

    $data['salesp'] = $this->pm->get_data('sale_product',$where,$pfield,$pjoin,$other);
    $cusid = $prints[0]['customerID'];
    $data['csdue'] = $this->pm->customer_sales_due_details($invoice_id,$cusid);
    $data['cvpa'] = $this->pm->customer_vaucher_paid_details($cusid);
    $data['cra'] = $this->pm->customer_returns_details($cusid);
    $data['cpay'] = $this->pm->customer_sales_payment($cusid);

    // Load the print view
    $this->load->view('sale/print_page', $data);
}


public function delivery_chalan($id)
    {
    $data['title'] = 'Delivery Chalan';

    $where = array(
        'saleID' => $id
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.*',
        'users' => 'users.name'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID',
        'users' => 'users.uid = sales.regby'
            );
    $prints = $this->pm->get_data('sales',$where,$field,$join,$other);
    $data['prints'] = $prints[0];

    $pfield = array(
        'sale_product' => 'sale_product.*',
        'products' => 'products.productName,products.productcode,products.warranty',
        'sma_units' => 'sma_units.unitName'
            );
    $pjoin = array(
        'products' => 'products.productID = sale_product.productID',
        'sma_units' => 'sma_units.id = products.unit'
            );

    $data['salesp'] = $this->pm->get_data('sale_product',$where,$pfield,$pjoin,$other);

    $cusid = $prints[0]['customerID'];
    //var_dump($cusid); exit();
    $data['csdue'] = $this->pm->customer_sales_due_details($id,$cusid);
    $data['cvpa'] = $this->pm->customer_vaucher_paid_details($cusid);
    $data['cra'] = $this->pm->customer_returns_details($cusid);
    $data['cpay'] = $this->pm->customer_sales_payment($cusid);
    
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('sale/delivery_chalan',$data);
}

public function approve_sale($id){
    
    $where =array(
        'saleID'   => $id
        );
        
    $info2 = array(
      'status'     => 1,
      'upby'       => $_SESSION['uid']
              );
          
    $this->pm->update_data('sales',$info2,$where); 
    
    $result = $this->pm->get_data('sale_product',$where);
       
    $length = count($result);

    foreach($result as $info)
        {
        $pid = $info['productID'];
        $aid = $_SESSION['compid'];
        
// var_dump($info['productID']);
// var_dump($_SESSION['compid']);exit();

        $swhere = array(
            'compid'  => $_SESSION['compid'],
            'product' => $pid
                    );

        $stpd = $this->pm->get_data('stock',$swhere);

        $this->pm->delete_data('stock',$swhere);

        if($stpd)
            {
            $tquantity = $stpd[0]['totalPices']-($info['quantity']);
            $dtqnt = $stpd[0]['dtquantity'];
            }
        else{
            $tquantity = '-'.($info['quantity']);
            $dtqnt = 0;
            }

        $stock_info = array(
            'compid'     => $_SESSION['compid'],
            'product'    => $info['productID'],
            'totalPices' => $tquantity,
            'dtquantity' => $dtqnt,
            'regby'      => $_SESSION['uid']
                    );
                    
        $this->pm->insert_data('stock',$stock_info);  
        }
    
    if($result)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-primary alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Sale Approved Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Sale');
}

public function edit_sale($id)
    {
    $data['title'] = 'Sale';

    $where = array(
        'saleID' => $id
            );

    $prints = $this->pm->get_data('sales',$where);
    $data['sale'] = $prints[0];

    $other = array(
        'join' => 'left'
            );
    $pfield = array(
        'sale_product' => 'sale_product.*',
        'products' => 'products.productName,products.productcode'
            );
    $pjoin = array(
        'products' => 'products.productID = sale_product.productID'
            );

    $data['salesp'] = $this->pm->get_data('sale_product',$where,$pfield,$pjoin,$other);
    $cwhere = array(
        'compid' => $_SESSION['compid']
            );
    $where = $_SESSION['compid'];
    $data['customer'] = $this->pm->get_data_with_due($where);
    $data['product'] = $this->pm->get_data('products',$cwhere);

    $this->load->view('sale/EditSale',$data);
}

public function update_sale()
  {
  $info = $this->input->post();
  
  if($info['disType'] == '%')
    {
    $disa = ($info['totalprice']*$info['disAmount'])/100;
    }
  else
    {
    $disa = $info['discount'];
    }
  
  $config['upload_path'] = './upload/';
  $config['allowed_types'] = '*';
  $config['max_size'] = 0;
  $config['max_width'] = 0;
  $config['max_height'] = 0;

  $this->load->library('upload',$config);
  $this->upload->initialize($config);
  
//   $store = $this->db->select('gNid,gCheck')->from('sales')->where('saleID',$info['saleID'])->get()->row();
                    
//   if($this->upload->do_upload('gnid'))
//     {
//     $gnid = $this->upload->data('file_name');
//     }
//   else
//     {
//     if($store)
//       {
//       $gnid = $store->gNid;
//       }
//     else
//       {
//       $gnid = '';
//       }
//     }
  
//   if($this->upload->do_upload('gcheck'))
//     {
//     $gcheck = $this->upload->data('file_name');
//     }
//   else
//     {
//     if($store)
//       {
//       $gcheck = $store->gCheck;
//       }
//     else
//       {
//       $gcheck = '';
//       }
//     }
    
  $sale = array(
    'compid'         => $_SESSION['compid'],
    'saleDate'       => date('Y-m-d', strtotime($info['date'])),
    'customerID'     => $info['customerID'],
    'totalAmount'    => $info['totalprice'],
    'paidAmount'     => $info['total_paid'],
    'pAmount'        => $info['total_paid'],
    'dueamount'      => $info['due'],
    'discount'       => $info['discount'], 
    'discountAmount' => $info['disAmount'], 
    'vCost'          => $info['vCost'],
    'vType'          => $info['vType'],             
    'vAmount'        => $info['vAmount'],
    'terms'          => $info['terms'],
    'accountType'    => $info['accountType'],
    'accountNo'      => $info['accountNo'],
    'note'           => $info['note'],             
    'upby'           => $_SESSION['uid']
        );

  $where = array(
    'saleID' => $info['saleID']
        );
    //var_dump($sale); exit();
  $result = $this->pm->update_data('sales',$sale,$where);

  $pp = $this->pm->get_data('sale_product',$where);
  $this->pm->delete_data('sale_product',$where);
  
  $lnth = count($pp);

  for($i = 0; $i < $lnth; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pp[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pp)
        {
        $tquantity = ($spd[0]['totalPices']+$pp[$i]['quantity']);
        $dtqnt = $spd[0]['dtquantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stockinfo = array(
      'compid'      => $_SESSION['compid'],
      'product'     => $pp[$i]['productID'],
      'totalPices'  => $tquantity,
      'dtquantity'  => $dtqnt,
      'regby'       => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stockinfo); 
    }

  $length = count($info['productID']);

  for($i = 0; $i < $length; $i++)
    {
    $spdata = array(
      'saleID'     => $info['saleID'],
      'productID'  => $info['productID'][$i],
      'pName'      => $info['productName'][$i],
      'quantity'   => $info['pices'][$i],
      'sprice'     => $info['salePrice'][$i],
      'totalPrice' => $info['totalPrice'][$i],
      'upby'       => $_SESSION['uid']
            );

    $result2 = $this->pm->insert_data('sale_product',$spdata);

    $pid = $info['productID'][$i];
    $aid = $_SESSION['compid'];

    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pid
              );

    $stpd = $this->pm->get_data('stock',$swhere);

    $this->pm->delete_data('stock',$swhere);

    if($stpd)
      {
      $tquantity = ($stpd[0]['totalPices']-$info['pices'][$i]);
      $dtqnt = $stpd[0]['dtquantity'];
      }
    else
      {
      $tquantity = '-'.$info['pices'][$i];
      $dtqnt = 0;
      }

    $stock_info = array(
      'compid'     => $_SESSION['compid'],
      'product'    => $info['productID'][$i],
      'totalPices' => $tquantity,
      'dtquantity' => $dtqnt,
      'regby'      => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stock_info);  
    }

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
      <h4><i class="icon fa fa-check"></i> Sale product update Successfully !</h4></div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
      <h4><i class="icon fa fa-ban"></i> Failed !</h4></div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Sale');
}

public function delete_sales($id)
    {
    $where = array(
        'saleID' => $id
            );
    //var_dump($sale); exit();
    $result = $this->pm->delete_data('sales',$where);
    
    $pproduct = $this->pm->get_data('sale_product',$where);
    //var_dump($pproduct); exit();
    $result2 = $this->pm->delete_data('sale_product',$where);

  $length = count($pproduct);

  for($i = 0; $i < $length; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pproduct)
        {
        $tquantity = ($spd[0]['totalPices']+$pproduct[$i]['quantity']);
        $dtqnt = $spd[0]['dtquantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stock_info = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID'],
      'totalPices'  => $tquantity,
      'dtquantity'  => $dtqnt,
      'regby'   => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stock_info); 
    }
    
    if($result && $result2)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Sale product delete Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Sale');
}

public function new_damage_product_sale()
    {
    $data['title'] = 'Sale';
    
    $data['product'] = $this->pm->damage_product_data();

    $this->load->view('sale/damage_product_sale',$data);
}

public function damage_product_details($id)
  {
  $where = array(
    'productcode' => $id,
    'stock.dtquantity >' => 0
      );
  $other = array(
    'join' => 'left'
        );
  $field = array(
    'products' => 'products.*',
    'stock' => 'stock.dtquantity'
        );
  $join = array(
    'stock' => 'products.productID = stock.product'
        );

  $products = $this->pm->get_data('products',$where,$field,$join,$other);
  
  $str = '';
  foreach($products as $value)
    {
    $pid = $value['productID'];
    $tpq = $value['dtquantity'];
    $str.="<tr>
      <td>".$value['productName']."<input type='hidden' name='productID[]' value='".$value['productID']."' required ></td>
      <td>".$value['dtquantity']."</td>
      <td><input type='text' onkeyup='totalPrice(".$value['productID'].")' name='pices[]' id='pices_".$value['productID']."' value='0' max='$tpq' min='1'></td>
      <td><input type='text' onkeyup='totalPrice(".$value['productID'].")' name='salePrice[]' id='salePrice_".$value['productID']."' value='".$value['sprice']."'></td>
      <td><input type='text' class='totalPrice' name='totalPrice[]' readonly id='totalPrice_".$value['productID']."' value='0'></td>
      <td><span class='item_remove btn btn-danger' onClick='$(this).parent().parent().remove();' >x</span>
      </td>
      </tr>";
    }
    //var_dump($str); exit();
  echo json_encode($str);
}

public function saved_dproduct_sale()
    {
    $info = $this->input->post();

    $query = $this->db->select('saleID')
                  ->from('sales')
                  ->limit(1)
                  ->order_by('saleID','DESC')
                  ->get()
                  ->row();
    if($query)
        {
        $sn = $query->saleID+1;
        }
    else
        {
        $sn = 1;
        }
    $cn = strtoupper(substr($_SESSION['compname'],0,3));
    $pc = sprintf("%'05d", $sn);

    //$cusid = 'INV-'.$cn.$pc;
    $cusid = $pc;

    if($info['discounttype'] == '%')
        {
        $disa = ($info['totalprice']*$info['discountamount'])/100;
        }
    else{
        $disa = $info['discount'];
        }

    $sale = array(
        'compid'         => $_SESSION['compid'],
        'invoice_no'     => $cusid,
        'saleDate'       => date('Y-m-d', strtotime($info['date'])),
        'customerID'     => $info['customerID'],
        'totalAmount'    => $info['totalprice'],
        'paidAmount'     => $info['total_paid'],
        'dueamount'      => $info['due'],
        'discount'       => $info['discount'],             
        'discountType'   => $info['discounttype'],
        'discountAmount' => $disa,
        //'mamo'           => $info['mamo'],
        //'scost'          => $info['shiping_cost'],
        //'dOption'        => $info['dOption'],
        //'shmethod'       => $info['shmethod'],
        'accountType'    => $info['accountType'],
        'accountNo'      => $info['accountNo'],
        'note'           => $info['note'],
        'sstatus'        => 'Cash Sell',
        'ptype'          => 0,
        'regby'          => $_SESSION['uid']
            );
        //var_dump($sale); exit();
    $result = $this->pm->insert_data('sales',$sale);
       
    $length = count($info['productID']);

    for ($i = 0; $i < $length; $i++)
        {
        $spdata = array(
            'saleID'     => $result,
            'productID'  => $info['productID'][$i],                       
            'quantity'   => $info['pices'][$i],
            'sprice'     => $info['salePrice'][$i],
            'totalPrice' => $info['totalPrice'][$i],
            'regby'      => $_SESSION['uid']
                );

        $this->pm->insert_data('sale_product',$spdata);

        $pid = $info['productID'][$i];
        $aid = $_SESSION['compid'];

        $swhere = array(
            'compid'  => $_SESSION['compid'],
            'product' => $pid
                    );

        $stpd = $this->pm->get_data('stock',$swhere);

        $this->pm->delete_data('stock',$swhere);

        if($stpd)
            {
            $tquantity = $stpd[0]['totalPices'];
            $dtqnt = $stpd[0]['dtquantity']-$info['pices'];
            }
        else{
            $tquantity = 0;
            $dtqnt = '-'.$info['pices'];
            }

        $stock_info = array(
            'compid'     => $_SESSION['compid'],
            'product'    => $info['productID'][$i],
            'totalPices' => $tquantity,
            'dtquantity' => $dtqnt,
            'regby'      => $_SESSION['uid']
                    );
        //var_dump($stock_info);    
        $this->pm->insert_data('stock',$stock_info);  
        }
    
    $msg = "Dear Customer,"."\n"."Your order has been placed. Order value TK. ".$info['totalprice']."\n"."Helpline : 01981413970"."\n"."Style & Splash";
    
    $cust = $this->pm->get_customer_data($info['customerID']);

    $mob = '+88'.$cust->mobile;
    $token = urlencode("363e5be3-4832-4951-9287-dca28b860944");
    $message = urlencode($msg);
    $to = urlencode($mob);
   // $url = "https://smsplus.sslwireless.com/api/v3/send-sms?api_token=$token&sid=STYLESPLASHOTP&sms=$message&msisdn=$to&csms_id=1";
    
    // $data = array(
    //     'to'      => "$to",
    //     'message' => "$message",
    //     'token'   =>"$token"
    //       );
    //     //var_dump($data); exit();
    // $ch = curl_init();
    // curl_setopt($ch, CURLOPT_URL,$url);
    // curl_setopt($ch, CURLOPT_ENCODING,'');
    // curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // $smsresult = curl_exec($ch);
    
    if($result)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i> Damage Product Sale Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Sale');
}

public function edit_dproduct_sale($id)
    {
    $data['title'] = 'Sale';

    $where = array(
        'saleID' => $id
            );

    $prints = $this->pm->get_data('sales',$where);
    $data['sale'] = $prints[0];

    $other = array(
        'join' => 'left'
            );
    $pfield = array(
        'sale_product' => 'sale_product.*',
        'products' => 'products.productName,products.productcode'
            );
    $pjoin = array(
        'products' => 'products.productID = sale_product.productID'
            );

    $data['salesp'] = $this->pm->get_data('sale_product',$where,$pfield,$pjoin,$other);
    $data['product'] = $this->pm->damage_product_data();

    $this->load->view('sale/edit_dproduct_sale',$data);
}

public function update_dproduct_sale()
  {
  $info = $this->input->post();
  
  if($info['discounttype'] == '%')
    {
    $disa = ($info['totalprice']*$info['discountamount'])/100;
    }
  else
    {
    $disa = $info['discount'];
    }

  $sale = array(
    'compid'         => $_SESSION['compid'],
    'saleDate'       => date('Y-m-d', strtotime($info['date'])),
    'customerID'     => $info['customerID'],
    'totalAmount'    => $info['totalprice'],
    'paidAmount'     => $info['total_paid'],
    'dueamount'      => $info['totalprice']-$info['total_paid'],
    'discount'       => $info['discount'],             
    'discountType'   => $info['discounttype'],
    'discountAmount' => $disa,
    //'mamo'           => $info['mamo'],
    //'scost'          => $info['shiping_cost'],
    //'dOption'        => $info['dOption'],
    //'shmethod'       => $info['shmethod'],
    'accountType'    => $info['accountType'],
    'accountNo'      => $info['accountNo'],
    'note'           => $info['note'],             
    'upby'           => $_SESSION['uid']
            );

  $where = array(
    'saleID' => $info['saleID']
        );
    //var_dump($sale); exit();
  $result = $this->pm->update_data('sales',$sale,$where);
  $pp = $this->pm->get_data('sale_product',$where);
  $this->pm->delete_data('sale_product',$where);

  $lnth = count($pp);

  for($i = 0; $i < $lnth; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pp[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pp)
        {
        $tquantity = ($spd[0]['totalPices']);
        $dtqnt = $spd[0]['dtquantity']+$pp[$i]['quantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stockinfo = array(
      'compid'      => $_SESSION['compid'],
      'product'     => $pp[$i]['productID'],
      'totalPices'  => $tquantity,
      'dtquantity'  => $dtqnt,
      'regby'       => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stockinfo); 
    }

  $length = count($info['productID']);

  for ($i = 0; $i < $length; $i++)
    {
    $spdata = array(
      'saleID'     => $info['saleID'],
      'productID'  => $info['productID'][$i],                       
      'quantity'   => $info['pices'][$i],
      'sprice'     => $info['salePrice'][$i],
      'totalPrice' => $info['totalPrice'][$i],
      'upby'       => $_SESSION['uid']
            );

    $result2 = $this->pm->insert_data('sale_product',$spdata);

    $pid = $info['productID'][$i];
    $aid = $_SESSION['compid'];

    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pid
              );

    $stpd = $this->pm->get_data('stock',$swhere);
    $this->pm->delete_data('stock',$swhere);

    if($stpd)
      {
      $tquantity = $stpd[0]['totalPices'];
      $dtqnt = $stpd[0]['dtquantity']-$info['pices'][$i];
      }
    else
      {
      $tquantity = 0;
      $dtqnt = '-'.($info['pices'][$i]);
      }

    $stock_info = array(
      'compid'     => $_SESSION['compid'],
      'product'    => $info['productID'][$i],
      'totalPices' => $tquantity,
      'dtquantity' => $dtqnt,
      'regby'      => $_SESSION['uid']
              );
      //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stock_info);  
    }

  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
      <h4><i class="icon fa fa-check"></i> Sale Damage product update Successfully !</h4></div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
      <h4><i class="icon fa fa-ban"></i> Failed !</h4></div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Sale');
}

public function delete_dproduct_sales($id)
    {
    $where = array(
        'saleID' => $id
            );
    //var_dump($sale); exit();
    $result = $this->pm->delete_data('sales',$where);
    
    $pproduct = $this->pm->get_data('sale_product',$where);
    //var_dump($pproduct); exit();
    $result2 = $this->pm->delete_data('sale_product',$where);

  $length = count($pproduct);

  for($i = 0; $i < $length; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pproduct)
        {
        $tquantity = ($spd[0]['totalPices']);
        $dtqnt = $spd[0]['dtquantity']+$pproduct[$i]['quantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stock_info = array(
      'compid'      => $_SESSION['compid'],
      'product'     => $pproduct[$i]['productID'],
      'totalPices'  => $tquantity,
      'dtquantity'  => $dtqnt,
      'regby'       => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stock_info); 
    }
    
    if($result && $result2)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-check"></i> Sale product delete Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Sale');
}

public function all_sales_reports()
    {
    $data['title'] = 'Sales Report';

    $where = array(
        'compid' => $_SESSION['compid'],
            );
    $data['customer'] = $this->pm->get_data('customers',$where);
    $data['employee'] = $this->pm->get_data('users',$where);
    $data['company'] = $this->pm->get_data('com_profile',false);

    if(isset($_GET['search']))
        {
        $report = $_GET['reports'];
        
        if($report == 'dailyReports')
            {
            $sdate = date("Y-m-d", strtotime($_GET['sdate']));
            $edate = date("Y-m-d", strtotime($_GET['edate']));
            $customer = $_GET['dcustomer'];
            $employee = $_GET['demployee'];
            $compid = $_GET['dsmethod'];
            $data['sdate'] = $sdate;
            $data['edate'] = $edate;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;
            //var_dump($employee); exit();
            $data['sales'] = $this->pm->get_dsales_data($sdate,$edate,$customer,$employee,$compid);
            }
        else if ($report == 'monthlyReports')
            {
            $month = $_GET['month'];
            $data['month'] = $month;
            $year = $_GET['year'];
            $data['year'] = $year;
            //var_dump($data['month']); exit();
            if($month == 01)
                {
                $name = 'January';
                }
            elseif ($month == 02)
                {
                $name = 'February';
                }
            elseif ($month == 03)
                {
                $name = 'March';
                }
            elseif ($month == 04)
                {
                $name = 'April';
                }
            elseif ($month == 05)
                {
                $name = 'May';
                }
            elseif ($month == 06)
                {
                $name = 'June';
                }
            elseif ($month == 07)
                {
                $name = 'July';
                }
            elseif ($month == 8)
                {
                $name = 'August';
                }
            elseif ($month == 9)
                {
                $name = 'September';
                }
            elseif ($month == 10)
                {
                $name = 'October';
                }
            elseif ($month == 11)
                {
                $name = 'November';
                }
            else
                {
                $name = 'December';
                }
            $customer = $_GET['mcustomer'];
            $employee = $_GET['memployee'];
            $compid = $_GET['msmethod'];
            $data['name'] = $name;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;

            $data['sales'] = $this->pm->get_msales_data($month,$year,$customer,$employee,$compid);
            }
        else if ($report == 'yearlyReports')
            {
            $year = $_GET['ryear'];
            $customer = $_GET['mcustomer'];
            $employee = $_GET['memployee'];
            $compid = $_GET['ysmethod'];
            $data['year'] = $year;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;

            $data['sales'] = $this->pm->get_ysales_data($year,$customer,$employee,$compid);
            }
        }
    else
        {
        $data['sales'] = $this->pm->get_sales_data();
        }

    $this->load->view('sale/all_sales',$data);
}
public function all_balance_reports()
    {
    $data['title'] = 'Balance Sheet';

    $where = array(
        'compid' => $_SESSION['compid'],
            );
            
    $data['customers'] = $this->pm->get_data('customers',$where);
    $data['employees'] = $this->pm->get_data('users',$where);
    $data['company'] = $this->pm->get_data('com_profile',false);
    $data['cash'] = $this->pm->get_data('cash',$where);
    $data['cih'] = $this->pm->total_cash_in_hand();
    $data['stock'] = $this->pm->get_product_stock_data();
    $data['bank'] = $this->pm->get_data('bankaccount',$where);
    $data['supplier'] = $this->pm->get_data('suppliers',$where);
    $data['dvoucher'] = $this->pm->get_dvoucher_data();
    $data['cvoucher'] = $this->pm->get_cvoucher_data();
    $data['svoucher'] = $this->pm->get_cvoucher_data();
    $data['receivable'] = $this->pm->total_receivable();
    $data['expense'] = $this->pm->get_cost_report_data();
    $voucher = $this->pm->get_data('vaucher',$where);
    

    if(isset($_GET['search']))
        {
        $report = $_GET['reports'];
        
        if($report == 'dailyReports')
         
            {
            $sdate = date("Y-m-d", strtotime($_GET['sdate']));
            $edate = date("Y-m-d", strtotime($_GET['edate']));
            $customer = $_GET['dcustomer'];
            $employee = $_GET['demployee'];
            $compid = $_GET['dsmethod'];
            $data['sdate'] = $sdate;
            $data['edate'] = $edate;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;
            //var_dump($employee); exit();
            $data['sales'] = $this->pm->get_dsales_data($sdate,$edate,$customer,$employee,$compid);
            }
        else if ($report == 'monthlyReports')
            {
            $month = $_GET['month'];
            $data['month'] = $month;
            $year = $_GET['year'];
            $data['year'] = $year;
            //var_dump($data['month']); exit();
            if($month == 01)
                {
                $name = 'January';
                }
            elseif ($month == 02)
                {
                $name = 'February';
                }
            elseif ($month == 03)
                {
                $name = 'March';
                }
            elseif ($month == 04)
                {
                $name = 'April';
                }
            elseif ($month == 05)
                {
                $name = 'May';
                }
            elseif ($month == 06)
                {
                $name = 'June';
                }
            elseif ($month == 07)
                {
                $name = 'July';
                }
            elseif ($month == 8)
                {
                $name = 'August';
                }
            elseif ($month == 9)
                {
                $name = 'September';
                }
            elseif ($month == 10)
                {
                $name = 'October';
                }
            elseif ($month == 11)
                {
                $name = 'November';
                }
            else
                {
                $name = 'December';
                }
            $customer = $_GET['mcustomer'];
            $employee = $_GET['memployee'];
            $compid = $_GET['msmethod'];
            $data['name'] = $name;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;

            $data['sales'] = $this->pm->get_msales_data($month,$year,$customer,$employee,$compid);
            }
        else if ($report == 'yearlyReports')
            {
            $year = $_GET['ryear'];
            $customer = $_GET['ycustomer'];
            $employee = $_GET['yemployee'];
            $compid = $_GET['ysmethod'];
            $data['year'] = $year;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;

            $data['sales'] = $this->pm->get_ysales_data($year,$customer,$employee,$compid);
            }
        }
    else
        {
        $data['sales'] = $this->pm->get_sales_data();
        }

    $this->load->view('sale/all_balance_reports',$data);
}


public function get_sales_payment()
    {
    $section = $this->pm->get_sales_payment($_POST['id']);
    $data = json_encode($section);
    echo $data;
}

public function save_sales_payment()
    {
    $info = $this->input->post();
    
    $sale = [
        'saleID' => $info['saleID'],
        'amount' => $info['amount'],
        'regby'  => $_SESSION['uid']
            ];
    //var_dump($sale); exit();
    $result = $this->pm->insert_data('sales_payment',$sale);

    $where = array(
        'saleID' => $info['saleID']
                );

    $data = [
        'paidAmount' => $info['amount']+$info['pamount'],
        'dueamount'  => $info['damount']-$info['amount'],
        'upby'       => $_SESSION['uid']
            ];
       
    $result2 = $this->pm->update_data('sales',$data,$where);
    //var_dump($cust); exit();
    
    if($result)
        {
        // $msg = "Dear Client,"."\n".
        //         "Your Recent Invoice No:".$cusid."\n".
        //         "Dated: ".date('Y-m-d', strtotime($info['date']))."\n".
        //         "Invoice Amount: BDT ".$info['totalprice']."\n".
        //         "Your Outstanding: BDT ".$info['due']."\n".
        //         "Thanking you,\n METLER CORPORATION";
    
        // $cust = $this->pm->get_customer_data($info['customerID']);
    
        // $mob = '+88'.$cust->mobile;
        // $token = urlencode("2ngn1tqt-mi6kusln-vavoodmv-blsb9va2-6cwufe4w");
        // $message = urlencode($msg);
        // $to = urlencode($mob);
        // $url = "https://smsplus.sslwireless.com/api/v3/send-sms?api_token=$token&sid=METLERNONBRAND&sms=$message&msisdn=$to&csms_id=1";
        
        // $data = array(
        //     'to'      => "$to",
        //     'message' => "$message",
        //     'token'   =>"$token"
        //       );
        //     //var_dump($data); exit();
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL,$url);
        // curl_setopt($ch, CURLOPT_ENCODING,'');
        // curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $smsresult = curl_exec($ch);
        // // var_dump($smsresult);die;
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Sale Payment add Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Sale');
}

public function sales_export_action()
  {
  $this->load->library("excel");
  $object = new PHPExcel();

  $object->setActiveSheetIndex(0);

  $table_columns = array("Invoice No.","Customer","Contact Number","Address","District","Area","Area ID","Division","Cash","Note","Seller Name","Seller Mobile");

  $column = 0;

  foreach($table_columns as $field)
    {
    $object->getActiveSheet()->setCellValueByColumnAndRow($column,1,$field);
    $column++;
    }

  $customer_data = $this->pm->get_sales_data();
    //var_dump($customer_data); exit();
  $excel_row = 2;

  foreach($customer_data as $row)
    {
    $mob = strtoupper(substr($row->umobile,3,11));
    
    $object->getActiveSheet()->setCellValueByColumnAndRow(0,$excel_row,$row->invoice_no);
    $object->getActiveSheet()->setCellValueByColumnAndRow(1,$excel_row,$row->customerName);
    $object->getActiveSheet()->setCellValueByColumnAndRow(2,$excel_row,$row->mobile);
    $object->getActiveSheet()->setCellValueByColumnAndRow(3,$excel_row,$row->address);
    $object->getActiveSheet()->setCellValueByColumnAndRow(8,$excel_row,$row->totalAmount);
    $object->getActiveSheet()->setCellValueByColumnAndRow(9,$excel_row,$row->note);
    $object->getActiveSheet()->setCellValueByColumnAndRow(10,$excel_row,$row->name);
    $object->getActiveSheet()->setCellValueByColumnAndRow(11,$excel_row,$mob);
    $excel_row++;
    }

  $object_writer = PHPExcel_IOFactory::createWriter($object,'Excel2007');
  header('Content-Type: application/vnd.ms-excel');
  header('Content-Disposition: attachment;filename="sales.xls"');
  ob_end_clean();
  $object_writer->save('php://output');
}

public function sales_dexport_action($sdate,$edate,$customer,$employee,$smethod)
  {
  $this->load->library("excel");
  $object = new PHPExcel();

  $object->setActiveSheetIndex(0);

  $table_columns = array("Invoice No.","Customer","Contact Number","Address","Total Amounr","Note","Seller Name","Seller Mobile");

  $column = 0;

  foreach($table_columns as $field)
    {
    $object->getActiveSheet()->setCellValueByColumnAndRow($column,1,$field);
    $column++;
    }

  $customer_data = $this->pm->get_dsales_data($sdate,$edate,$customer,$employee,$smethod);
    //var_dump($customer_data); exit();
  $excel_row = 2;

  foreach($customer_data as $row)
    {
    $mob = strtoupper(substr($row->umobile,3,11));
    
    $object->getActiveSheet()->setCellValueByColumnAndRow(0,$excel_row,$row->invoice_no);
    $object->getActiveSheet()->setCellValueByColumnAndRow(1,$excel_row,$row->customerName);
    $object->getActiveSheet()->setCellValueByColumnAndRow(2,$excel_row,$row->mobile);
    $object->getActiveSheet()->setCellValueByColumnAndRow(3,$excel_row,$row->address);
    $object->getActiveSheet()->setCellValueByColumnAndRow(4,$excel_row,$row->totalAmount);
    $object->getActiveSheet()->setCellValueByColumnAndRow(5,$excel_row,$row->note);
    $object->getActiveSheet()->setCellValueByColumnAndRow(6,$excel_row,$row->name);
    $object->getActiveSheet()->setCellValueByColumnAndRow(7,$excel_row,$mob);
    $excel_row++;
    }

  $object_writer = PHPExcel_IOFactory::createWriter($object,'Excel2007');
  header('Content-Type: application/vnd.ms-excel');
  header('Content-Disposition: attachment;filename="sales.xls"');
  ob_end_clean();
  $object_writer->save('php://output');
}

public function sales_mexport_action($month,$year,$customer,$employee,$smethod)
  {
  $this->load->library("excel");
  $object = new PHPExcel();

  $object->setActiveSheetIndex(0);

  $table_columns = array("Invoice No.","Customer","Contact Number","Address","Total Amounr","Note","Seller Name","Seller Mobile");

  $column = 0;

  foreach($table_columns as $field)
    {
    $object->getActiveSheet()->setCellValueByColumnAndRow($column,1,$field);
    $column++;
    }

  $customer_data = $this->pm->get_msales_data($month,$year,$customer,$employee,$smethod);
    //var_dump($customer_data); exit();
  $excel_row = 2;

  foreach($customer_data as $row)
    {
    $mob = strtoupper(substr($row->umobile,3,11));
    
    $object->getActiveSheet()->setCellValueByColumnAndRow(0,$excel_row,$row->invoice_no);
    $object->getActiveSheet()->setCellValueByColumnAndRow(1,$excel_row,$row->customerName);
    $object->getActiveSheet()->setCellValueByColumnAndRow(2,$excel_row,$row->mobile);
    $object->getActiveSheet()->setCellValueByColumnAndRow(3,$excel_row,$row->address);
    $object->getActiveSheet()->setCellValueByColumnAndRow(4,$excel_row,$row->totalAmount);
    $object->getActiveSheet()->setCellValueByColumnAndRow(5,$excel_row,$row->note);
    $object->getActiveSheet()->setCellValueByColumnAndRow(6,$excel_row,$row->name);
    $object->getActiveSheet()->setCellValueByColumnAndRow(7,$excel_row,$mob);
    $excel_row++;
    }

  $object_writer = PHPExcel_IOFactory::createWriter($object,'Excel2007');
  header('Content-Type: application/vnd.ms-excel');
  header('Content-Disposition: attachment;filename="sales.xls"');
  ob_end_clean();
  $object_writer->save('php://output');
}

public function sales_yexport_action($year,$customer,$employee,$smethod)
  {
  $this->load->library("excel");
  $object = new PHPExcel();

  $object->setActiveSheetIndex(0);

  $table_columns = array("Invoice No.","Customer","Contact Number","Address","Total Amounr","Note","Seller Name","Seller Mobile");

  $column = 0;

  foreach($table_columns as $field)
    {
    $object->getActiveSheet()->setCellValueByColumnAndRow($column,1,$field);
    $column++;
    }

  $customer_data = $this->pm->get_ysales_data($year,$customer,$employee,$smethod);
    //var_dump($customer_data); exit();
  $excel_row = 2;

  foreach($customer_data as $row)
    {
    $mob = strtoupper(substr($row->umobile,3,11));
    
    $object->getActiveSheet()->setCellValueByColumnAndRow(0,$excel_row,$row->invoice_no);
    $object->getActiveSheet()->setCellValueByColumnAndRow(1,$excel_row,$row->customerName);
    $object->getActiveSheet()->setCellValueByColumnAndRow(2,$excel_row,$row->mobile);
    $object->getActiveSheet()->setCellValueByColumnAndRow(3,$excel_row,$row->address);
    $object->getActiveSheet()->setCellValueByColumnAndRow(4,$excel_row,$row->totalAmount);
    $object->getActiveSheet()->setCellValueByColumnAndRow(5,$excel_row,$row->note);
    $object->getActiveSheet()->setCellValueByColumnAndRow(6,$excel_row,$row->name);
    $object->getActiveSheet()->setCellValueByColumnAndRow(7,$excel_row,$mob);
    $excel_row++;
    }

  $object_writer = PHPExcel_IOFactory::createWriter($object,'Excel2007');
  header('Content-Type: application/vnd.ms-excel');
  header('Content-Disposition: attachment;filename="sales.xls"');
  ob_end_clean();
  $object_writer->save('php://output');
}

public function sales_invoice_reports()
    {
    $data['title'] = 'Sales Report';


    if(isset($_GET['search']))
        {
        $report = $_GET['reports'];
        
        if($report == 'dailyReports')
            {
            $sdate = date("Y-m-d", strtotime($_GET['sdate']));
            $edate = date("Y-m-d", strtotime($_GET['edate']));
            $data['sdate'] = $sdate;
            $data['edate'] = $edate;
            $data['report'] = $report;
            //var_dump($employee); exit();
            $data['sales'] = $this->pm->sales_ddata($sdate,$edate);
            }
        else if ($report == 'monthlyReports')
            {
            $month = $_GET['month'];
            $data['month'] = $month;
            $year = $_GET['year'];
            $data['year'] = $year;
            //var_dump($data['month']); exit();
            if($month == 01)
                {
                $name = 'January';
                }
            elseif ($month == 02)
                {
                $name = 'February';
                }
            elseif ($month == 03)
                {
                $name = 'March';
                }
            elseif ($month == 04)
                {
                $name = 'April';
                }
            elseif ($month == 05)
                {
                $name = 'May';
                }
            elseif ($month == 06)
                {
                $name = 'June';
                }
            elseif ($month == 07)
                {
                $name = 'July';
                }
            elseif ($month == 8)
                {
                $name = 'August';
                }
            elseif ($month == 9)
                {
                $name = 'September';
                }
            elseif ($month == 10)
                {
                $name = 'October';
                }
            elseif ($month == 11)
                {
                $name = 'November';
                }
            else
                {
                $name = 'December';
                }
            $data['name'] = $name;
            $data['report'] = $report;

            $data['sales'] = $this->pm->sales_mdata($month,$year);
            }
        else if ($report == 'yearlyReports')
            {
            $year = $_GET['ryear'];
            $data['year'] = $year;
            $data['report'] = $report;

            $data['sales'] = $this->pm->sales_ydata($year);
            }
        }
    else
        {
        $data['sales'] = $this->pm->sales_adata();
        }
    
    $data['company'] = $this->pm->company_details();

    $this->load->view('sale/sales_ireport',$data);
}

public function sales_due_reports()
    {
    $data['title'] = 'Due Report';

    $data['customer'] = $this->pm->get_data('customers',false);
    
    $data['company'] = $this->pm->company_details();

    $this->load->view('sale/sales_dreport',$data);
}

public function saved_customer()
    {
    $info = $this->input->post();
    
    $query = $this->db->select('customerID')
                  ->from('customers')
                  ->where('compid',$_SESSION['compid'])
                  ->limit(1)
                  ->order_by('customerID','DESC')
                  ->get()
                  ->row();
    if ($query)
        {
        $sn = $query->customerID+1;
        }
    else
        {
        $sn = 1;
        }

    $cn = strtoupper(substr($_SESSION['compname'],0,3));
    $pc = sprintf("%'05d",$sn);

    $cusid = 'C-'.$cn.$pc;

    $data = array(
        'compid'       => $_SESSION['compid'],
        'cus_id'       => $cusid,
        'customerName' => $info['customerName'],
        'mobile'       => $info['mobile'],
        'email'        => $info['email'],
        'address'      => $info['address'],
        'balance'      => $info['balance'],         
        'regby'        => $_SESSION['uid']
            );

    $result = $this->pm->insert_data('customers',$data);

    if($result)
        {
        echo "";
        }
    else{
         $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
           <h4><i class="icon fa fa-ban"></i> Failed !</h4></div>'
                ];
        $this->session->set_userdata($sdata);
        }
    redirect('newSale');
}



public function sales_due_payment_reports()
    {
    $data['title'] = 'Due Payment Report';


    if(isset($_GET['search']))
        {
        $report = $_GET['reports'];
        
        if($report == 'dailyReports')
            {
            $sdate = date("Y-m-d", strtotime($_GET['sdate']));
            $edate = date("Y-m-d", strtotime($_GET['edate']));
            $data['sdate'] = $sdate;
            $data['edate'] = $edate;
            $data['report'] = $report;
            //var_dump($employee); exit();
            $data['sales'] = $this->pm->sales_due_dpayment_data($sdate,$edate);
            }
        else if ($report == 'monthlyReports')
            {
            $month = $_GET['month'];
            $data['month'] = $month;
            $year = $_GET['year'];
            $data['year'] = $year;
            //var_dump($data['month']); exit();
            if($month == 01)
                {
                $name = 'January';
                }
            elseif ($month == 02)
                {
                $name = 'February';
                }
            elseif ($month == 03)
                {
                $name = 'March';
                }
            elseif ($month == 04)
                {
                $name = 'April';
                }
            elseif ($month == 05)
                {
                $name = 'May';
                }
            elseif ($month == 06)
                {
                $name = 'June';
                }
            elseif ($month == 07)
                {
                $name = 'July';
                }
            elseif ($month == 8)
                {
                $name = 'August';
                }
            elseif ($month == 9)
                {
                $name = 'September';
                }
            elseif ($month == 10)
                {
                $name = 'October';
                }
            elseif ($month == 11)
                {
                $name = 'November';
                }
            else
                {
                $name = 'December';
                }
            $data['name'] = $name;
            $data['report'] = $report;

            $data['sales'] = $this->pm->sales_due_mpayment_data($month,$year);
            }
        else if ($report == 'yearlyReports')
            {
            $year = $_GET['ryear'];
            $data['year'] = $year;
            $data['report'] = $report;

            $data['sales'] = $this->pm->sales_due_ypayment_data($year);
            }
        }
    else
        {
        $data['sales'] = $this->pm->sales_due_payment_data();
        }
    
    $data['company'] = $this->pm->company_details();

    $this->load->view('sale/due_payment_report',$data);
}


public function installment_sales_list()
    {
    $data['title'] = 'Sale';
    
    $where = array(
        'sales.sType' => 2
            );
    $other = array(
        'join' => 'left',
        'order_by' => 'saleID'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.customerName,customers.mobile'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID'
            );
    $data['sales'] = $this->pm->get_data('sales',$where,$field,$join,$other);

    $this->load->view('sale/installment_sales',$data);
}

public function get_sales_emi_payment()
    {
    $section = $this->pm->get_sales_emi_payment($_POST['id']);
    $data = json_encode($section);
    echo $data;
}

public function save_sales_emi_payment()
    {
    $info = $this->input->post();

    $sale = [
        'saleID' => $info['saleID'],
        'nEmi'   => $info['paidEmi'],  
        'pEmi'   => $info['payAmount'],            
        'regby'  => $_SESSION['uid']
            ];
    //var_dump($sale); exit();
    $result = $this->pm->insert_data('sales_emi',$sale);

    $where = array(
        'saleID' => $info['saleID']
                );

    $data = [
        'pEmi'       => $info['paidEmi']+$info['pEmi'],
        'paidAmount' => $info['pAmount']+$info['payAmount'],
        'dueamount'  => $info['dAmount']-$info['payAmount'],
        'upby'       => $_SESSION['uid']
            ];
       
    $result2 = $this->pm->update_data('sales',$data,$where);
    
    $cust = $this->pm->get_sales_customer_data($info['saleID']);
    //var_dump($cust);
    if($cust)
        {
        $message = "Your sales Installment Payment is Success";

        $mob = urlencode($cust->mobile);
        $token = urlencode("b4b48850ad9acb9844796ce6bf7a5355");
        //$message = urlencode($msg);
        $to = urlencode($mob);
        $url = "http://api.greenweb.com.bd/api.php";
        
        $data = array(
            'to'      => "$to",
            'message' => "$message",
            'token'   =>"$token"
              );
            //var_dump($data); exit();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_ENCODING,'');
        curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $smsresult = curl_exec($ch);
        }
    if($result)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i> Sale EMI Payment add Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('emiSale');
}

public function view_installment_sales_payment($id)
    {
    $data['title'] = 'Payment';

    $where = array(
        'saleID' => $id
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.*'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID'
            );
    $prints = $this->pm->get_data('sales',$where,$field,$join,$other);
    $data['prints'] = $prints[0];
    
    $data['semip'] = $this->pm->get_data('sales_emi',$where);
    //var_dump($prints); var_dump($data['semip']); exit();
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('sale/print_emi_page',$data);
}

public function today_sales_reports()
    {
    $data['title'] = 'Sales Report';

    $where = array(
        'compid' => $_SESSION['compid'],
            );
    $data['customer'] = $this->pm->get_data('customers',$where);
    $data['employee'] = $this->pm->get_data('users',$where);

   
    $sdate = date('Y-m-d');
    $edate = date('Y-m-d');
    $customer = 'All';
    $employee = 'All';
    $smethod = 'All';
    $data['sdate'] = $sdate;
    $data['edate'] = $edate;
    $data['report'] = 'dailyReports';
    $data['customer'] = $customer;
    $data['employee'] = $employee;
    $data['smethod'] = $smethod;
    //var_dump($employee); exit();
    $data['sales'] = $this->pm->get_dsales_data($sdate,$edate,$customer,$employee,$smethod);

    $this->load->view('sale/all_sales',$data);
}

public function generate_invoice($invoice_id) {
    // Fetch your data (replace this with actual data fetching logic)
    $data = $this->fetch_invoice_data($invoice_id);

    // Load the view and generate HTML
    $html = $this->load->view('invoice_template', $data, TRUE);

    // Generate the PDF and get the filename
    $filename = $this->dompdf_generator->generate($html, 'invoice_' . $invoice_id . '.pdf');

    // Provide a download link or redirect as needed
    $this->load->helper('url');
    redirect('uploads/invoices/' . $filename);
}




}