<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Receipt extends CI_Controller {

public function __construct() {
    parent::__construct();
    $this->load->model("prime_model","pm");
    $this->checkPermission();
    $this->load->library('PHPExcel');
    $this->load->library('excel');
}

public function index()
    {
    $data['title'] = 'Receipt';
    
    $other = array(
        'join' => 'left',
        'order_by' => 'sp_id'
            );
    $field = array(
        'sales_payment' => 'sales_payment.*',
        'customers' => 'customers.customerName'
            );
    $join = array(
        'customers' => 'customers.customerID = sales_payment.customerID'
            );

    $data['sales'] = $this->pm->get_data('sales_payment',false,$field,$join,$other);
    // $data['sales'] = $this->pm->get_data('sales_payment',false);

    $this->load->view('receipt/receipt_list',$data);
}

public function new_receipt()
    {
    $data['title'] = 'Receipt';
    
    $other = array(
        'join' => 'left',
        'order_by' => 'saleID'
            );
    $field = array(
        'sales' => 'sales.*',
        'customers' => 'customers.customerName,customers.mobile'
            );
    $join = array(
        'customers' => 'customers.customerID = sales.customerID'
            );
    
  if($_SESSION['role'] > 2)
    {
    $where = array(
      'sales.compid' => $_SESSION['compid']
            );
            
    $data['sales'] = $this->pm->get_data('sales',$where,$field,$join,$other);
    }
  else
    {
    $data['sales'] = $this->pm->get_data('sales',false,$field,$join,$other);
    }

    $data['customer'] = $this->pm->get_data('customers',false);
    $data['product'] = $this->pm->get_data('products',false);

    $this->load->view('receipt/NewReceipt',$data);
}

public function get_receipt_details()
    {
    $section = $this->pm->get_receipt_details($_POST['id']);
    $data = json_encode($section);
    echo $data;
}
public function get_payment_details()
    {
    $section = $this->pm->get_payment_details($_POST['id']);
    $data = json_encode($section);
    echo $data;
}

public function get_sale_customer()
    {
    $other = array(
        'order_by' => 'customerID'
            );
    $where = $_SESSION['compid'];
    $section = $this->pm->get_data_with_due($where);
    $someJSON = json_encode($section);
    echo $someJSON;
}

public function save_paid() {        
    $info = $this->input->post();

    $length = count($info['checkbox']);
    
    $query = $this->db->select('sp_id')
                      ->from('sales_payment')
                      ->limit(1)
                      ->order_by('sp_id','DESC')
                      ->get()
                      ->row();
    $sn = $query ? $query->sp_id + 1 : 1;

    $cn = strtoupper(substr($_SESSION['compname'],0,3));
    $pc = sprintf("%'05d", $sn);
    $cusid = 'REC-'.$cn.$pc;
    
    $rData = array(
        'rec_code'    => $cusid,
        'recDate'     => date('Y-m-d', strtotime($info['date'])),
        'amount'      => $info['amount'],  // Subtract only what's due for the current invoice
        'customerID'  => $info['customerID'],
        'remarks'     => $info['remarks'],
        'accountType' => $info['accountType'],
        'accountNo'   => $info['accountNo'],
        'regby'       => $_SESSION['uid']
    );
    
    // var_dump($rData);die;

    $result = $this->pm->insert_data('sales_payment', $rData);
    
    $remainingPayment = floatval(str_replace(',', '', $info['amount'])); // The total amount paid
    
    for($i = 0; $i < $length; $i++) {
        // Get the sales payment ID
        
        $where = array('saleID' => $info['checkbox'][$i]);
        $shistory = $this->db->select('paidAmount, dueamount')->from('sales')->where('saleID', $info['checkbox'][$i])->get()->row();
        
        // Convert string values to float to avoid issues with calculations
        $paidAmount = floatval($shistory->paidAmount);
        $dueAmount = floatval($shistory->dueamount);

        // Make sure we subtract the due amount specific to the invoice and not total
        $paidForInvoice = min($dueAmount, $remainingPayment);
        
        $emps = array(
            'sp_id'      => $result,
            'saleID'      => $info['checkbox'][$i],
            'paidAmount'      => $paidForInvoice,  // Subtract only what's due for the current invoice
            'regby'       => $_SESSION['uid']
        );

        $result2 = $this->pm->insert_data('sales_payment_details', $emps);
        
        // Update the sales record with the newly paid amount and remaining due
        $data = [
            'paidAmount' => $shistory->paidAmount + $paidForInvoice,
            'dueamount'  => $shistory->dueamount - $paidForInvoice,  // Deduct from each invoice accordingly
            'upby'       => $_SESSION['uid']
        ];

        $result3 = $this->pm->update_data('sales', $data, $where);
        
        // Subtract the amount paid for this invoice from the remaining payment
        $remainingPayment -= $paidForInvoice;
    
        // Break if there is no remaining payment left to distribute
        if ($remainingPayment <= 0) {
            break;
        }
    }
    // die;

    // Handle success or failure notifications
    if ($result) {
        if ($info['accountType'] == 'Cash') {
            $text = 'Cash';
        } elseif ($info['accountType'] == 'Bank') {
            $acName = $this->db->select('bankName')
                               ->from('bankaccount')
                               ->where('ba_id', $info['accountNo'])
                               ->get()
                               ->row();
            $text = $acName->bankName;
        } elseif ($info['accountType'] == 'Mobile') {
            $acName = $this->db->select('accountName')
                               ->from('mobileaccount')
                               ->where('ma_id', $info['accountNo'])
                               ->get()
                               ->row();
            $text = $acName->accountName;
        } else {
            $text = '';
        }

        $msg = "Dear Client,\nWe've received by $text\nBDT " . number_format($info['amount'], 2) . "\nDated: " . date('j F, Y', strtotime($info['date'])) . "\nYour Outstanding: BDT " . number_format($info['remains'], 2) . "\n\nThanking you,\nMETLER CORPORATION";

        $cust = $this->pm->get_customer_data($info['customerID']);
        $mob = '+88'.$cust->mobile;
        $token = urlencode("2ngn1tqt-mi6kusln-vavoodmv-blsb9va2-6cwufe4w");
        $message = urlencode($msg);
        $to = urlencode($mob);
        $url = "https://smsplus.sslwireless.com/api/v3/send-sms?api_token=$token&sid=METLERNONBRAND&sms=$message&msisdn=$to&csms_id=1";

        $data = array(
            'to'      => "$to",
            'message' => "$message",
            'token'   => "$token"
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $smsresult = curl_exec($ch);

        $sdata = [
            'exception' => '<div class="alert alert-success alert-dismissible">
                <h4><i class="icon fa fa-check"></i> Sale Payments added Successfully !</h4>
            </div>'
        ];
    } else {
        $sdata = [
            'exception' => '<div class="alert alert-danger alert-dismissible">
                <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
        ];
    }

    $this->session->set_userdata($sdata);
    redirect('Receipt');
}


public function view_invoice($id)
    {
    $data['title'] = 'Receipt Invoice';

    $where = array(
        'sp_id' => $id
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'sales_payment' => 'sales_payment.*',
        'customers' => 'customers.customerName, customers.mobile, customers.address',
            );
    $join = array(
        'customers' => 'customers.customerID = sales_payment.customerID',
            );
    $prints = $this->pm->get_data('sales_payment',$where,$field,$join,$other);
    $data['prints'] = $prints[0];

    $pfield = array(
        'sales_payment_details' => 'sales_payment_details.*',
        'sales' => 'sales.invoice_no, sales.totalAmount, sales.dueamount, sales.paidAmount',
            );
    $pjoin = array(
        'sales' => 'sales.saleID = sales_payment_details.saleID'
            );

    $data['salesp'] = $this->pm->get_data('sales_payment_details',$where,$pfield,$pjoin,$other);
    
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('receipt/print_page',$data);
}

public function edit_receipt($id)
    {
    $data['title'] = 'Update Receipt';

    $where = array(
        'sp_id' => $id
            );

    $prints = $this->pm->get_data('sales_payment',$where);
    $data['sale'] = $prints[0];

    $other = array(
        'join' => 'left'
            );
    $pfield = array(
        'sales_payment_details' => 'sales_payment_details.*',
        'sales' => 'sales.invoice_no,sales.totalAmount, sales.paidAmount, sales.dueamount'
            );
    $pjoin = array(
        'sales' => 'sales.saleID = sales_payment_details.saleID'
            );

    $data['salesp'] = $this->pm->get_data('sales_payment_details',$where,$pfield,$pjoin,$other);
    $cwhere = array(
        'compid' => $_SESSION['compid']
            );
    $where = $_SESSION['compid'];
    // $data['customer'] = $this->pm->get_data_with_due($where);
    // $data['product'] = $this->pm->get_data('products',$cwhere);

    $this->load->view('receipt/EditReceipt',$data);
}

public function delete_receipt($sp_id) {
    // Fetch the payment details to retrieve related invoices and amounts
    $payment_details = $this->db->select('saleID, paidAmount')
                                ->from('sales_payment_details')
                                ->where('sp_id', $sp_id)
                                ->get()
                                ->result();
    
    // Reverse each payment's effect on the corresponding sales record
    foreach ($payment_details as $detail) {
        $saleID = $detail->saleID;
        
        // Get the original sales record to update it
        $sale_record = $this->db->select('paidAmount, dueamount')
                                ->from('sales')
                                ->where('saleID', $saleID)
                                ->get()
                                ->row();

        // Reverse the payment by subtracting the paidAmount from paidAmount and adding it back to dueamount
        $updated_sales_data = [
            'paidAmount' => $sale_record->paidAmount - $detail->paidAmount,
            'dueamount'  => $sale_record->dueamount + $detail->paidAmount,
            'upby'       => $_SESSION['uid']
        ];

        // Update the sales table
        $this->pm->update_data('sales', $updated_sales_data, ['saleID' => $saleID]);
    }

    // Delete payment details from `sales_payment_details`
    $this->db->where('sp_id', $sp_id);
    $this->db->delete('sales_payment_details');

    // Delete the main payment record from `sales_payment`
    $this->db->where('sp_id', $sp_id);
    $delete_result = $this->db->delete('sales_payment');

    // Set a success or failure message for feedback
    if ($delete_result) {
        $sdata = [
            'exception' => '<div class="alert alert-success alert-dismissible">
                <h4><i class="icon fa fa-check"></i> Sale Payment deleted successfully!</h4>
            </div>'
        ];
    } else {
        $sdata = [
            'exception' => '<div class="alert alert-danger alert-dismissible">
                <h4><i class="icon fa fa-ban"></i> Deletion failed!</h4>
            </div>'
        ];
    }

    // Set the session message and redirect back to the Receipt page
    $this->session->set_userdata($sdata);
    redirect('Receipt');
}


public function cust_all_invoices()
    {
    $data['title'] = 'Receipt';

    $where = array(
        'compid' => $_SESSION['compid'],
            );
            
    $data['company'] = $this->pm->get_data('com_profile',false);

    if(isset($_GET['search']))
        {
        $cust = $_GET['customerID'];
        // var_dump($cust);die;
        $data['dueinv'] = $this->pm->get_due_inv($cust);
        }

    $this->load->view('receipt/sales_list',$data);
}

public function get_due_inv()
    {
    $section = $this->pm->get_due_inv($_POST['id']);
    $someJSON = json_encode($section);
    echo $someJSON;
}

public function all_sales_reports()
    {
    $data['title'] = 'Sales Report';

    $where = array(
        'compid' => $_SESSION['compid'],
            );
    $data['customer'] = $this->pm->get_data('customers',$where);
    $data['employee'] = $this->pm->get_data('users',$where);
    $data['company'] = $this->pm->get_data('com_profile',false);

    if(isset($_GET['search']))
        {
        $report = $_GET['reports'];
        
        if($report == 'dailyReports')
            {
            $sdate = date("Y-m-d", strtotime($_GET['sdate']));
            $edate = date("Y-m-d", strtotime($_GET['edate']));
            $customer = $_GET['dcustomer'];
            $employee = $_GET['demployee'];
            $compid = $_GET['dsmethod'];
            $data['sdate'] = $sdate;
            $data['edate'] = $edate;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;
            //var_dump($employee); exit();
            $data['sales'] = $this->pm->get_dsales_data($sdate,$edate,$customer,$employee,$compid);
            }
        else if ($report == 'monthlyReports')
            {
            $month = $_GET['month'];
            $data['month'] = $month;
            $year = $_GET['year'];
            $data['year'] = $year;
            //var_dump($data['month']); exit();
            if($month == 01)
                {
                $name = 'January';
                }
            elseif ($month == 02)
                {
                $name = 'February';
                }
            elseif ($month == 03)
                {
                $name = 'March';
                }
            elseif ($month == 04)
                {
                $name = 'April';
                }
            elseif ($month == 05)
                {
                $name = 'May';
                }
            elseif ($month == 06)
                {
                $name = 'June';
                }
            elseif ($month == 07)
                {
                $name = 'July';
                }
            elseif ($month == 8)
                {
                $name = 'August';
                }
            elseif ($month == 9)
                {
                $name = 'September';
                }
            elseif ($month == 10)
                {
                $name = 'October';
                }
            elseif ($month == 11)
                {
                $name = 'November';
                }
            else
                {
                $name = 'December';
                }
            $customer = $_GET['mcustomer'];
            $employee = $_GET['memployee'];
            $compid = $_GET['msmethod'];
            $data['name'] = $name;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;

            $data['sales'] = $this->pm->get_msales_data($month,$year,$customer,$employee,$compid);
            }
        else if ($report == 'yearlyReports')
            {
            $year = $_GET['ryear'];
            $customer = $_GET['mcustomer'];
            $employee = $_GET['memployee'];
            $compid = $_GET['ysmethod'];
            $data['year'] = $year;
            $data['report'] = $report;
            $data['customer'] = $customer;
            $data['employee'] = $employee;
            $data['compid'] = $compid;

            $data['sales'] = $this->pm->get_ysales_data($year,$customer,$employee,$compid);
            }
        }
    else
        {
        $data['sales'] = $this->pm->get_sales_data();
        }

    $this->load->view('sale/all_sales',$data);
}

///////////////////////////////////////// Payment ////////////////////////////////////////////

public function pay_list()
    {
    $data['title'] = 'Payment';
    
    $other = array(
        'join' => 'left',
        'order_by' => 'pp_id'
            );
    $field = array(
        'purchase_payment' => 'purchase_payment.*',
        'purchase' => 'purchase.challanNo, purchase.totalPrice, purchase.paidAmount, purchase.due'
            );
    $join = array(
        'purchase' => 'purchase.purchaseID = purchase_payment.pur_id'
            );

    // $data['sales'] = $this->pm->get_data('purchase_payment',false,$field,$join,$other);
    $data['sales'] = $this->pm->get_data('purchase_payment',false);

    $this->load->view('receipt/pay_list',$data);
}

public function new_pay()
    {
    $data['title'] = 'Payment';
    
    $other = array(
        'join' => 'left',
        'order_by' => 'purchaseID'
            );
    $field = array(
        'purchase' => 'purchase.*',
        'suppliers' => 'suppliers.supplierName,suppliers.mobile'
            );
    $join = array(
        'suppliers' => 'suppliers.supplierID = purchase.supplier'
            );
    $data['purchase'] = $this->pm->get_data('purchase',false,$field,$join,$other);

    $data['supplier'] = $this->pm->get_data('suppliers',false);
    $data['product'] = $this->pm->get_data('products',false);

    $this->load->view('receipt/NewPay',$data);
}

public function get_purchase_supplier()
    {
    $other = array(
        'order_by' => 'supplierID'
            );
    $where = $_SESSION['compid'];
    $section = $this->pm->get_data_with_pay_due($where);
    $someJSON = json_encode($section);
    echo $someJSON;
}

public function save_paid_pay()
    {        
    $info = $this->input->post();
    $length = count($info['checkbox']);
    // var_dump($length, $info['checkbox']);die;
    $query = $this->db->select('pp_id')
                  ->from('purchase_payment')
                  ->limit(1)
                  ->order_by('pp_id','DESC')
                  ->get()
                  ->row();
    if($query)
        {
        $sn = $query->pp_id+1;
        }
    else
        {
        $sn = 1;
        }
    $cn = strtoupper(substr($_SESSION['compname'],0,3));
    $pc = sprintf("%'05d", $sn);

    $cusid = 'PAY-'.$cn.$pc;
        
    $pData = array(
        'payCode'    => $cusid,
        'payDate'     => date('Y-m-d', strtotime($info['date'])),
        'amount'      => $info['amount'],  // Subtract only what's due for the current invoice
        'supplierID'  => $info['supplierID'],
        'remarks'     => $info['remarks'],
        'accountType' => $info['accountType'],
        'accountNo'   => $info['accountNo'],
        'regby'       => $_SESSION['uid']
    );
    
    // var_dump($rData);die;

    $result = $this->pm->insert_data('purchase_payment', $pData);
    
    $remainingPayment = floatval(str_replace(',', '', $info['amount'])); // The total amount paid
    
    for($i = 0; $i < $length; $i++) {
        // Get the sales payment ID
        
        $where = array('purchaseID' => $info['checkbox'][$i]);
        $shistory = $this->db->select('paidAmount, due')->from('purchase')->where('purchaseID', $info['checkbox'][$i])->get()->row();
        
        // Convert string values to float to avoid issues with calculations
        $paidAmount = floatval($shistory->paidAmount);
        $dueAmount = floatval($shistory->due);

        // Make sure we subtract the due amount specific to the invoice and not total
        $paidForInvoice = min($dueAmount, $remainingPayment);

        $emps = array(
            'pp_id' => $result,
            'pur_id'      => $info['checkbox'][$i],
            'pAmount' => $paidForInvoice,
            'regby'  => $_SESSION['uid']
                    );
        // var_dump($emps);
        $result3 = $this->pm->insert_data('purchase_payment_details',$emps);
        $data = [
            'paidAmount' => $paidForInvoice + $shistory->paidAmount,
            'due'  => $shistory->due - $paidForInvoice,
            'upby'       => $_SESSION['uid']
                ];
                // var_dump($shistory->paidAmount, $shistory->dueamount, $info['amount'], $info['checkbox'][$i]);
                // var_dump($data); 
        $result2 = $this->pm->update_data('purchase',$data,$where);
        // Subtract the amount paid for this invoice from the remaining payment
        $remainingPayment -= $paidForInvoice;
    
        // Break if there is no remaining payment left to distribute
        if ($remainingPayment <= 0) {
            break;
        }
    }
// exit();
    if($result)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
            <h4><i class="icon fa fa-check"></i> Purchase Payments added Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Payment');
}

public function view_pay($id)
    {
    $data['title'] = 'Payment Invoice';

    $where = array(
        'pp_id' => $id
            );
    $other = array(
        'join' => 'left'
            );
    $field = array(
        'purchase_payment' => 'purchase_payment.*',
        'suppliers' => 'suppliers.supplierName, suppliers.mobile, suppliers.address',
            );
    $join = array(
        'suppliers' => 'suppliers.supplierID = purchase_payment.supplierID',
            );
    $prints = $this->pm->get_data('purchase_payment',$where,$field,$join,$other);
    $data['prints'] = $prints[0];

    $pfield = array(
        'purchase_payment_details' => 'purchase_payment_details.*',
        'purchase' => 'purchase.challanNo, purchase.totalPrice, purchase.due, purchase.paidAmount',
            );
    $pjoin = array(
        'purchase' => 'purchase.purchaseID = purchase_payment_details.pur_id',
            );

    $data['salesp'] = $this->pm->get_data('purchase_payment_details',$where,$pfield,$pjoin,$other);
    
    $data['company'] = $this->pm->company_details();
    
    $this->load->view('receipt/viewPay',$data);
}

public function delete_pay_receipt($id)
    {
    $where = array(
        'pp_id' => $id
            );
    //var_dump($sale); exit();
    $result = $this->pm->delete_data('sales',$where);
    
    $pproduct = $this->pm->get_data('sale_product',$where);
    //var_dump($pproduct); exit();
    $result2 = $this->pm->delete_data('sale_product',$where);

  $length = count($pproduct);

  for($i = 0; $i < $length; $i++)
    {
    $swhere = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID']
            );

    $spd = $this->pm->get_data('stock',$swhere);
    
    $this->pm->delete_data('stock',$swhere);
        
    if($spd)
      {
      if($pproduct)
        {
        $tquantity = ($spd[0]['totalPices']+$pproduct[$i]['quantity']);
        $dtqnt = $spd[0]['dtquantity'];
        }
      else
        {
        $tquantity = $spd[0]['totalPices'];
        $dtqnt = $spd[0]['dtquantity'];
        }
      }
    else
      {
      $tquantity = 0;
      $dtqnt = 0;
      }

    $stock_info = array(
      'compid'  => $_SESSION['compid'],
      'product' => $pproduct[$i]['productID'],
      'totalPices'  => $tquantity,
      'dtquantity'  => $dtqnt,
      'regby'   => $_SESSION['uid']
              );
        //var_dump($stock_info);    
    $this->pm->insert_data('stock',$stock_info); 
    }
    
    if($result && $result2)
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-check"></i>Sale product delete Successfully !</h4>
            </div>'
                ];  
        }
    else
        {
        $sdata = [
          'exception' =>'<div class="alert alert-danger alert-dismissible">
            <h4><i class="icon fa fa-ban"></i> Failed !</h4>
            </div>'
                ];
        }
    $this->session->set_userdata($sdata);
    redirect('Sale');
}

public function cust_all_pay_invoices()
    {
    $data['title'] = 'Receipt';

    $where = array(
        'compid' => $_SESSION['compid'],
            );
            
    $data['company'] = $this->pm->get_data('com_profile',false);

    if(isset($_GET['search']))
        {
        $cust = $_GET['customerID'];
        // var_dump($cust);die;
        $data['dueinv'] = $this->pm->get_due_inv($cust);
        }

    $this->load->view('receipt/sales_list',$data);
}

public function get_pay_due_inv()
    {
    $section = $this->pm->get_pur_due_inv($_POST['id']);
    $someJSON = json_encode($section);
    echo $someJSON;
}


}