<?php
if(!defined('BASEPATH'))
  exit('No direct script access allowed');

class Order extends CI_Controller {

public function __construct()
  {
  parent::__construct();
  $this->load->model("prime_model","pm");
  $this->checkPermission();
}

public function index()
  {
  $data['title'] = 'Order';

  $where = array(
    'order.compid' => $_SESSION['compid']
        );
  $other = array(
    'order_by' => 'oid',
    'join' => 'left'
        );
  $field = array(
    'order' => 'order.*',
    'customers' => 'customers.customerName,customers.mobile'
        );
  $join = array(
    'customers' => 'customers.customerID = order.custid'
        );

  $data['order'] = $this->pm->get_data('order',$where,$field,$join,$other);
  //var_dump($data['purchase']); exit();
  $this->load->view('order/order_list',$data);
}

public function new_order() 
  {
  $data['title'] = 'Order';

  $where = array(
    'compid' => $_SESSION['compid']
        );

  $data['product'] = $this->pm->get_data('products',$where);

  $this->load->view('order/new_order',$data);
}

public function getProduct($id)
  {
  $where = array(
    'productID' => $id
        );
  $other = array(
    'join' => 'left'
        );
  $field = array(
    'products' => 'products.*',
    'stock' => 'stock.totalPices'
        );
  $join = array(
    'stock' => 'products.productID = stock.product'
        );
  $productlist = $this->pm->get_data('products',$where,$field,$join,$other);

  $str = "";
  foreach ($productlist as $value)
    {
    $id = $value['productID'];
    $str .= "<tr>
    <td><input type='text' name='productName[]' value='".$value['productName']."' required ><input type='hidden' readonly='readonly' name='product_id[]' value='".$value['productID']."'></td>
    <td><input type='text' id='quantity_".$value['productID']."' onkeyup='getTotal(".$id.")' name='quantity[]' value='0'></td>
    <td>".$value['sprice']."<input type='hidden' onkeyup='getTotal(".$id.")' id='tp_".$value['productID']."' name='tp[]' value='".$value['sprice']."'></td>
    <td>
    <input readonly='readonly' type='text' id='totalPrice_".$value['productID']."' name='total_price[]' value='0.00' readonly>
    </td><td>
    <span class='item_remove btn btn-danger btn-xs' onClick='$(this).parent().parent().remove();'>x</span>
    </td></tr>";
    }
  echo json_encode($str);
}

public function save_order()
  {
  $info = $this->input->post();

  $query = $this->db->select('oid')
                ->from('order')
                ->where('compid',$_SESSION['compid'])
                ->limit(1)
                ->order_by('oid','DESC')
                ->get()
                ->row();
  if($query)
    {
    $sn = $query->oid+1;
    }
  else
    {
    $sn = 1;
    }

  $cn = strtoupper(substr($_SESSION['compname'],0,3));
  $pc = sprintf("%'05d",$sn);

  $cusid = $cn.'O-'.$pc;

  $quotation = array(
    'compid'  => $_SESSION['compid'],
    'oCode'   => $cusid,
    'oDate'   => date('Y-m-d',strtotime($info['date'])),
    'custid'  => $info['customerID'],
    'tAmount' => $info['totalPrice'],
    'paidAmount' => $info['paidAmount'],
    'dueAmount'  => $info['dueAmount'],
    'scost'     => $info['shiping_cost'],
    //'dOption' => $info['dOption'],
    'shmethod' => $info['shmethod'],
    'sCompany'       => $info['sCompany'],
    'sName'          => $info['sName'],
    'sMobile'        => $info['sMobile'],
    'sAddress'       => $info['sAddress'],
    'note'    => $info['note'],
    'regby'   => $_SESSION['uid']
        );
      //var_dump($quotation); exit();
    $result = $this->pm->insert_data('order',$quotation);
        //var_dump($purchase_id); exit();

  if($result)
    {
    $msg = 'Your Order Has Been Placed, Invoice Number#'.$cusid.' Order Value TK '.$info['totalPrice'].'
            Helpline: 01969904004,You will get notify by Redx or Pathao.
            Style & Splash';
    
    $id = $info['customerID'];
    
    $mid = $this->pm->get_customer_data($id);

    $to = urlencode($mid->mobile);
    $token = urlencode("363e5be3-4832-4951-9287-dca28b860944");
    $message = urlencode($msg);
    $sid = "STYLESPLASHOTP";
    $url = "https://smsplus.sslwireless.com/api/v3/send-sms?api_token=$token&sid=$sid&sms=$message&msisdn=$to&csms_id=1";
    
    $data = array(
        'to'      => "$to",
        'message' => "$message",
        'token'   =>"$token"
          );
        //var_dump($data); //exit();
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,$url);
    curl_setopt($ch, CURLOPT_ENCODING, '');
    curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $smsresult = curl_exec($ch);
    //var_dump($smsresult); exit();
        
    $length = count($info['product_id']);
    
    for($i = 0; $i < $length; $i++)
      {
      $qdata = array(
        'oid'     => $result,
        'product' => $info['product_id'][$i],
        'pName'      => $info['productName'][$i],
        'oPrice'  => $info['tp'][$i],
        'oQnt'    => $info['quantity'][$i],                 
        'tPrice'  => $info['total_price'][$i],
        'regby'   => $_SESSION['uid']
            );
      //var_dump($purchase_product);            
      $result2 = $this->pm->insert_data('order_product',$qdata);
      }
    }
  if($result2)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Order add Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Order');
}

public function view_Order($id)
  {
  $data['title'] = 'Order';

  $where = array(
    'oid' => $id
        );
  $join = array(
    'products' => 'products.productID = order_product.product',
    'sma_units' => 'sma_units.id = products.unit'
        );
  $data['pquotation'] = $this->pm->get_data('order_product',$where,false,$join);
  
  $field = array(
    'order' => 'order.*',
    'customers'=>'customers.*',
    'users'=>'users.name'
        );

  $join = array(
    'customers' => 'customers.customerID = order.custid',
    'users' => 'users.uid = order.regby'
        );
  $quotation = $this->pm->get_data('order',$where,$field,$join);
  $data['quotation'] = $quotation[0];    
  
  $data['company'] = $this->pm->company_details();
  
  $this->load->view('order/view_order',$data);
}

public function edit_Order($id)
  {
  $data['title'] = 'Order';

  $cwhere = array(
    'compid' => $_SESSION['compid']
        );
  $data['customer'] = $this->pm->get_data('customers',$cwhere);
  $data['product'] = $this->pm->get_data('products',$cwhere);

  $where = array(
    'oid' => $id
        );
  $join = array(
    'products' => 'products.productID = order_product.product'
        );
  $data['pquotation'] = $this->pm->get_data('order_product',$where,false,$join);

  $quotation = $this->pm->get_data('order',$where);
  $data['quotation'] = $quotation[0];    
  
  $this->load->view('order/edit_order',$data);
}

public function update_Order()
  {
  $info = $this->input->post();

  $where = array(
    'oid' => $info['oid']
        );

  $quotation = array(
    'compid'  => $_SESSION['compid'],
    'oDate'   => date('Y-m-d',strtotime($info['date'])),
    'custid'  => $info['customer'],
    'tAmount' => $info['totalPrice'],
    'paidAmount' => $info['paidAmount'],
    'dueAmount'  => $info['dueAmount'],
    'scost'   => $info['shiping_cost'],
    //'dOption' => $info['dOption'],
    'shmethod' => $info['shmethod'],
    'sCompany'       => $info['sCompany'],
    'sName'          => $info['sName'],
    'sMobile'        => $info['sMobile'],
    'sAddress'       => $info['sAddress'],
    'note'    => $info['note'],
    'upby'    => $_SESSION['uid']
        );

  $result = $this->pm->update_data('order',$quotation,$where);

  $this->pm->delete_data('order_product',$where);
  
  $length = count($this->input->post('product_id'));

  for($i = 0; $i < $length; $i++)
    {
    $qproduct = array(
      'oid'     => $info['oid'],
      'product' => $info['product_id'][$i],
      'pName'      => $info['productName'][$i],
      'oPrice'  => $info['tp'][$i],
      'oQnt'    => $info['quantity'][$i],                 
      'tPrice'  => $info['total_price'][$i],
      'regby'   => $_SESSION['uid']
          );
    //var_dump($quotation_product); exit();
    $result2 = $this->pm->insert_data('order_product',$qproduct);
    }
  if($result && $result2)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Order update Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Order');
}

public function delete_Order($id)
  {
  $where = array(
    'oid' => $id
        );

  $result = $this->pm->delete_data('order',$where);
  $result2 = $this->pm->delete_data('order_product',$where);
  
  if($result && $result2)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Order delete Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Order');
}

public function cancel_Order($id)
  {
  $where = array(
    'oid' => $id
        );

  $quotation = array(
    'status' => 5,
    'upby'   => $_SESSION['uid']
        );

  $result = $this->pm->update_data('order',$quotation,$where);
  
  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Cancel delete Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Order');
}

public function sale_Order($id)
  {
  $data['title'] = 'Order';

  $cwhere = array(
    'compid' => $_SESSION['compid']
        );
  $data['customer'] = $this->pm->get_data('customers',$cwhere);
  $data['product'] = $this->pm->get_data('products',$cwhere);

  $where = array(
    'oid' => $id
        );
  $join = array(
    'products' => 'products.productID = order_product.product'
        );
  $data['pquotation'] = $this->pm->get_data('order_product',$where,false,$join);

  $quotation = $this->pm->get_data('order',$where);
  $data['quotation'] = $quotation[0];    
  
  $this->load->view('order/sale_order',$data);
}

public function savle_sale_Order()
  {
  $info = $this->input->post();

  $where = array(
    'oid' => $info['oid']
        );

  $order = array(
    'status' => 2,
    'upby'   => $_SESSION['uid']
        );

  $this->pm->update_data('order',$order,$where);

  $query = $this->db->select('saleID')
                  ->from('sales')
                  ->limit(1)
                  ->order_by('saleID','DESC')
                  ->get()
                  ->row();
  if($query)
    {
    $sn = $query->saleID+1;
    }
  else
    {
    $sn = 1;
    }
  $cn = strtoupper(substr($_SESSION['compname'],0,3));
  $pc = sprintf("%'05d", $sn);

  //$cusid = 'INV-'.$cn.$pc;
  $cusid = $pc;

  $quotation = array(
    'compid'      => $_SESSION['compid'],
    'invoice_no'  => $cusid,
    'saleDate'    => date('Y-m-d',strtotime($info['date'])),
    'customerID'  => $info['customer'],
    'totalAmount' => $info['totalPrice'],
    'paidAmount'  => $info['paidAmount'],
    'scost'       => $info['shiping_cost'],
    'dOption'     => $info['dOption'],
    'accountType' => 'Cash',
    'accountNo'   => 1,
    'note'        => $info['note'],
    'sstatus'     => 'Online Sell',
    'regby'       => $_SESSION['uid']
        );
      //var_dump($quotation); exit();
  $result = $this->pm->insert_data('sales',$quotation);
        //var_dump($purchase_id); exit();
  if($result)
    {
    $length = count($info['product_id']);
    
    for($i = 0; $i < $length; $i++)
      {
      $qdata = array(
        'saleID'     => $result,
        'productID'  => $info['product_id'][$i],
        'sprice'     => $info['tp'][$i],
        'quantity'   => $info['quantity'][$i],                 
        'totalPrice' => $info['total_price'][$i],
        'regby'      => $_SESSION['uid']
            );
      //var_dump($purchase_product);            
      $result2 = $this->pm->insert_data('sale_product',$qdata);

      $pid = $info['product_id'][$i];
      $aid = $_SESSION['compid'];

      $swhere = array(
        'product' => $pid,
        'compid' => $aid
                );

      $stpd = $this->pm->get_data('stock',$swhere);

      $this->pm->delete_data('stock',$swhere);

      if($stpd)
        {
        $tquantity = $stpd[0]['totalPices']-($info['quantity'][$i]);
        }
      else
        {
        $tquantity = -''.($info['quantity'][$i]);
        }

      $stock_info = array(
        'compid'     => $_SESSION['compid'],
        'product'    => $pid,
        'totalPices' => $tquantity,
        'regby'      => $_SESSION['uid']
                );
      //var_dump($stock_info);    
      $this->pm->insert_data('stock',$stock_info);  
      }
    }
  if($result2)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
        <h4><i class="icon fa fa-check"></i> Order sale add Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
        <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Order');
}

public function order_ledger_report()
  {
  $data['title'] = 'Order Report';
  $data['customer'] = $this->pm->get_data('users',false);
  $data['company'] = $this->pm->company_details();

  if(isset($_GET['search']))
    {
    $report = $_GET['reports'];
    if($report == 'dailyReports')
      {
      $sdate = date("Y-m-d", strtotime($_GET['sdate']));
      $edate = date("Y-m-d", strtotime($_GET['edate']));
      $data['sdate'] = $sdate;
      $data['edate'] = $edate;
      $data['report'] = $report;
      $uid = $_GET['dcustomer'];
      
      $where = array(
        'uid' => $uid
            );
      $data['users'] = $this->pm->get_data('users',$where);
      $data['sale'] = $this->pm->user_dorder_ledger($uid,$sdate,$edate);
      }
    else if ($report == 'monthlyReports')
      {
      $month = $_GET['month'];
      $data['month'] = $month;
      $year = $_GET['year'];
      $data['year'] = $year;

      if($month == 01)
        {
        $name = 'January';
        }
      elseif ($month == 02)
        {
        $name = 'February';
        }
      elseif ($month == 03)
        {
        $name = 'March';
        }
      elseif ($month == 04)
        {
        $name = 'April';
        }
      elseif ($month == 05)
        {
        $name = 'May';
        }
      elseif ($month == 06)
        {
        $name = 'June';
        }
      elseif ($month == 07)
        {
        $name = 'July';
        }
      elseif ($month == 8)
        {
        $name = 'August';
        }
      elseif ($month == 9)
        {
        $name = 'September';
        }
      elseif ($month == 10)
        {
        $name = 'October';
        }
      elseif ($month == 11)
        {
        $name = 'November';
        }
      else
        {
        $name = 'December';
        }
      $data['name'] = $name;
      $data['report'] = $report;
      $uid = $_GET['mcustomer'];
      
      $where = array(
        'uid' => $uid
            );
      $data['users'] = $this->pm->get_data('users',$where);
      $data['sale'] = $this->pm->user_morder_ledger($uid,$month,$year);
      }
    else if ($report == 'yearlyReports')
      {
      $year = $_GET['ryear'];
      $data['year'] = $year;
      $data['report'] = $report;
      $uid = $_GET['ycustomer'];
      
      $where = array(
        'uid' => $uid
            );
      $data['users'] = $this->pm->get_data('users',$where);
      $data['sale'] = $this->pm->user_yorder_ledger($uid,$year);
      }
    else if ($report == 'allReports')
      {
      $uid = $_GET['customer'];
      $data['report'] = $report;
      
      $where = array(
        'uid' => $uid
            );
      $data['users'] = $this->pm->get_data('users',$where);
      $data['sale'] = $this->pm->user_aorder_ledger($uid);
      }
    }
  else
    {
    }

  $this->load->view('order/order_report',$data);
}










}