<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Employee_payment extends CI_Controller{

public function __construct()
    {
    parent::__construct();       
    $this->load->model("prime_model","pm");
    $this->checkPermission();
}

public function index()
    {
    $data['title'] = 'Employee Payments';

    $where = array(
        'employee_payment.compid' => $_SESSION['compid']
            );
    $field = array(
        'employee_payment' => 'employee_payment.*',
        'employees' => 'employees.employeeName,employees.emp_id'
            );
    $join = array(
        'employees' => 'employee_payment.empid = employees.employeeID'
            );
    $other = array(
        'order_by' => 'empid',
        'join' => 'left'
            );
    
    $data['employees'] = $this->pm->get_data('employee_payment',$where,$field,$join,$other);

    $this->load->view('employeePayment/infos',$data);
}

public function AddInfo()
    {
    $data['title'] = 'Employee Payment';
      $where = array(
        'compid' => $_SESSION['compid'],
        'status' => 'Active'
            );
    $data['employee'] = $this->pm->get_data('employees',$where);

    $this->load->view('employeePayment/new_payment',$data);
}

public function get_emp_salary()
    {
     //$mid = 01; $yid = 2020; $id = 1;
  $section = $this->pm->get_salary_emp($_POST['mid'],$_POST['yid'],$_POST['id']);
    //$someJSON = json_encode($section);
    //echo $someJSON;
  $sstrac = $this->db->select('*')->from('salary_structure')->where('ssid',1)->get()->row();
  $str='';
    $empid = $section->employeeID;
    $salary = $section->salary;
    $basic = (($section->salary*$sstrac->basic)/100);
    $convence = (($section->salary*$sstrac->childAl)/100);
    $rent = (($section->salary*$sstrac->hrent)/100);
    $medical = (($section->salary*$sstrac->medical)/100);
    $str.="<tr>
    <td>".$section->employeeName."<input type='hidden' name='empid[]' value='".$empid."'></td>
    <td>".$section->salary."<input type='hidden' name='salary[]' id='salary' value='".$section->salary."'></td>
    <td>".$basic."<input type='hidden' name='basic[]' value='".$basic."'></td>
    <td>".$convence."<input type='hidden' name='convence[]' value='".$convence."'></td>
    <td>".$rent."<input type='hidden' name='rent[]' value='".$rent."'></td>
    <td>".$medical."<input type='hidden' name='medical[]' value='".$medical."'></td>
    <td><input type='text' class='form-control' onkeyup='totalPrice()' name='attday[]' id='attday' value='0' ></td>
    <td><input type='text' class='form-control' onkeyup='totalPrice()' name='advance[]' id='advance' value='0' ></td>
    <td><input type='text' class='form-control' onkeyup='totalPrice()' name='bonus[]' id='bonus' value='0' ></td>
    <td><input type='text' class='totalPrice form-control' name='payment[]' id='payment' value='".$section->salary."' readonly ></td></tr>";
    
  echo json_encode($str);
}

public function Saveinfo()
  {        
  $info = $this->input->post();
  $length = count($info['empid']);

  for ($i = 0; $i < $length; $i++)
    {
    $emps = array(
        'empid'       => $info['empid'][$i],
        'compid'      => $_SESSION['compid'],
        'month'       => $info['month'],
        'year'        => $info['year'],
        'salary'      => $info['salary'][$i],
        'attday'      => $info['attday'][$i],
        'tSalary'     => $info['basic'][$i],
        'allowance'   => $info['convence'][$i],
        'hrAmount'    => $info['rent'][$i],
        'mallowance'  => $info['medical'][$i],
        'aAmount'     => $info['advance'][$i],
        'bonus'       => $info['bonus'][$i],
        'pAmount'     => $info['payment'][$i],
        'accountType' => $info['accountType'],
        'accountNo'   => $info['accountNo'],
        'note'        => $info['note'],
        'regby'       => $_SESSION['uid']
                );
    //var_dump($emps); exit();
    $result = $this->pm->insert_data('employee_payment',$emps);
    }
    // if($result)
    //     {
        $sdata = [
          'exception' =>'<div class="alert alert-success alert-dismissible">
          <h4><i class="icon fa fa-check"></i> Employee Payment added Successfully !</h4></div>'
                ];  
    //     }
    //   else
    //     {
    //     $sdata = [
    //       'exception' =>'<div class="alert alert-danger alert-dismissible">
    //       <h4><i class="icon fa fa-ban"></i> Failed !</h4></div>'
    //             ];
    //     }
    $this->session->set_userdata($sdata);
    redirect('empPayment');
}

public function emp_payment_details($id)
    {
    $data['title'] = 'Employee Payment';

    $data['company'] = $this->pm->company_details();

    $where = array(
        'epid' => $id
            );
    $field = array(
        'employee_payment' => 'employee_payment.*',
        'employees' => 'employees.employeeName,employees.empaddress,employees.phone,employees.email,employees.emp_id',
        'department' => 'department.*',
        // 'com_profile' => 'com_profile.com_pid,com_profile.com_name'
            );
    $join = array(
        'employees' => 'employees.employeeID = employee_payment.empid',
        'department' => 'department.dpt_id = employees.dpt_id',
        // 'com_profile' => 'com_profile.compid = employee_payment.compid'
            );
    $other = array(
        'join' => 'left'
            );
    $collection = $this->pm->get_data('employee_payment',$where,$field,$join,$other);
    $data['empp'] = $collection[0];

    $this->load->view('employeePayment/emppDetails',$data);
}

public function employee_payment_ledger()
  {
  $data = ['title' => 'Employee Payment'];
  $data['company'] = $this->pm->company_details();
  $data['employee'] = $this->pm->get_data('employees',false);
  
  if(isset($_GET['search']))
    {
    $report = $_GET['reports'];
      
    if($report == 'monthlyReports')
      {
      $month = $_GET['month'];
      $data['month'] = $month;
      $year = $_GET['year'];
      $data['year'] = $year;
      
      if($month == 01)
        {
        $name = 'January';
        }
      else if($month == 02)
        {
        $name = 'February';
        }
      else if($month == 03)
        {
        $name = 'March';
        }
      else if($month == 04)
        {
        $name = 'April';
        }
      else if($month == 05)
        {
        $name = 'May';
        }
      else if($month == 06)
        {
        $name = 'June';
        }
      else if($month == 07)
        {
        $name = 'July';
        }
      else if($month == 8)
        {
        $name = 'August';
        }
      else if($month == 9)
        {
        $name = 'September';
        }
      else if($month == 10)
        {
        $name = 'October';
        }
      else if($month == 11)
        {
        $name = 'November';
        }
      else
        {
        $name = 'December';
        }
      $data['name'] = $name;
      $data['report'] = $report;
      
      $empid = $_GET['memp'];
      $where = array('employeeID' => $empid);

      $data['emp'] = $this->pm->get_data('employees',$where);
      $data['payment'] = $this->pm->get_memp_payment_ledger_data($month,$year,$empid);
      }
    else if($report == 'yearlyReports')
      {
      $year = $_GET['ryear'];
      $data['year'] = $year;
      $data['report'] = $report;
      
      $empid = $_GET['yemp'];
      $where = array('employeeID' => $empid);

      $data['emp'] = $this->pm->get_data('employees',$where);
      $data['payment'] = $this->pm->get_yemp_payment_ledger_data($year,$empid);
      }
    else if($report == 'ocust')
      {
      $data['report'] = $report;
      $empid = $_GET['emp'];
      $where = array('employeeID' => $empid);

      $data['emp'] = $this->pm->get_data('employees',$where);
      $data['payment'] = $this->pm->get_emp_payment_ledger_data($empid);
      }
    }
  else
    {
    $data['payment'] = '';
    }
    //var_dump('Hello');
  $this->load->view('employeePayment/payment_ledger',$data);
}





}