<?php
if(!defined('BASEPATH'))
  exit('No direct script access allowed');

class Company extends  CI_Controller {

public function __construct()
  {
  parent::__construct();
  $this->load->model("prime_model","pm");
  $this->checkPermission();
}

public function index()
  {              
  $data['title'] = 'Company / Warehouse';
  $other = array(
    'order_by' => 'com_pid'           
          );
  $where = array(
    'com_pid >' => 1
        );
  $data['company'] = $this->pm->get_data('com_profile',$where,false,false,$other);
    
  $this->load->view('companys/companys',$data);
}

public function save_company()
  {
  $info = $this->input->post(); 

  $cdata = array(
    'com_name'    => $info['com_name'],
    'com_mobile'  => $info['com_mobile'],
    'com_email'   => $info['com_email'],
    'com_address' => $info['com_address'],
    'com_vat'     => $info['com_vat'], 
    'regby'       => $_SESSION['uid']
            );

  $result = $this->pm->insert_data('com_profile',$cdata);
    
  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
      <h4><i class="icon fa fa-check"></i> Company add Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
      <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Company');
}

public function get_company_data()
  {
  $section = $this->pm->get_company_data($_POST['id']);
  $someJSON = json_encode($section);
  echo $someJSON;
}

public function update_company()
  {
  $info = $this->input->post();

  $cdata = array(
    'com_name'    => $info['com_name'],
    'com_mobile'  => $info['com_mobile'],
    'com_email'   => $info['com_email'],
    'com_address' => $info['com_address'],
    'com_vat'     => $info['com_vat'], 
    'upby'        => $_SESSION['uid']
          );

  $where = array(
    'com_pid' => $info['compid']
        );
    //var_dump($cdata); var_dump($where); exit();
  $result = $this->pm->update_data('com_profile',$cdata,$where);             
    
  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
      <h4><i class="icon fa fa-check"></i> Company update Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
      <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Company');
}

public function delete_company($id)
  {
  $where = array(
    'com_pid' => $id
        );
  
  $result = $this->pm->delete_data('com_profile',$where);             
    
  if($result)
    {
    $sdata = [
      'exception' =>'<div class="alert alert-success alert-dismissible">
      <h4><i class="icon fa fa-check"></i> Company delete Successfully !</h4>
        </div>'
            ];  
    }
  else
    {
    $sdata = [
      'exception' =>'<div class="alert alert-danger alert-dismissible">
      <h4><i class="icon fa fa-ban"></i> Failed !</h4>
        </div>'
            ];
    }
  $this->session->set_userdata($sdata);
  redirect('Company');
}





}